

<?php $__env->startSection('title', 'Categories Listing'); ?>

<?php $__env->startSection('headSource'); ?>
<!-- Datatable -->
<link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Task Sheets</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Categories</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Categories</h4>
                    <?php if(checkPermission('addCategory', Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                    <span class="pull-right"><a href="<?php echo e(route("portal.addCategoryPage")); ?>" class="btn btn-primary btn-sm"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add new category</a></span>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th>Sr</th>
                                    <th>Title</th>
                                    <th>Status</th>
                                    <th>Created At</th>
                                    <?php if((checkPermission('editCategory', Auth::user()->role) || checkPermission('deleteCategory', Auth::user()->role)) || Auth::user()->role == 'SuperAdmin'): ?>
                                    <th>Action</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($record->title); ?></td>
                                        <td> <?php echo ($record->status == 1) ? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">In-Active</span>'; ?> </td>
                                        <td><?php echo e(Carbon\Carbon::parse($record->created_at)->format('d M, Y h:i A')); ?></td>
                                        <td>
                                            <div class="d-flex">
                                                <?php if(checkPermission('editCategory',Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                                                <a href="<?php echo e(route('portal.editCategoryPage', ["id" => $record->id])); ?>" class="btn btn-primary shadow sharp mr-1"><i class="fa fa-pencil"></i> Edit</a>
                                                <?php endif; ?>
                                                <?php if(checkPermission('deleteCategory',Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                                                <a href="<?php echo e(route('portal.deleteCategoryRequest', ["id" => $record->id])); ?>" class="deletedBtn btn btn-danger shadow sharp"><i class="fa fa-trash"></i> Delete</a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <!-- Datatable -->
    <script src="<?php echo asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js'); ?>"></script>
    <script>
        $(document).ready(function () {
            // list table
            $('#datatable').DataTable({
                columnDefs: [
                    { orderable: false, targets: 6, width: '220px' },
                ],
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/categories/index.blade.php ENDPATH**/ ?>