<?php

namespace App\Http\Controllers\ApiController\StaffController;

use App\Services\UserService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DashboardController extends Controller
{
    // get profile detail
    public function profileDetail(UserService $userService){
        return $userService->getStaffProfile(request()->user());
    }

    // update user profile detail
    public function updateProfile(Request $request, UserService $userService){
        return $userService->staffProfileUpdate($request);
    }

    // update user profile image
    public function updateProfileImg(Request $request, UserService $userService){
        return $userService->updateProfileImg($request);
    }

    // get client listing of current staff
    public function staffClientListing(Request $request, UserService $userService){
        return $userService->staffClientListing($request, request()->user()->id, $request->type);
    }
}
