<?php

namespace App\Http\Controllers\PortalController;

use App\Services\DataSheetService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DataSheetController extends Controller
{
    // data sheet listing page
    public function dataSheetPage(DataSheetService $dataSheetService){
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (checkPermission('viewSheetUser',Auth::user()->role) || Auth::user()->role=='SuperAdmin') {
          return $dataSheetService->dataSheetPage();
        }
        return view("auth.login", compact('authMessage'));
    }

    // add new data sheet page
    public function addNewDataSheet(DataSheetService $dataSheetService){
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (checkPermission('addNewSheet',Auth::user()->role) || Auth::user()->role=='SuperAdmin') {
            return $dataSheetService->addDataSheet();
        }
        return view("auth.login", compact('authMessage'));
    }

    // add new data sheet request
    public function addNewDataSheetRequest(Request $request, DataSheetService $dataSheetService){

           return $dataSheetService->addNewDataSheetRequest($request);

    }

    // edit data sheet
    public function editDataSheet($id, DataSheetService $dataSheetService){
        return $dataSheetService->editDataSheet($id);
    }

    // update data sheet
    public function updateDataSheetRequest(Request $request, DataSheetService $dataSheetService){
        return $dataSheetService->updateDataSheetRequest($request);
    }

    // view data sheet page
    public function viewDataSheet($id, DataSheetService $dataSheetService){
        return $dataSheetService->viewDataSheetPage($id);

    }

    // delete data sheet
    public function deleteDataSheet($id, DataSheetService $dataSheetService){
        return $dataSheetService->deleteDataSheet($id);
    }

    // add sheet task
    public function addSheetTask($id, DataSheetService $dataSheetService){
        return $dataSheetService->addSheetTaskPage($id);
    }

    // add sheet task request
    public function addSheetTaskRequest(Request $request, DataSheetService $dataSheetService){
        return $dataSheetService->addSheetTaskRequest($request);
    }

    // edit sheet task
    public function editSheetTask($id, DataSheetService $dataSheetService){
        return $dataSheetService->editSheetTaskPage($id);
    }

    // update sheet task request
    public function updateSheetTaskRequest(Request $request, DataSheetService $dataSheetService){
        return $dataSheetService->updateSheetTaskRequest($request);
    }

    // delete sheet question
    public function deleteSheetTask($id, DataSheetService $dataSheetService){
        return $dataSheetService->deleteSheetTask($id);
    }

    // add answer in task request
    public function addAnswerInTaskRequest(Request $request, DataSheetService $dataSheetService){
        return $dataSheetService->addAnswerInTaskRequest($request);
    }

    // delete answer in task
    public function deleteAnswerInTask($id, DataSheetService $dataSheetService){
        return $dataSheetService->deleteAnswerInTask($id);
    }

    // assign category to user
    public function assignCategoryToSheetRequest(Request $request, DataSheetService $dataSheetService){
        return $dataSheetService->assignCategoryToSheetRequest($request);
    }

    // remove category from user
    public function removeCategoryFromSheet($id, DataSheetService $dataSheetService){
        return $dataSheetService->removeCategoryFromSheet($id);
    }
}
