<?php

namespace App\Http\Controllers\PortalController;

use App\Permission;
use App\Services\UserService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use App\Mail\Welcome;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;


class UserController extends Controller
{


    // user list page
    public function userFilterList($type = "all", $branch = '')
    {
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";

        if (checkPermission('viewUser', $type)) {
            if (Auth::user()->role == 'Coordinator' && $type == 'executive' && !$branch) {
                $branch = Auth::user()->id;
            }
            Session::put('branch', $branch); // Last Branch
            Session::put('type', $type); // Last Branch
            $branchName = '';
            if ($branch) {
                $branchName = User::find($branch)->name;
            }
            $getCoordinatorData = User::select('id')->where(['id' => $branch, 'role' => 'Coordinator'])->first();
            $showAddBtn = $type == 'client' && $getCoordinatorData ? false : true;
            return view("portal.users.index", compact("type", "branchName", "branch", 'showAddBtn'));
        }
        return view("auth.login", compact('authMessage'));
    }

    public function userFilterBranchList($type = "all")
    {
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (checkPermission('viewUser', $type)) {

            return view("portal.users.index", compact("type"));
        }
        return view("auth.login", compact('authMessage'));
    }

    public function userPermissionList($type = 'SuperAdmin')
    {
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (checkPermission('viewUser', Auth::user()->role)) {
            $permissions = Permission::where('role', 'SuperAdmin')->get();
            return view("portal.users.permissions", compact("permissions", "type"));
        }
        return view("auth.login", compact('authMessage'));
    }

    // get user list ajax datatable
    public function userFilterListRequest(UserService $userService, $type, $branch = '')
    {
//        if (Auth::user()->role == 'Coordinator') {
//            $branch = Auth::user()->id;
//        }
        return $userService->userFilterListAjax($type, $branch);
    }


// add new user page
    public function addNewUser(Request $request)
    {
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (checkPermission('addUser', $request->type)) {
            $type = "";
            if ($request->type == "superadmin" || $request->type == "coordinator" || $request->type == "executive" || $request->type == "manager" || $request->type == "admin" || $request->type == "staff" || $request->type == "client") {
                $type = ucfirst($request->type);
            }
            $branch = $request->branch;

            return view("portal.users.addUser", compact("type", "branch"));
        }
        return view("auth.login", compact('authMessage'));


    }

    // add new user request
    public function addNewUserRequest(Request $request, UserService $userService)
    {

        return $userService->addNewUserRequest($request);

    }

    public function addUserPermissions(Request $request, UserService $userService)
    {
        return $userService->addUserPermissions($request);

    }

    // edit user page
    public function editUser($id, UserService $userService)
    {
        $user = User::find($id);

        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
//      if (checkPermission('editUser',$user->role) && ($user->branch_id==Auth::user()->id || Auth::user()->role=='SuperAdmin' || Auth::user()->role=='Admin')) {
        if (checkPermission('editUser', $user->role) || Auth::user()->role == 'SuperAdmin') {
            $executiveId = '';
            $executiveIdsArr = [];
            if (Auth::user()->role == 'Coordinator') {
//                $getExecutive = User::select('id')->where(['id' => $user->branch_id, 'branch_id' => Auth::user()->id, 'role' => 'Executive'])->first();
//                $executiveId = $getExecutive ? $getExecutive->id : '';
                $getExecutiveIds = User::selectRaw('GROUP_CONCAT(id) as ids')->where(['branch_id' => Auth::user()->id, 'role' => 'Executive'])->first();
                $executiveIdsArr = $getExecutiveIds ? explode(',', $getExecutiveIds->ids) : [];
            }
            if ($user->branch_id == Auth::user()->id || in_array($user->branch_id, $executiveIdsArr) || Auth::user()->role == 'SuperAdmin') {
                return $userService->editUserPage($id);
            }
        }
        return view("auth.login", compact('authMessage'));
    }

    // update user request
    public function updateUserRequest(Request $request, UserService $userService)
    {
        return $userService->updateUserRequest($request);
    }

    // update user status
    public function updateUserStatus(Request $request, UserService $userService)
    {
        return $userService->updateUserStatus($request);
    }

    // view user page
    public function viewUser($id, UserService $userService)
    {
        return $userService->viewUserPage($id);
    }

    // delete user
    public function deleteUser($id, UserService $userService)
    {
        $user = User::find($id);
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";

        if (checkPermission('deleteUser', $user->role)  ($user->branch_id == Auth::user()->id || Auth::user()->role == 'SuperAdmin')) {
            return $userService->deleteUser($id);
        }
        return view("auth.login", compact('authMessage'));
    }

    // assign client to staff
    public function assignClientToStaffRequest(Request $request, UserService $userService)
    {
        return $userService->assignClientToStaffRequest($request);
    }

    // remove client from staff
    public function removeClientFromStaff($id, UserService $userService)
    {
        return $userService->removeClientFromStaff($id);
    }

    public function testEmail(Request $request)
    {

        $data = array('name' => "Virat Gandhi");

        Mail::send(['text' => 'mail'], $data, function ($message) {
            $message->to('muhammadsajidjaved@gmail.com', 'Tutorials Point')->subject('Laravel Basic Testing Mail');
            $message->from('info@dropryde.com', 'BBCare');
        });

    }

// Move client from executive to another section
    public function moveClients(UserService $userService)
    {
        $authMessage = "Not Authorized! Please contact with the SuperAdmin";
        if (Auth::user()->role == 'SuperAdmin' || Auth::user()->role == 'Coordinator') {
            return $userService->moveClientsPage();
        }
        return view("auth.login", compact('authMessage'));
    }

// get selected executive coordinator clients
    public function getExecutiveClientsRequest(Request $request, UserService $userService)
    {
        return $userService->getExecutiveClientsRequest($request);
    }

    public function moveExecutiveClientsRequest(Request $request, UserService $userService)
    {
        return $userService->moveExecutiveClientsRequest($request);
    }

    // assign category to user
    public function assignCategoryToUserRequest(Request $request, UserService $userService)
    {
        return $userService->assignCategoryToUserRequest($request);
    }

    // remove category from user
    public function removeCategoryFromUser($id, UserService $userService)
    {
        return $userService->removeCategoryFromUser($id);
    }

    public function getUsers(Request $request, UserService $userService)
    {
        return $userService->getUsers($request);
    }
}
