<?php


namespace App\Services;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\User;

class DashboardService
{
    // main dashboard page
    public function mainDashboard(){
        $executiveIds = [];
        if (Auth::user()->role == 'Coordinator') {
//            $getExecutiveIds =  DB::table('users')->selectRaw('GROUP_CONCAT(id) as ids')->where(['branch_id' => Auth::user()->id, 'role' => 'Executive'])->first();
//            $executiveIds = $getExecutiveIds->ids !== null ? explode(',', $getExecutiveIds->ids) : [];
            $executiveIds = User::where(['branch_id' => Auth::user()->id, 'role' => 'Executive'])->pluck('id');
            $executiveCount = $executiveIds->count();
            $userRoles = DB::table('users')->selectRaw('role,branch_id, count(id) as total_user')->whereIn('branch_id', $executiveIds)->groupBy('role')->get();
        } else if (Auth::user()->role == 'Executive') {
            $executiveCount = User::where(['role' => 'Executive', 'branch_id' =>  Auth::user()->branch_id])->count();
            $userRoles = DB::table('users')->selectRaw('role,branch_id, count(id) as total_user')->where('branch_id', Auth::user()->id)->groupBy('role')->get();
        } else {
            $rolesArr = ['Manager', 'Admin', 'Staff', 'Client'];
            if (in_array(Auth::user()->role, $rolesArr)) {
                $userRoles = DB::table('users')->selectRaw('role,branch_id, count(id) as total_user')->where('branch_id', Auth::user()->branch_id)->groupBy('role')->get();
            }
            $userRoles = DB::table('users')->selectRaw('role,branch_id, count(id) as total_user')->groupBy('role')->get();
            $executiveCount = @$userRoles->where('role', 'Executive')->first()->total_user;
        }

//      $superAdminCount = $coordinatorCount = $executiveCount = $managerCount = $adminCount = $staffCount = $clientCount = 0;
        $superAdminCount = @$userRoles->where("role", "SuperAdmin")->first()->total_user;
        $coordinatorCount = @$userRoles->where("role", "Coordinator")->first()->total_user;
        $managerCount =@$userRoles->where("role", "Manager")->first()->total_user;
        $adminCount = @$userRoles->where("role", "Admin")->first()->total_user;
        $staffCount = @$userRoles->where("role", "Staff")->first()->total_user;
        $clientCount = @$userRoles->where("role", "Client")->first()->total_user;

        // assigned clients
        //DB::enableQueryLog(); // Enable query log
        $assignedClientsCount = $dataSheetCount = $submitSheetCount = $todaySubmitSheetCount = 0;
        $last7DaysStaff = $last7DaysSubmitSheets = [];
        if (Auth::user()->role == 'SuperAdmin') {
            $assignedClientsCount = DB::table('users')
                ->join("staff_pivot_clients", "users.id", "=", "staff_pivot_clients.client_id")
                ->where("users.role", "Client")
                ->groupBy("users.id")->get()->count();

            //dd(DB::getQueryLog()); // Show results of log

            // data sheet count
            $dataSheetCount = DB::table('data_sheets')->count();

            // submit sheet count
            $submitSheetCount = DB::table('task_reports')->count();

            // today submit sheet count
            $todaySubmitSheetCount = DB::table('task_reports')->whereDate("created_at", Carbon::today()->toDateString())->count();

            // last 7 days Which Staff Submit How Much Sheets
            $last7DaysStaff = DB::table('users')
                ->select('users.*', DB::raw("count(task_reports.id) as sheetCount"))
                ->join('task_reports', 'users.id', '=', 'task_reports.staff_id')
                ->where('users.role', 'Staff')
                ->whereRaw('task_reports.created_at >= NOW() - INTERVAL 7 DAY')
                ->having('sheetCount', '>', 0)
                ->get();
        }

        if (Auth::user()->role == 'SuperAdmin' || Auth::user()->role == 'Coordinator' || Auth::user()->role == 'Executive') {
            // last 7 days submit sheet data
            $last7DaysSubmitSheets = DB::table('task_reports')
                ->selectRaw("DATE_FORMAT(created_at, '%d %M') as date, DATE_FORMAT(created_at, '%d') as day, count(id) as sheetSubmit")
                ->whereRaw('created_at >= NOW() - INTERVAL 7 DAY');

                if (Auth::user()->role == 'Coordinator') {
                    $clients = User::whereIn('branch_id', $executiveIds)->where(['role' => 'Client'])->pluck('id');
                    $last7DaysSubmitSheets = $last7DaysSubmitSheets->whereIn('client_id', $clients);
                } else {
                    $clients = User::where(['branch_id' => Auth::user()->id, 'role' => 'Client'])->pluck('id');
                    $last7DaysSubmitSheets = $last7DaysSubmitSheets->whereIn('client_id', $clients);
                }

            $last7DaysSubmitSheets = $last7DaysSubmitSheets->groupBy("date")->pluck("sheetSubmit", "day")->toArray();
            $last7DaysSubmitSheets = $this->makeBarGraphFormat($last7DaysSubmitSheets);
        }

        return view("portal.dashboard.index", compact("superAdminCount", "coordinatorCount", "executiveCount","managerCount", "adminCount", "staffCount", "clientCount", "assignedClientsCount", "dataSheetCount", "submitSheetCount", "todaySubmitSheetCount", "last7DaysSubmitSheets", "last7DaysStaff"));
    }

    private function makeBarGraphFormat($monthValArr){
        $returnData = [];
        $getDates = HelperServices::getDatesBwDates(Carbon::now()->subDays(6), Carbon::now());
        foreach($getDates as $date){
            $dayWithoutMonth = explode(" ", $date);
            $dayWithoutMonth = $dayWithoutMonth[0];
            $label = $date;
            $data = 0;
            if(array_key_exists($dayWithoutMonth, $monthValArr)){
                $data = $monthValArr[$dayWithoutMonth];
            }
            $returnData[] = [
                "label" => $label,
                "data" => $data,
            ];
        }
        return $returnData;
    }
}
