<?php


namespace App\Services;

use App\ClientFeedback;
use Illuminate\Support\Facades\Validator;

class FeedbackService
{

    public function addClientFeedbackRequest($request, $clientId)
    {
        $customMsgs = ['title.required' => 'Please enter title.', 'message.required' => 'Please enter message.'];
        $rules = ['title' => 'required|string', 'message' => 'required|string|min:10'];
        $validator = Validator::make($request->all(), $rules, $customMsgs);
        if ($validator->fails()) {
            $errorArray = HelperServices::validationErrorFormat($validator->errors());
            return HelperServices::returnJsonResponse(2, 'Validation Errors', [], $errorArray, 422);
        }
        if (ClientFeedback::create(['client_id' => $clientId, 'title' => $request->title, 'message' => $request->message])) {
            return HelperServices::returnJsonResponse(1, 'Feedback submitted successfully.');
        } else {
            return HelperServices::returnJsonResponse(0, 'Feedback not submitted.');
        }
    }

}
