@extends('layouts.app')

@section('title', 'Add New User')

@section('headSource')
    <!-- Daterange picker -->
    <link href="{!! asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.css') !!}" rel="stylesheet">
@endsection

@section('content')
    @php $isSuperAdmin = Auth::user()->role == 'SuperAdmin' ? true : false; @endphp
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add New {{ !empty($type)?ucfirst($type):'User' }}</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('portal.dashboard')}}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Users</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Add New {{ !empty($type)?ucfirst($type):'User' }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-user"></i> User details</h3>
                </div>
                <div class="card-body">
                    <form id="userAddForm" method="post" enctype="multipart/form-data" autocomplete="off">
                        <div class="row">
                            <div class="col-lg-9 col-xl-9">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Full name (required)</label>
                                            <input class="form-control" name="name" type="text" required />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Valid Email (required)</label>
                                            <input class="form-control" name="email" type="email" required />
                                        </div>
                                    </div>
                                </div>
{{--                                @if(strtolower($type) != 'client')--}}
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Username (required)</label>
                                                <input class="form-control" name="username" autocomplete="off" type="text" required />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Password (required)</label>
                                                <input class="form-control" name="password" autocomplete="new-password" type="password" required />
                                            </div>
                                        </div>
                                    </div>
{{--                                @endif--}}
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Date Of Birth</label>
                                            <input class="form-control date-picker" name="date_of_birth" autocomplete="off" type="text" />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Gender</label>
                                            <select class="form-control form-control-lg" name="gender">
                                                <option value="Male">Male</option>
                                                <option value="Female">Female</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Address</label>
                                            <input class="form-control" name="address" type="text" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Phone Number</label>
                                            <input class="form-control" name="phone_number" type="text" />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Emergency Phone Number</label>
                                            <input class="form-control" name="emergency_contact" type="text" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Role</label>
                                            @if($type == "")
                                                <select id="roleChanger" class="form-control form-control-lg" name="role">
                                                    <option value="SuperAdmin">Super Admin</option>
                                                    <option value="Coordinator">Coordinator</option>
                                                    <option value="Executive">Executive</option>
                                                    <option value="Manager">Manager</option>
                                                    <option value="Admin">Admin</option>
                                                    <option value="Staff">Staff</option>
                                                    <option value="Client">Client</option>
                                                </select>
                                            @else
                                                <h5>{{$type}}</h5>
                                                <input class="form-control" name="role" type="hidden" value="{{$type}}"/>
                                                <input class="form-control" name="branch_id" type="hidden" value="{{!isset($branch) ? 0 : $branch}}"/>
                                            @endif
                                        </div>
                                    </div>
                                    <div id="employeeIdField" class="col-lg-6" {!! ($type == "Staff")? '': 'style="display: none;"' !!}>
                                        <div class="form-group">
                                            <label>Employee Id (required)</label>
                                            <input class="form-control" name="employee_id" type="text"/>
                                        </div>
                                    </div>
                                    <div id="dddIdField" class="col-lg-6" {!! ($type == "Client")? '': 'style="display: none;"' !!}>
                                        <div class="form-group">
                                            <label>Identification Number (required)</label>
                                            <input class="form-control" name="ddd_id" type="text" />
                                        </div>
                                    </div>
                                    @if($isSuperAdmin)
                                    <div id="trialDropdown" class="col-lg-6" {!! ($type == "Coordinator") ? '': 'style="display: none;"' !!}>
                                        <div class="form-group">
                                            <label>Is on Trial</label>
                                            <select id="isOnTrail" class="form-control form-control-lg" name="is_on_trial">
                                                <option value="0">No</option>
                                                <option value="1">Yes</option>
                                            </select>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                                @if($isSuperAdmin)
                                <div id="trailDetailSec" class="row mt-2" style="display: none;">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Trial Expiry Date</label>
                                                <input class="form-control date-picker" name="trial_ends_at" value="{{date('m/d/Y', strtotime('+30 days'))}}" autocomplete="off" type="text"/>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Executives</label>
                                                <input class="form-control" name="allowedUsers[Executive]" autocomplete="off" value="1" type="number" min="0" />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Managers</label>
                                                <input class="form-control" name="allowedUsers[Manager]" autocomplete="off" value="0" type="number" min="0" />
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Admins</label>
                                                <input class="form-control" name="allowedUsers[Admin]" autocomplete="off" value="0" type="number" min="0" />
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Staff Members</label>
                                                <input class="form-control" name="allowedUsers[Staff]" autocomplete="off" type="number" value="1" min="0" />
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>Clients</label>
                                                <input class="form-control" name="allowedUsers[Client]" autocomplete="off" type="number" value="5" min="0" />
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="col-lg-3 col-xl-3 border-left">
                                <div id="avatar_image">
                                    <img id="thumbnailImg" alt="image" style="max-width:100px; height:auto;" src="{!! asset('images/profile.png') !!}" />
                                </div>
                                <div class="m-b-10"></div>
                                <div class="form-group">
                                    <label>Profile Image</label>
                                    <input type="file" name="thumbnail" class="form-control previewInput" data-target="#thumbnailImg">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Add {{ !empty($type)?ucfirst($type):'User' }}</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

@endsection

@section('footerSource')
    <!-- Daterangepicker -->
    <!-- momment js is must -->
    <script src="{!! asset('admin-assets/vendor/moment/moment.min.js') !!}"></script>
    <script src="{!! asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js') !!}"></script>
    <script>
        $(document).ready(function () {
            // date picker
            $('input.date-picker').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true
            });

            $("#roleChanger").change(function(e){
                let value = $(this).val();
                $("#employeeIdField, #dddIdField, #trialDropdown").hide();
                if(value == "Staff"){
                    $("#employeeIdField").show();
                } else if(value == "Client"){
                    $("#dddIdField").show();
                } else if(value == "Coordinator") {
                    $("#trialDropdown").show();
                }
            });

            $('#isOnTrail').change(function(e){
                if ($(this).val() == "1") {
                    $('#trailDetailSec').show();
                } else {
                    $('#trailDetailSec').hide();
                }
            });

            // add user form submit
            $("#userAddForm").submit(function (e) {
                e.preventDefault();
                let data = new FormData($(this)[0]);
                axios.post('{{route("portal.addNewUserRequest")}}', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.href = response.data.data.edit_url;
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
@endsection
