<?php $__env->startSection('title', 'View Data Sheet'); ?>

<?php $__env->startSection('headSource'); ?>
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/select2/css/select2.min.css'); ?>">
    <link href="<?php echo asset('admin-assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css'); ?>" rel="stylesheet">
    <!-- Datatable -->
    <link rel="stylesheet" href="<?php echo asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css'); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4><?php echo e($record->name); ?> Task Sheet</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('portal.dataSheetListPage')); ?>">Task Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">View Task Sheet</a></li>
            </ol>
        </div>
    </div>

    <!-- row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="profile card card-body px-3 pt-3 pb-0">
                <div class="profile-head">
                    <div class="profile-info">
                        <div class="profile-details">
                            <div class="profile-name px-3 pt-2">
                                <h4 class="text-primary mb-0"><?php echo e($record->name); ?></h4>
                            </div>
                            <?php if(checkPermission('editSheet',Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                            <div class="dropdown ml-auto">
                                <a href="#" class="btn btn-primary light sharp" data-toggle="dropdown" aria-expanded="true"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="18px" height="18px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"></rect><circle fill="#000000" cx="5" cy="12" r="2"></circle><circle fill="#000000" cx="12" cy="12" r="2"></circle><circle fill="#000000" cx="19" cy="12" r="2"></circle></g></svg></a>
                                <ul class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(-169px, 30px, 0px);">
                                    <li><a class="dropdown-item" href="<?php echo route("portal.editDataSheetPage", ["id" => $record->id]); ?>"> <i class="fa fa-pencil text-primary mr-2"></i> Edit </a></li>
                                </ul>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="profile-tab">
                <div class="custom-tab-1">
                    <ul class="nav nav-tabs">
                        <li class="nav-item"><a href="#tasksTab" data-toggle="tab" class="nav-link active show">Tasks</a>
                        </li>
                        <li class="nav-item"><a href="#categoryTab" data-toggle="tab" class="nav-link">Categories</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div id="tasksTab" class="tab-pane fade active show">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Tasks</h4>
                                    <?php if(checkPermission('addTask',Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                                        <span class="pull-right"><a
                                                href="<?php echo e(route("portal.addSheetTaskPage", ["id" => $record->id])); ?>"
                                                class="btn btn-primary btn-sm">
                            <i class="fa fa-plus-circle" aria-hidden="true"></i> Add new task</a></span>
                                    <?php endif; ?>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="display listing-table" style="min-width: 845px">
                                            <thead>
                                            <tr>
                                                <th>Sr</th>
                                                <th>Title</th>
                                                <th>Progress Note</th>
                                                
                                                <th>Status</th>
                                                <th>Created At</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $record->tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    if ($task->is_new) {
                                                        $notesArr = json_decode($task->progress_note);
                                                        $progressNote = $notesArr ? $notesArr[0] : 'N/A';
                                                    } else
                                                        $progressNote = $task->progress_note;
                                                ?>
                                                <tr>
                                                    <td><?php echo e($loop->iteration); ?></td>
                                                    <td><?php echo e($task->title); ?></td>
                                                    <td><?php echo e(substr($progressNote, 0, 50)); ?></td>
                                                    
                                                    <td> <?php echo ($task->status == 1)? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">Inactive</span>'; ?> </td>
                                                    <td><?php echo e(Carbon\Carbon::parse($record->created_at)->format('d M, Y h:i A')); ?></td>
                                                    <td width="20%">
                                                        <div class="d-flex">
                                                            <?php if(checkPermission('editTask',Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                                                                <a href="<?php echo e(route('portal.editSheetTaskPage', ["id" => $task->id])); ?>"
                                                                   class="btn btn-primary shadow sharp mr-1"><i
                                                                        class="fa fa-pencil"></i> Edit</a>
                                                            <?php endif; ?>
                                                            <?php if(checkPermission('deleteTask',Auth::user()->role) || Auth::user()->role=='SuperAdmin'): ?>
                                                                <a href="<?php echo e(route('portal.deleteSheetTask', ["id" => $task->id])); ?>"
                                                                   class="deletedBtn btn btn-danger shadow sharp"><i
                                                                        class="fa fa-trash"></i> Delete</a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="categoryTab" class="tab-pane fade">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Categories</h4>
                                </div>
                                <div class="card-body">
                                    <div class="pt-4">
                                        <div class="settings-form">
                                            <h4 class="text-primary">Assign New Categories</h4>
                                            <form id="assignCategoryToSheetForm">
                                                <div class="row">
                                                    <div class="col-sm-8">
                                                        <div class="form-group">
                                                            <label>Choose Categories</label>
                                                            <select class="multi-select select2-dropdown"
                                                                    name="categories[]" multiple="multiple" required>
                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4" style="margin-top: 30px">
                                                        <button class="btn btn-sm btn-primary" type="submit">Assign</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <h4 class="text-primary mb-4">Assigned Categories</h4>
                                        <div class="table-responsive">
                                            <table class="display listing-table" style="min-width: 845px">
                                                <thead>
                                                <tr>
                                                    <th>Sr</th>
                                                    <th>Title</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $__currentLoopData = $record->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        <td><?php echo e($item->title); ?></td>
                                                        <td>
                                                            <a href="<?php echo e(route("portal.removeCategoryFromSheetRequest", ["id" => $item->pivot->id])); ?>" class="deletedBtn btn btn-danger mr-1 shadow sharp"><i class="fa fa-trash"></i> Remove</a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footerSource'); ?>
    <script src="<?php echo asset('admin-assets/vendor/select2/js/select2.full.min.js'); ?>"></script>
    <!-- Datatable -->
    <script src="<?php echo asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js'); ?>"></script>
    <script>
        $(document).ready(function (e) {
            // question listing
            $('.select2-dropdown').select2({placeholder: 'Select Categories'});
            $('.listing-table').DataTable();

            $("#assignCategoryToSheetForm").submit(function (e) {
                e.preventDefault();
                let data = $(this).serialize()+"&id=<?php echo e($record->id); ?>";
                axios.post('<?php echo e(route("portal.assignCategoryToSheetRequest")); ?>', data)
                    .then(function (response) {
                        if(response.data.response_code == 1){
                            successMsg(response.data.message);
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            errorMsg(response.data.message);
                        }
                    })
                    .catch(function (error) {

                    });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/bbcareapp/resources/views/portal/dataSheets/viewDataSheet.blade.php ENDPATH**/ ?>