<?php

add_image_size('kidzo_100x90', 100, 90, true); // Sidebar Latest News
add_image_size('kidzo_80x80', 80, 80, true); // Testimonial Author Image
add_image_size('kidzo_370x350', 370, 350, true); // Case Study Grid
add_image_size('kidzo_570x855', 570, 855, true); // Case Study Image
add_image_size('kidzo_203x173', 203, 173, true); // Service Image
add_image_size('kidzo_360x720', 360, 720, true); // Social Slid Image
add_image_size('kidzo_970x500', 970, 500, true); //Video Feature Image
add_image_size('kidzo_100x100', 100, 100, true); //Testimonial Feature Image
add_image_size('kidzo_195x235', 195, 235, true); //Event Block Feature Image
add_image_size('kidzo_515x300', 515, 300, true); //Event Block Feature Image


add_image_size('kidzo_270x320', 270, 320, true); // Protuct Grid thumbnail
add_image_size('kidzo_300x320', 300, 320, true); 
add_image_size('kidzo_450x420', 450, 420, true); // Shop list view thumbnail
add_image_size('kidzo_570x350', 570, 350, true); // Shop list view thumbnail



// Elementor is anchor external target
function kidzo_is_external($settings_key) {
    if(isset($settings_key['is_external'])) {
        echo $settings_key['is_external'] == true ? 'target="_blank"' : '';
    }
}


function kidzo_icon_array($k, $replace = 'icon', $separator = '-') {
    $v = array();
    foreach ($k as $kv) {
        $kv = str_replace($separator, ' ', $kv);
        $kv = str_replace($replace, '', $kv);
        $v[] = array_push($v, ucwords($kv));
    }
    foreach($v as $key => $value) if($key&1) unset($v[$key]);
    return array_combine($k, $v);
}


// Social Share
function kidzo_social_share() { ?>
<div class="social_icon">
    <?php esc_html_e('share:', 'kidzo-core') ?>
    <ul class="list-unstyled">
        <li><a href="https://facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i
                    class="social_facebook"></i></a></li>
        <li><a href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>"><i class="social_twitter"></i></a>
        </li>
        <li><a href="https://www.pinterest.com/pin/create/button/?url=<?php the_permalink() ?>"><i
                    class="social_pinterest"></i></a></li>
        <li><a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink() ?>"><i
                    class="social_linkedin"></i></a></li>
    </ul>
</div>
<?php
}

add_filter('gettext','kidzo_enter_title');
function kidzo_enter_title( $input ) {
    global $post_type;
    if( is_admin() && 'Enter title here' == $input && 'team' == $post_type )
        return 'Enter here the team member name';
    return $input;
}


// Category array
function kidzo_cat_array($term = 'category') {
    $cats = get_terms( array(
        'taxonomy' => $term,
        'hide_empty' => true
    ));
    $cat_array = array();
    $cat_array['all'] = esc_html__('All', 'kidzo-core');
    foreach ($cats as $cat) {
        $cat_array[$cat->slug] = $cat->name;
    }
    return $cat_array;
}


// Get the first category name
function kidzo_first_category($term = 'category') {
    $cats = get_the_terms(get_the_ID(), $term);
    $cat  = is_array($cats) ? $cats[0]->name : '';
    echo esc_html($cat);
}


// Get the first category link
function kidzo_first_category_link($term='category') {
    $cats = get_the_terms(get_the_ID(), $term);
    $cat  = is_array($cats) ? get_category_link($cats[0]->term_id) : '';
    echo esc_url($cat);
}

// Category array
function kidzoo_cat_array($term = 'category') {
    $cats = get_terms( array(
        'taxonomy' => $term,
        'hide_empty' => true
    ));
    $cat_array = array();
    $cat_array['all'] = esc_html__('All', 'kidzo-core');
    foreach ($cats as $cat) {
        $cat_array[$cat->term_id] = $cat->name;
    }
    return $cat_array;
}
/**
 * Category array
 * @param string $term
 * @return array
 */
function kidzo_pro_cat_array($term = 'category') {
    $cats = get_terms( array(
        'taxonomy' => $term,
        'hide_empty' => true
    ));
    $cat_array = array();
    $cat_array['all'] = esc_html__( 'All', 'kidzo-core');
    if( is_array( $cats ) ) {
        foreach ($cats as $cat) {
            $cat_array[$cat->slug] = $cat->name;
        }
    }
    return $cat_array;
}
// Limit latter
function kidzo_limit_char($string, $limit_length, $suffix = '...') {
    if (strlen($string) > $limit_length) {
        echo strip_shortcodes(substr($string, 0, $limit_length) . $suffix);
    }
    else {
        echo strip_shortcodes(esc_html($string));
    }
}

// Coro Product Gallery -----------------------
function kidzo_product_gallery(){
    global $product;
    $gallery_ids = $product->get_gallery_image_ids();
    echo '<div class="coro_gallery_product best_pr_slider item-slider">';
    foreach ( $gallery_ids as $gallery_id ) {
       ?>
<a href="<?php the_permalink() ?>">
    <?php echo wp_get_attachment_image( $gallery_id, 'full', array( 'class' => 'primary_thumb' ) ); ?>
</a>
<?php
    }
    echo '</div>';
}

//Features Carousel Tab data
function return_tab_data( $getCats, $feature_caro ) {
	$y = [];
	foreach ( $getCats as $val ) {

		$t = [];
		foreach( $feature_caro as $data ) {
			if( $data['t_title'] == $val ) {
				$t[] = $data;
			}
		}
		$y[$val] = $t;
	}

	return $y;
}

//Features Carousel Tab data
function return_faq_tab_data(  $get_cats , $faqs_tab ) {
	$y = [];
	foreach ( $get_cats as $val ) {

		$t = [];
		foreach( $faqs_tab as $data ) {
			if( $data['t_title'] == $val ) {
				$t[] = $data;
			}
		}
		$y[$val] = $t;
	}

	return $y;
}

// Set contact form 7 default form template
function kidzo_contact7_form_content( $template, $prop ) {

    if ( 'form' == $prop ) {
        $template = '<div class="row"><div class="col-sm-12 col-12 form-group">[text* your-name class:form-control placeholder "Your Name"]</div><div class="col-sm-12 col-12 form-group">[email* your-email class:form-control placeholder "Your Email"]</div><div class="col-sm-12 col-12 form-group">[text subject class:form-control placeholder "Subject"]</div><div class="col-sm-12 col-12 form-group">[textarea* your-message class:form-control placeholder "Message"]</div><div class="col-sm-12 col-12 form-group send_message"><button type="submit" class="kidzo_dbtn btn_border">Send Message</button></div></div>';
        return $template;
    } else {
        return $template;
    }
}
add_filter( 'wpcf7_default_template', 'kidzo_contact7_form_content', 10, 2 );


// For Product 