<?php 
if( !defined( 'WPINC' ) ){
    die;
}
/**
 * @Packge     : Happy Single Product Addon
 * @Version    : 1.0
 * @Author     : Hasan Fardous
 * @Author URI : https://me.hasanfardous.com/
 *
 */

    // Get all products
    function happy_get_all_products_id(){
        
        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => -1,
            'post_status'    => 'publish'
        );

        $loop = new WP_Query( $args );
        $product_datas = array();
        while ( $loop->have_posts() ) : $loop->the_post();
            $product_datas[get_the_ID()] = get_the_title();
        endwhile;

        wp_reset_query();

        return $product_datas;

    }

    // Get product categories
    function happy_get_categories_by_product_id( $proudct_id ){
        $terms = get_the_terms( $proudct_id, 'product_cat' );
        $categories = '';
        if ( $terms && ! is_wp_error( $terms ) ) {
            if ( ! empty( $terms ) ) {
                for ( $i = 0; $i < count( $terms ); $i++ ) {
                    $categories .= $terms[$i]->name.' ';
                }
            }
        }

        return trim( $categories );
    }

    // Calculate the discount
    function happy_get_product_discount_val( $product_id ){
    $product = wc_get_product( $product_id );
    if( $product->is_type('variable')){
        $percentages = array();
  
        // Get all variation prices
        $prices = $product->get_variation_prices();
  
        // Loop through variation prices
        foreach( $prices['price'] as $key => $price ){
            // Only on sale variations
            if( $prices['regular_price'][$key] !== $price ){
                // Calculate and set in the array the percentage for each variation on sale
                $percentages[] = round( 100 - ( floatval($prices['sale_price'][$key]) / floatval($prices['regular_price'][$key]) * 100 ) );
            }
        }
        // We keep the highest value
        $percentage = max($percentages) . '%';
  
    } elseif( $product->is_type('grouped') ){
        $percentages = array();
  
        // Get all variation prices
        $children_ids = $product->get_children();
  
        // Loop through variation prices
        foreach( $children_ids as $child_id ){
            $child_product = wc_get_product($child_id);
  
            $regular_price = (float) $child_product->get_regular_price();
            $sale_price    = (float) $child_product->get_sale_price();
  
            if ( $sale_price != 0 || ! empty($sale_price) ) {
                // Calculate and set in the array the percentage for each child on sale
                $percentages[] = round(100 - ($sale_price / $regular_price * 100));
            }
        }
        // We keep the highest value
        $percentage = max($percentages) . '%';
  
    } else {
        $regular_price = (float) $product->get_regular_price();
        $sale_price    = (float) $product->get_sale_price();
  
        if ( $sale_price != 0 || ! empty($sale_price) ) {
            $percentage    = round(100 - ($sale_price / $regular_price * 100)) . '%';
        } else {
            $percentage = esc_html__( "N/A", "happy-single-product" );
        }
    }
    return '-'.$percentage;
    }

    // Get product details by id
    function happy_get_product_details_by_id( $product_id, $sale_badge_visibility, $rating_visibility, $category_visibility, $price_visibility, $quickview_visibility ){
        $product = wc_get_product( $product_id );

        // Product datas
        $product_img = $product->get_image('medium');
        $product_title = $product->get_title();
        $product_price = $product->get_price_html();
        $product_url = $product->get_permalink( $product_id );

        // Product rating
        $rating_count = $product->get_rating_count();
        $review_count = $product->get_review_count();
        $average      = $product->get_average_rating();

        // Add to cart url
        $add_to_cart_url = esc_url( $product->add_to_cart_url() );
        ?>
<div class="happy-single-product-wrapper">
    <?php 
                // Product image
                echo '<div class="happy-product-image">';
                    echo '<a href="'.$product_url.'">'.$product_img.'</a>';

                    if ( $sale_badge_visibility == 1 ) {
                        // Product Sale Badge
                        echo '<span class="happy-product-sale-badge">'. happy_get_product_discount_val( $product_id ) . '</span>';
                    }

                    if ( $quickview_visibility == 1 ) {
                        // Product Quickview (It's a sample only that's why no popup will open)
                        echo '<a href="javascript:void(0);" id="happy-quickview"></a>';
                    }
                echo '</div>';

                if ( $rating_visibility == 1 ) {
                    // Product rating
                    if ( $rating_count >= 0 ) {
                        echo wc_get_rating_html( $average, $rating_count );
                    }
                }

                if ( $category_visibility == 1 ) {
                    // Product category
                    if ( $rating_count >= 0 ) {
                        echo '<h6 class="happy-product-categories">';
                            echo happy_get_categories_by_product_id( $product_id );
                        echo '</h6>';
                    }
                }
                
                // Product title
                if ( $rating_count >= 0 ) {
                    echo '<h2 class="happy-product-title">';
                        echo $product_title;
                    echo '</h2>';
                }

                if ( $price_visibility == 1 ) {
                    // Product price
                    if ( $rating_count >= 0 ) {
                        echo '<h3 class="happy-product-price">';
                            echo $product_price;
                        echo '</h3>';
                    }
                }

                // Product add to cart
                if ( $rating_count >= 0 ) {
                    echo '<a class="happy-add-to-cart-btn" href="'.$add_to_cart_url.'">'.esc_html__( "Add to cart", "happy-single-product" ).'</a>';
                }
            ?>
</div>
<?php

    }