<?php
/**
 * Plugin Name: Kidzo Core
 * Plugin URI: https://themeforest.net/user/droitthemes/portfolio
 * Description: This plugin adds the core features to the kidzo WordPress theme. You must have to install this plugin to get all the features included with the theme.
 * Version: 1.1.1
 * Author: DroitThemes
 * Author URI: https://themeforest.net/user/droitthemes/portfolio
 * Text domain: kidzo-core
 */

if ( !defined('ABSPATH') )
    die('-1');

// Make sure the same class is not loaded twice in free/premium versions.
if ( !class_exists( 'kidzo_core' ) ) {
	/**
	 * Main kidzo Core Class
	 *
	 * The main class that initiates and runs the kidzo Core plugin.
	 *
	 * @since 1.7.0
	 */
	class kidzo_core {
		/**
		 * kidzo Core Version
		 *
		 * Holds the version of the plugin.
		 *
		 * @since 1.7.0
		 * @since 1.7.1 Moved from property with that name to a constant.
		 *
		 * @var string The plugin version.
		 */
		const VERSION = '1.0' ;
		/**
		 * Minimum Elementor Version
		 *
		 * Holds the minimum Elementor version required to run the plugin.
		 *
		 * @since 1.7.0
		 * @since 1.7.1 Moved from property with that name to a constant.
		 *
		 * @var string Minimum Elementor version required to run the plugin.
		 */
		const MINIMUM_ELEMENTOR_VERSION = '1.7.0';
		/**
		 * Minimum PHP Version
		 *
		 * Holds the minimum PHP version required to run the plugin.
		 *
		 * @since 1.7.0
		 * @since 1.7.1 Moved from property with that name to a constant.
		 *
		 * @var string Minimum PHP version required to run the plugin.
		 */
		const  MINIMUM_PHP_VERSION = '5.4' ;
        /**
         * Plugin's directory paths
         * @since 1.0
         */
        const CSS = null;
        const JS = null;
        const IMG = null;
        const VEND = null;

		/**
		 * Instance
		 *
		 * Holds a single instance of the `kidzo_Core` class.
		 *
		 * @since 1.7.0
		 *
		 * @access private
		 * @static
		 *
		 * @var kidzo_Core A single instance of the class.
		 */
		private static  $_instance = null ;
		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 * @static
		 *
		 * @return kidzo_Core An instance of the class.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Clone
		 *
		 * Disable class cloning.
		 *
		 * @since 1.7.0
		 *
		 * @access protected
		 *
		 * @return void
		 */
		public function __clone() {
			// Cloning instances of the class is forbidden
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'kidzo-core' ), '1.7.0' );
		}

		/**
		 * Wakeup
		 *
		 * Disable unserializing the class.
		 *
		 * @since 1.7.0
		 *
		 * @access protected
		 *
		 * @return void
		 */
		public function __wakeup() {
			// Unserializing instances of the class is forbidden.
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'kidzo-core' ), '1.7.0' );
		}

		/**
		 * Constructor
		 *
		 * Initialize the kidzo Core plugins.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 */
		public function __construct() {
			$this->init_hooks();
			$this->core_includes();
			do_action( 'kidzo_core_loaded' );
		}

		/**
		 * Include Files
		 *
		 * Load core files required to run the plugin.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 */
		public function core_includes() {
			// Extra functions
			require_once __DIR__ . '/inc/extra.php';
            require_once __DIR__ . '/post-type/teachers.php';
            require_once __DIR__ . '/post-type/program.php';
			require_once __DIR__ . '/post-type/events.php';
			require_once __DIR__ . '/post-type/footer.php';
			require_once __DIR__ . '/inc/functions.php';

            /**
             * Register widget area.
             *
             * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
             */
			require_once __DIR__ . '/wp-widgets/widgets.php';

			// Elementor custom field icons
			require_once __DIR__ . '/fields/icons.php';

            // RGBA color picker
            require plugin_dir_path(__FILE__) . '/acf-rgba-color-picker/acf-rgba-color-picker.php';

            // ACF Metaboxes
            //require plugin_dir_path(__FILE__) . '/inc/metaboxes.php';
			// Parallax
            if ( is_readable( __DIR__ . '/inc/parallax/class-parallax.php') ) {
                if ( !class_exists('\DROIT_ELEMENTOR_PRO\Parallax') ) {
                    require_once __DIR__ . '/inc/parallax/class-parallax.php';
                    \DROIT_ELEMENTOR_PRO\Parallax::instance()->init();
                }
            }
		}


		/**
		 * Init Hooks
		 *
		 * Hook into actions and filters.
		 *
		 * @since 1.7.0
		 *
		 * @access private
		 */
		private function init_hooks() {
			add_action( 'init', [ $this, 'i18n' ] );
			add_action( 'plugins_loaded', [ $this, 'init' ] );

		}

		/**
		 * Load Textdomain
		 *
		 * Load plugin localization files.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 */
		public function i18n() {
			load_plugin_textdomain( 'kidzo-core', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
		}



		/**
		 * Init kidzo Core
		 *
		 * Load the plugin after Elementor (and other plugins) are loaded.
		 *
		 * @since 1.0.0
		 * @since 1.7.0 The logic moved from a standalone function to this class method.
		 *
		 * @access public
		 */
		public function init() {

			if ( !did_action( 'elementor/loaded' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
				return;
			}

			// Check for required Elementor version

			if ( !version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
				return;
			}

			// Check for required PHP version

			if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
				return;
			}

			// Add new Elementor Categories
			add_action( 'elementor/init', [ $this, 'add_elementor_category' ] );

			// Register Widget Scripts
			add_action( 'elementor/frontend/after_register_scripts', [ $this, 'register_widget_scripts' ] );
			add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'register_widget_scripts' ] );
            add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

			// Register Widget Scripts
			add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'enqueue_widget_styles' ] );
			add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'enqueue_widget_styles' ] );

			// Register New Widgets
			
			add_action( 'elementor/widgets/register', [ $this, 'on_widgets_registered' ] );

		}




		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have Elementor installed or activated.
		 *
		 * @since 1.1.0
		 * @since 1.7.0 Moved from a standalone function to a class method.
		 *
		 * @access public
		 */
		public function admin_notice_missing_main_plugin() {
			$message = sprintf(
			/* translators: 1: kidzo Core 2: Elementor */
				esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'kidzo-core' ),
				'<strong>' . esc_html__( 'kidzo core', 'kidzo-core' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'kidzo-core' ) . '</strong>'
			);
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
		}

		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have a minimum required Elementor version.
		 *
		 * @since 1.1.0
		 * @since 1.7.0 Moved from a standalone function to a class method.
		 *
		 * @access public
		 */
		public function admin_notice_minimum_elementor_version() {
			$message = sprintf(
			/* translators: 1: kidzo Core 2: Elementor 3: Required Elementor version */
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'kidzo-core' ),
				'<strong>' . esc_html__( 'kidzo Core', 'kidzo-core' ) . '</strong>',
				'<strong>' . esc_html__( 'Elementor', 'kidzo-core' ) . '</strong>',
				self::MINIMUM_ELEMENTOR_VERSION
			);
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
		}

		/**
		 * Admin notice
		 *
		 * Warning when the site doesn't have a minimum required PHP version.
		 *
		 * @since 1.7.0
		 *
		 * @access public
		 */
		public function admin_notice_minimum_php_version() {
			$message = sprintf(
			/* translators: 1: kidzo Core 2: PHP 3: Required PHP version */
				esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'kidzo-core' ),
				'<strong>' . esc_html__( 'kidzo Core', 'kidzo-core' ) . '</strong>',
				'<strong>' . esc_html__( 'PHP', 'kidzo-core' ) . '</strong>',
				self::MINIMUM_PHP_VERSION
			);
			printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
		}

		/**
		 * Add new Elementor Categories
		 *
		 * Register new widget categories for kidzo Core widgets.
		 *
		 * @since 1.0.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access public
		 */
		public function add_elementor_category() {
			\Elementor\Plugin::instance()->elements_manager->add_category( 'kidzo-elements', [
				'title' => __( 'kidzo Elements', 'kidzo-core' ),
			], 1 );
		}

		/**
		 * Register Widget Scripts
		 *
		 * Register custom scripts required to run kidzo Core.
		 *
		 * @since 1.6.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access public
		 */
		public function register_widget_scripts() {
            wp_register_script( 'ajax-chimp', plugins_url( 'assets/js/ajax-chimp.js', __FILE__ ), 'jquery', '1.0', true );

			wp_enqueue_style('flexslider', plugins_url( 'assets/vendors/flex/css/flexslider.css', __FILE__ ) );
            wp_enqueue_style('animate',  plugins_url( 'assets/vendors/animation/animate.css', __FILE__ ) );
            wp_enqueue_style('nice-select',  plugins_url( 'assets/css/nice-select.css', __FILE__ ) );
            wp_enqueue_style('themify-icon',  plugins_url( 'assets/vendors/themify-icon/themify-icons.css', __FILE__ ) );

			wp_enqueue_style('custom-css',  plugins_url( 'assets/css/custom-css.css', __FILE__ ) );

			if ( !is_admin() ) {
				wp_deregister_script( 'jquery' );
				wp_register_script( 'jquery', plugins_url( 'assets/js/jquery-3.4.1.min.js', __FILE__ ), false, '3.4.1' );
				wp_enqueue_script( 'jquery' );
			}

            wp_enqueue_script('wow',  plugins_url( 'assets/vendors/wow/wow.min.js', __FILE__ ), array('jquery'), '1.1.3', true );
			wp_enqueue_script( 'sckroller', plugins_url('assets/vendors/sckroller/jquery.parallax-scroll.js', __FILE__ ), array('jquery'), '1.0.0', true );
			wp_enqueue_script( 'stellar', plugins_url('assets/vendors/stellar/jquery.stellar.js', __FILE__ ), array('jquery'), '1.0.0', true );
            wp_enqueue_script( 'imagesloaded', plugins_url('assets/vendors/imagesloaded/imagesloaded.pkgd.min.js', __FILE__), array('jquery'), '1.0.0', true );
            wp_enqueue_script( 'isotope', plugins_url('assets/vendors/isotope/isotope-min.js', __FILE__), array('jquery'), '1.0.0', true );
            wp_enqueue_script( 'nice-select', plugins_url('assets/js/jquery.nice-select.min.js', __FILE__), array('jquery'), '1.0', true );
            wp_enqueue_script( 'flexslider', plugins_url('assets/vendors/flex/js/jquery.flexslider.js', __FILE__), array('jquery'), '2.7.1', true );

		}

		/**
		 * Register Widget Styles
		 *
		 * Register custom styles required to run kidzo Core.
		 *
		 * @since 1.7.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access public
		 */
		
		public function enqueue_widget_styles() {

		}

		public function enqueue_scripts() {

		}




		/*public function register_admin_styles() {
            wp_enqueue_style( 'kidzo_core_admin', plugins_url( 'assets/css/kidzo-core-admin.css', __FILE__ ) );
        }*/

		/**
		 * Register New Widgets
		 *
		 * Include kidzo Core widgets files and register them in Elementor.
		 *
		 * @since 1.0.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access public
		 */
		public function on_widgets_registered() {
			$this->include_widgets();
			$this->register_widgets();
		}

		/**
		 * Include Widgets Files
		 *
		 * Load kidzo Core widgets files.
		 *
		 * @since 1.0.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access private
		 */
		private function include_widgets() {

			 require_once __DIR__ . '/widgets/kidzo_about.php';
			 require_once __DIR__ . '/widgets/kidzo_teachers.php';
			 require_once __DIR__ . '/widgets/kidzo_contact.php';
			 require_once __DIR__ . '/widgets/kidzo_program.php';
			 require_once __DIR__ . '/widgets/kidzo_program_enroll.php';
			 require_once __DIR__ . '/widgets/kidzo_events.php';
			 require_once __DIR__ . '/widgets/kidzo_counter.php';
			 require_once __DIR__ . '/widgets/kidzo_hero.php';
			 require_once __DIR__ . '/widgets/kidzo_features.php';
			 require_once __DIR__ . '/widgets/kidzo_c2a.php';
			 require_once __DIR__ . '/widgets/kidzo_gallery.php';
			 require_once __DIR__ . '/widgets/kidzo_testimonials.php';
			 require_once __DIR__ . '/widgets/kidzo_blog.php';
			 require_once __DIR__ . '/widgets/kidzo_services.php';
			 require_once __DIR__ . '/widgets/kidzo_banner.php';
			 require_once __DIR__ . '/widgets/kidzo_pro_category.php';
			 require_once __DIR__ . '/widgets/kidzo_woo_product.php';
			 require_once __DIR__ . '/widgets/kidzo_single_button.php';
			 require_once __DIR__ . '/widgets/kidzo_subscriber.php';
			 require_once __DIR__ . '/widgets/kidzo_program_cat.php';
			 require_once __DIR__ . '/widgets/kidzo_card.php';
			 require_once __DIR__ . '/widgets/kidzo_title.php';
        }


		/**
		 * Register Widgets
		 *
		 * Register kidzo Core widgets.
		 *
		 * @since 1.0.0
		 * @since 1.7.1 The method moved to this class.
		 *
		 * @access private
		 */
		private function register_widgets() {
			// Site Elements

			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_about() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_teachers() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_contact() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_program() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_program_enroll() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_events() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_counter() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_hero() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_features() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_c2a() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_gallery() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_testimonials() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_blog() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_services() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_banner() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_pro_category() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_woo_product() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_single_button() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_subscriber() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_program_cat() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_card() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \kidzoCore\Widgets\kidzo_title() );
			

        }
	}
}
// Make sure the same function is not loaded twice in free/premium versions.

if ( !function_exists( 'kidzo_core_load' ) ) {
	/**
	 * Load kidzo Core
	 *
	 * Main instance of kidzo_Core.
	 *
	 * @since 1.0.0
	 * @since 1.7.0 The logic moved from this function to a class method.
	 */
	function kidzo_core_load() {
		return kidzo_core::instance();
	}

	// Run kidzo Core
    kidzo_core_load();
}


function kidzo_admin_cpt_script( $hook ) {

    global $post;

    if ( $hook == 'post-new.php' || $hook == 'post.php' ) {
        if ( 'service' === $post->post_type ) {
            wp_enqueue_style('themify-icons', plugins_url( 'assets/vendors/themify-icon/themify-icons.css', __FILE__ ));
        }
    }
}
add_action( 'admin_enqueue_scripts', 'kidzo_admin_cpt_script', 10, 1 );