<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_about extends Widget_Base {

    public function get_name() {
        return 'kidzo_about';
    }

    public function get_title() {
        return esc_html__( 'About', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {

        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'about_title',
            [
                'label' => __( 'About Title', 'kidzo-core' ),
            ]
        );

	    $this->add_control(
		    'sec_style', [
			    'label' => esc_html__( 'Select Style', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'style_1' => 'Style One',
				    'style_2' => 'Style Two',
					'style_3' => 'Style Three',
			    ],
			    'default'   => 'style_1'
		    ]
	    );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Who We Are',
            ]
        );
	    $this->add_control(
		    'title_html_tag',
		    [
			    'label' => __( 'Title HTML Tag', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'h1' => 'H1',
				    'h2' => 'H2',
				    'h3' => 'H3',
				    'h4' => 'H4',
				    'h5' => 'H5',
				    'h6' => 'H6',
				    'div' => 'div',
			    ],
			    'default' => 'h5',
			    'separator' => 'before',
		    ]
	    );

	    $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'title_typo',
                'selector' => '
                    {{WRAPPER}} .s4_about_section .about_section_content h5,
                    {{WRAPPER}} .get_start_part .get_start_content h4
                '
            ]
        );

       $this->add_control(
            'about_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .s4_about_section .about_section_content h5' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .get_start_part .get_start_content h4' => 'color: {{VALUE}};',
                ),
            ]
        );

        $this->end_controls_section();

        /*===================== Sub Title =========================*/
	    $this->start_controls_section(
		    'about_subtitle',
		    [
			    'label' => __( 'Sub-title', 'kidzo-core' ),
			    'condition' => [
                    'sec_style' => 'style_1'
                ]
		    ]
	    );
	    $this->add_control(
		    'subtitle',
		    [
			    'label' => esc_html__( 'Sub-title', 'kidzo-core' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'label_block' => true,
			    'default' => 'We Create Something New',
		    ]
	    );
	    $this->add_group_control(
		    Group_Control_Typography::get_type(), [
			    'name' => 'subtitle_typo',
			    'selector' => '
			        {{WRAPPER}} .s4_about_section .about_section_content h2',
		    ]
	    );

	    $this->add_control(
		    'subtitle_color', [
			    'label'     => esc_html__('Color', 'kidzo-core'),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => array(
				    '{{WRAPPER}} .s4_about_section .about_section_content h2' => 'color: {{VALUE}};',
			    ),
		    ]
	    );
        $this->end_controls_section();


        /*===================== Description =========================*/
        $this->start_controls_section(
            'description',
            [
                'label' => __( 'Description', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'desc_text',
            [
                'label' => esc_html__( 'Description', 'kidzo-core' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'default' => '<h5>Smart Notifications</h5>
                            <p>I quaint super he lost his bottle hotpot bleeder nicked it owt to do with me no biggie.</p>',
            ]
        );
        $this->end_controls_section();


        /*===================== Button =========================*/
        $this->start_controls_section(
            'section_button',
            [
                'label' => __( 'Button', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_2'
                ]
            ]
        );
        $this->add_control(
            'button_label',
            [
                'label' => esc_html__( 'Button Label', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Get Started',
            ]
        );
        $this->add_control(
            'button_urls',
            [
                'label' => esc_html__( 'Button Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );

        $this->start_controls_tabs(
			'style_tabs'
		);
	
		//button Style Normal Style
		$this->start_controls_tab(
			'style_normal',
			[
				'label' => __( 'Normal', 'kidzo-core' ),
			]
		);
	
		$this->add_control(
			'btn_font_color', [
				'label' => esc_html__( 'Font color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'btn_bg_color', [
				'label' => esc_html__( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'background-color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'cta_btn_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'border-color: {{VALUE}};',
				],
			]
		);
	
		$this->end_controls_tab();
		//Hover Color
		$this->start_controls_tab(
			'style_hover_btn',
			[
				'label' => __( 'Hover', 'kidzo-core' ),
			]
		);   
	
		$this->add_control(
			'hover_font_color', [
				'label' => __( 'Font Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'hover_bg_color', [
				'label' => __( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn:hover' => 'background: {{VALUE}};',
				]
	
			]
		);
	
		$this->add_control(
			'hover_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'border-color: {{VALUE}};',
				]
	
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
        // End Border Section
        
	    /*===================== Feature Images =========================*/
	    $this->start_controls_section(
		    'about_feature_img',
		    [
			    'label' => __( 'Feature Image', 'kidzo-core' ),
			    'condition' => [
                    'sec_style' => 'style_1'
                ]
		    ]
	    );
	    $this->add_control(
		    'feature_img',
		    [
			    'label' => esc_html__( 'Feature Image', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
		    ]
	    );
	    $this->add_control(
		    'feature_img_2',
		    [
			    'label' => esc_html__( 'Feature Image (Shap One)', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,

		    ]
	    );

	    $this->add_control(
		    'feature_img_shap2',
		    [
			    'label' => esc_html__( 'Feature Image (Shap Two)', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,

		    ]
	    );
	    $this->end_controls_section();
	    /*===================== Feature Images  With Videos=========================*/
	    $this->start_controls_section(
		    'about_feature_img_videos',
		    [
			    'label' => __( 'Feature Image With Videos', 'kidzo-core' ),
			    'condition' => [
                    'sec_style' => ['style_2','style_3']
                ]
		    ]
	    );
	    $this->add_control(
		    'feature_img_videos',
		    [
			    'label' => esc_html__( 'Feature Image', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
		    ]
	    );
	    
	    $this->add_control(
		    'youtube_url',
		    [
			    'label' => esc_html__( 'Videos URL', 'kidzo-core' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			    'default' => '#'
		    ]
	    );
	    $this->end_controls_section();

		/*======================= Animation Images ======================== */
        $animation_images = new \Elementor\Repeater();
        $this->start_controls_section(
            'client_images_features_sec', [
                'label' => __( 'Animation Images', 'kidzo-core' ),
            ]
        );
        $animation_images->add_control(
            'animation_img', [
                'label' => __( 'Images Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => 'Animation Images'
            ]
        );
        $animation_images->add_responsive_control(
            'possition_top_buttom',
            [
                'label' => __( 'Horizontal', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'possition_left_right',
            [
                'label' => __( 'Vertical', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


       $animation_images->add_responsive_control(
            'horizontal',
            [
                'label' => __( 'Horizontal Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'vertical',
            [
                'label' => __( 'Vertical Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
        $animation_images->add_control(
            'animation_feature_img', [
                'label' => __( 'Animation Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'feature_animation', [
                'label' => __( 'Animation', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ animation_img }}}',
                'fields' => $animation_images->get_controls(),
            ]
        );
        $this->end_controls_section();
        /*================= End Animation Images =============*/
        /**
         * Style Section
         */
        $this->start_controls_section(
            'style_sec',
            [
                'label' => __( 'Style Section', 'kidzo-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'sec_bg_color',
			    'label' => __( 'Section Background', 'kidzo-core' ),
			    'types' => [ 'classic', 'gradient' ],
			    'selector' => '
			        {{WRAPPER}} .kidzo_social_about_wrap,
			        {{WRAPPER}} .kidzo_download_app_two_wrap
                '
		    ]
	    );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
		$title_tag  = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
		$tf_features   = !empty( $settings['tf_features'] ) ? $settings['tf_features'] : ''; 
    	$animation_imags  = !empty($settings['feature_animation']) ? $settings['feature_animation'] : '';

	    if( $settings['sec_style'] == 'style_1' ) {
		?>
<section class="about_section section_padding s4_about_section">
    <div class="container custom_container">
        <div class="row justify-content-between align-items-center">
            <div class="col-sm-12 col-md-6 col-xl-5 order-2 order-md-1">
                <div class="about_section_content mt-5 mt-md-0">
                    <?php
							    if ( ! empty( $settings['title'] ) ) {
								    echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
							    }
								if ( ! empty( $settings['subtitle'] ) ) { ?>
                    <h2 class="title"><?php  echo kidzo_extention_wp_kses( $settings['subtitle'] ); ?></h2>
                    <?php 
								} 
								?>
                    <?php if ( ! empty( $settings['desc_text'] ) ) { ?>
                    <?php  echo kidzo_extention_wp_kses( $settings['desc_text'] ); ?>
                    <?php } ?>
                </div>
            </div>
            <div class="col-sm-12 col-md-6 order-1 order-md-2">
                <div class="img_section mb-4 mb-md-0">
                    <?php
							if ( ! empty( $settings['feature_img_shap2']['url'] ) ) { ?>
                    <img src="<?php echo esc_url( $settings['feature_img_shap2']['url'] ); ?>"
                        alt="<?php esc_attr__('Feature Images', 'kidzo') ?>" class="about_img_7"
                        data-parallax='{"x": 0, "y": -50, "rotateZ":0}'>
                    <?php
	                    	}if ( ! empty( $settings['feature_img']['url'] ) ) { ?>
                    <img src="<?php echo esc_url( $settings['feature_img']['url'] ); ?>"
                        alt="<?php esc_attr__('Feature Images', 'kidzo') ?>" class="about_img_6 img-fluid">
                    <?php } 
							if ( ! empty( $settings['feature_img_2']['url'] ) ) { ?>
                    <img src="<?php echo esc_url( $settings['feature_img_2']['url'] ); ?>"
                        alt="<?php esc_attr__('Feature Images', 'kidzo') ?>" class="about_img_5"
                        data-parallax='{"x": 0, "y": 50, "rotateZ":0}'>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <?php
			if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
				$i=1;
				foreach ( $animation_imags as $feature_imgs ) {
					$hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
					$varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
					$ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
					$img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
					?>
    <div
        class="about_page_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
        <div
            data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
        </div>
    </div>
    <?php 
				$i++;
				}
			} 
       		?>
</section>
<?php
	    }
	    elseif ( $settings['sec_style'] == 'style_2' ){ ?>
<section class="get_start_part section_padding section_bg">
    <div class="container custom_container">
        <div class="row justify-content-between align-items-center">
            <div class="col-lg-7 col-sm-12 wow fadeInUp" data-wow-delay=".2s"
                style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                <?php
						if ( ! empty( $settings['feature_img_videos']['url'] ) ) { ?>
                <div class="video_section">
                    <img src="<?php echo esc_url( $settings['feature_img_videos']['url'] ); ?>" alt="feature_img_videos"
                        class="img-fluid">
                    <a href="<?php echo esc_url($settings['youtube_url']); ?>" class="video_popup"><span
                            class="polygon_shape"></span></a>
                </div>
                <?php } ?>
            </div>
            <div class="col-lg-5 col-sm-12 wow fadeInUp" data-wow-delay=".5s"
                style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
                <div class="get_start_content about_section_content">
                    <?php
								if ( ! empty( $settings['title'] ) ) {
							?>
                    <h2 <?php echo $title_tag; ?> class="title">
                        <?php  echo kidzo_extention_wp_kses( $settings['title'] ); ?></h2>
                    <?php } ?>
                    <?php if ( ! empty( $settings['desc_text'] ) ) { ?>
                    <?php  echo wp_kses_post( nl2br( $settings['desc_text'] ) ); ?>
                    <?php } ?>
                    <?php if ( ! empty( $settings['button_label'] ) ) { ?>
                    <a href="<?php echo esc_url($settings['button_urls']); ?>"
                        class="get_start_btn"><?php echo kidzo_extention_wp_kses( $settings['button_label'] ); ?> <i
                            class="ti-arrow-right"></i> </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <?php
			if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
				$i=1;
				foreach ( $animation_imags as $feature_imgs ) {
					$hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
					$varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
					$ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
					$img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
					?>
    <div
        class="get_start_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
        <div
            data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
        </div>
    </div>
    <?php 
				$i++;
				}
			} 
       		?>
</section>
<?php
	    }
	    elseif ( $settings['sec_style'] == 'style_3' ){ ?>
<div class="pr_video_inner">
    <?php
								if ( ! empty( $settings['feature_img_videos']['url'] ) ) { ?>
    <div class="pr_video">
        <img src="<?php echo esc_url( $settings['feature_img_videos']['url'] ); ?>" alt="feature_img_videos"
            class="img-fluid">
        <a href="<?php echo esc_url($settings['youtube_url']); ?>" class="video_popup"><span
                class="polygon_shape"></span></a>
    </div>
    <?php } ?>
    <svg class="pc-dashes inner-dashed-border animated-dashes">
        <rect x="0px" y="0px" rx="22px" ry="22px" width="0" height="0"></rect>
    </svg>
</div>
<?php
        }
    }
}