<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_banner extends Widget_Base {

    public function get_name() {
        return 'kidzo_banner';
    }

    public function get_title() {
        return esc_html__( 'Kidzo Banner', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {

        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'banner_title',
            [
                'label' => __( 'banner Title', 'kidzo-core' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Who We Are',
            ]
        );
	    $this->add_control(
		    'title_html_tag',
		    [
			    'label' => __( 'Title HTML Tag', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'h1' => 'H1',
				    'h2' => 'H2',
				    'h3' => 'H3',
				    'h4' => 'H4',
				    'h5' => 'H5',
				    'h6' => 'H6',
				    'div' => 'div',
			    ],
			    'default' => 'h5',
			    'separator' => 'before',
		    ]
	    );

	    $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'title_typo',
                'selector' => '
                    {{WRAPPER}} .s4_banner_section .banner_section_content h5,
                    {{WRAPPER}} .get_start_part .get_start_content h4
                '
            ]
        );

       $this->add_control(
            'banner_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .s4_banner_section .banner_section_content h5' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .get_start_part .get_start_content h4' => 'color: {{VALUE}};',
                ),
            ]
        );

        $this->end_controls_section();

        /*===================== Sub Title =========================*/
	    $this->start_controls_section(
		    'banner_subtitle',
		    [
			    'label' => __( 'Sub-title', 'kidzo-core' ),
		    ]
	    );
	    $this->add_control(
		    'subtitle',
		    [
			    'label' => esc_html__( 'Sub-title', 'kidzo-core' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'label_block' => true,
			    'default' => 'We Create Something New',
		    ]
	    );
	    $this->add_group_control(
		    Group_Control_Typography::get_type(), [
			    'name' => 'subtitle_typo',
			    'selector' => '
			        {{WRAPPER}} .s4_banner_section .banner_section_content h2',
		    ]
	    );

	    $this->add_control(
		    'subtitle_color', [
			    'label'     => esc_html__('Color', 'kidzo-core'),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => array(
				    '{{WRAPPER}} .s4_banner_section .banner_section_content h2' => 'color: {{VALUE}};',
			    ),
		    ]
	    );
        $this->end_controls_section();



        /*===================== Button =========================*/
        $this->start_controls_section(
            'section_button',
            [
                'label' => __( 'Button', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'button_label',
            [
                'label' => esc_html__( 'Button Label', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Get Started',
            ]
        );
        $this->add_control(
            'button_urls',
            [
                'label' => esc_html__( 'Button Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );

        $this->start_controls_tabs(
			'style_tabs'
		);
	
		//button Style Normal Style
		$this->start_controls_tab(
			'style_normal',
			[
				'label' => __( 'Normal', 'kidzo-core' ),
			]
		);
	
		$this->add_control(
			'btn_font_color', [
				'label' => esc_html__( 'Font color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'btn_bg_color', [
				'label' => esc_html__( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'background-color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'cta_btn_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'border-color: {{VALUE}};',
				],
			]
		);
	
		$this->end_controls_tab();
		//Hover Color
		$this->start_controls_tab(
			'style_hover_btn',
			[
				'label' => __( 'Hover', 'kidzo-core' ),
			]
		);   
	
		$this->add_control(
			'hover_font_color', [
				'label' => __( 'Font Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'hover_bg_color', [
				'label' => __( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn:hover' => 'background: {{VALUE}};',
				]
	
			]
		);
	
		$this->add_control(
			'hover_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get_start_part .get_start_content .get_start_btn' => 'border-color: {{VALUE}};',
				]
	
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
        // End Border Section
        
	    /*===================== Feature Images =========================*/
	    $this->start_controls_section(
		    'banner_feature_img',
		    [
			    'label' => __( 'Feature Image', 'kidzo-core' ),
		    ]
	    );
	    $this->add_control(
		    'feature_img',
		    [
			    'label' => esc_html__( 'Feature Image', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
		    ]
	    );
	    $this->add_control(
		    'feature_img_2',
		    [
			    'label' => esc_html__( 'Feature Image (Background Shpae)', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,

		    ]
	    );


	    $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
		$title_tag  = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
		$tf_features   = !empty( $settings['tf_features'] ) ? $settings['tf_features'] : ''; 
    ?>

<!-- banner part here -->
	<section class="hero_banner_area">
		<?php if ( ! empty( $settings['feature_img_2']['url'] ) ) { ?>
        <img class="bg_shape" src="<?php echo esc_url( $settings['feature_img_2']['url'] ); ?>" alt="">
		<?php } ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <div class="hero_banner_content">

					<?php
					if ( ! empty( $settings['title'] ) ) {
						echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
					}
					if ( ! empty( $settings['subtitle'] ) ) { ?>
						<p><?php  echo kidzo_extention_wp_kses( $settings['subtitle'] ); ?></p>
					<?php 
					} 
					?>

                        <form action="#" class="subscribe_mail input-group">
                            <input type="email" class="form-control" placeholder="Enter Email address">
                            <button type="submit" class="cu_btn btn_2">Get Started</button>
                        </form>
                    </div>
                </div>
				<?php if ( ! empty( $settings['feature_img']['url'] ) ) { ?>
                <div class="col-lg-5">
                    <img src="<?php echo esc_url( $settings['feature_img']['url'] ); ?>" alt="">
                </div>
				<?php } ?>
            </div>
        </div>
    </section>
    <!-- banner part end -->



<?php

    }
}