<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_blog extends Widget_Base {

    public function get_name() {
        return 'kidzo_blog';
    }

    public function get_title() {
        return esc_html__( 'Blog Section', 'kidzo-hero' );
    }

    public function get_icon() {
        return 'eicon-menu-bar';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {

        // ------------------------------  Blog Title ------------------------------
       
        // ----------------------------------------  About content ------------------------------
        
        $this->start_controls_section(
            'blog',
            [
                'label' => __( 'Blog Section', 'kidzo-core' ),
            ]
        );
        $this->add_responsive_control(
			'kizo_section_margin',
			[
				'label' => __( 'Padding', 'kidzo-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_padding' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Blog Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => 'the Blog'
            ]
        );
        $this->add_control(
            'color_title', [
                'label' => __( 'Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 h2'
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Blog Sub Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Our Thoughts'
            ]
        );
        $this->add_control(
            'color__sub_title', [
                'label' => __( 'Sub Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'blog_typography_sub_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 p,
                '
            ]
        );
        $this->end_controls_section(); // End Blog Section 


        // ---Start Blog Setting
        $this->start_controls_section(
            'Blog_filter', [
                'label' => __( 'Blog Settings', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'all_label', [
                'label' => esc_html__( 'All filter label', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'See All'
            ]
        );
        $this->add_control(
            'show_count', [
                'label' => esc_html__( 'Show count', 'kidzo-core' ),
                'type' => Controls_Manager::NUMBER,
                'label_block' => true,
                'default' => 8
            ]
        );
        $this->add_control(
            'order', [
                'label' => esc_html__( 'Order', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => 'ASC',
                    'DESC' => 'DESC'
                ],
                'default' => 'ASC'
            ]
        );
        $this->end_controls_section();

        //---------------- Style Section --------------- // 

        $this->start_controls_section(
            'blog_style', [
                'label' => __( 'Blog Title', 'kidzo-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'img_border_radius',
            [
                'label' => __( 'Image Border Radius', 'kidzo-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .single_success_story img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Title Text Color', 'appart-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single_success_story h4 a' => 'color: {{VALUE}};', 
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'label' => 'Typography',
                'name' => 'sec_typography_title',
                'selector' => '{{WRAPPER}} .single_success_story h4 a',
                
            ]
        );

        $this->end_controls_section();   
        ///(Style) End The Blog Title Section

        ///(Style) Strat The Blog Sub Title Section
        $this->start_controls_section(
            'blog_sub_style', [
                'label' => __( 'Blog Date & Author ', 'kidzo-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sub_title_color', [
                'label' => __( 'Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_meta_list li' => 'color: {{VALUE}};', 
                ],  
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'label' => 'Typography',
                'name' => 'typography_sub_title',
                'selector' => '{{WRAPPER}} .blog_meta_list li',  
            ]
        );
      $this->end_controls_section();   
      /// End The Blog Sub Title Section

      ///(Style) Strat The Blog Sub Title Section
      $this->start_controls_section(
        'blog_button_style', [
            'label' => __( 'Blog button', 'kidzo-core' ),
            'tab'   => Controls_Manager::TAB_STYLE,
        ]
    );
    $this->add_control(
        'blog_button_color', [
            'label' => __( 'Text Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .single_success_story .read_more_btn' => 'color: {{VALUE}};', 
            ],  
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'label' => 'Typography',
            'name' => 'typography_button_blog',
            'selector' => '{{WRAPPER}} .single_success_story .read_more_btn',  
        ]
    );
  $this->end_controls_section();   
  /// End The Blog Sub Title Section


    /*======================= Animation Images ======================== */
    $animation_images = new \Elementor\Repeater();
    $this->start_controls_section(
        'client_images_features_sec', [
            'label' => __( 'Animation Images', 'kidzo-core' ),
        ]
    );
    $animation_images->add_control(
        'animation_img', [
            'label' => __( 'Images Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Animation Images'
        ]
    );
    $animation_images->add_responsive_control(
        'possition_top_buttom',
        [
            'label' => __( 'Horizontal', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'possition_left_right',
        [
            'label' => __( 'Vertical', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]
    );


   $animation_images->add_responsive_control(
        'horizontal',
        [
            'label' => __( 'Horizontal Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'vertical',
        [
            'label' => __( 'Vertical Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
    $animation_images->add_control(
        'animation_feature_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::MEDIA,
        ]
    );
    $this->add_control(
        'feature_animation', [
            'label' => __( 'Animation', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ animation_img }}}',
            'fields' => $animation_images->get_controls(),
        ]
    );
    $this->end_controls_section();
    /*================= End Feature =============*/
          
  }
    protected function render() {
	    $settings = $this->get_settings();
        $animation_imags = isset($settings['feature_animation']) ? $settings['feature_animation'] : '';

	    $blogPost = new WP_Query( array(
		    'post_type'      => 'post',
		    'posts_per_page' => $settings['show_count'],
		    'order'          => $settings['order'],
		    'post__not_in'   => ! empty( $settings['exclude'] ) ? explode( ',', $settings['exclude'] ) : ''
	    ) ); ?>

<section class="success_story section_padding">
    <div class="container custom_container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section_tittle_style_02">
                    <?php if ( ! empty( $settings['title'] ) ) { ?>
                    <h2 class="title wow fadeInDown" data-wow-delay=".5s">
                        <?php echo  kidzo_extention_wp_kses( $settings['title'] ); ?>
                    </h2>
                    <?php } ?>
                    <?php if ( ! empty( $settings['sub_title'] ) ) { ?>
                    <p class="description wow fadeInDown" data-wow-delay=".3s">
                        <?php echo kidzo_extention_wp_kses($settings['sub_title']); ?></p>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="row">
            <?php
            while ( $blogPost->have_posts() ) {
                $blogPost->the_post();
            ?>
            <div class="col-lg-4 col-sm-6 wow fadeInDown" data-wow-delay=".3s">
                <div class="single_success_story text-left">
                    <?php  if( has_post_thumbnail() ){ ?>
                    <a
                        href="<?php the_permalink(); ?>"><?php the_post_thumbnail('kidzo_350x250', array('class' => 'img-fluid')) ?></a>
                    <?php } ?>
                    <ul class="blog_meta_list">
                        <li> <?php the_time('F j, Y'); ?> </li>
                        <li><?php echo esc_html__( 'By ', 'kidzo' ); ?><?php echo get_the_author(); ?> </li>
                    </ul>

                    <h4><a
                            href="<?php the_permalink(); ?>"><?php echo  wp_trim_words( get_the_title(), 6, false ); ?></a>
                    </h4>
                    <a href="<?php the_permalink(); ?>"
                        class="read_more_btn"><?php echo esc_html__( 'Read More', 'kidzo' ); ?> <i
                            class="ti-angle-double-right"></i> </a>
                </div>
            </div>
            <?php
            }
            wp_reset_postdata();
            ?>
        </div>
    </div>
    <div class="blog_animation_home">
        <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
        <div
            class="story_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
            <div
                data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
            </div>
        </div>
        <?php 
            $i++;
            } 
        } 
    ?>
    </div>
</section>
<?php
    }
}