<?php
namespace kidzoCore\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_c2a extends Widget_Base {

	public function get_name() {
		return 'kidzo_c2a';
	}

	public function get_title() {
		return __( 'Call to Action', 'kidzo-core' );
	}

	public function get_icon() {
		return ' eicon-call-to-action';
	}

	public function get_categories() {
		return [ 'kidzo-elements' ];
	}

	protected function register_controls() {

		// ------------------------------  Title  ------------------------------
		$this->start_controls_section(
			'section_style', [
				'label' => __( 'Section Style', 'kidzo-core' ),
			]
		);
		$this->add_control(
			'select_style',
			[
				'label' => esc_html__( 'Select Feature Style', 'kidzo-core' ),
				'type' => Controls_Manager::SELECT,
				'label_block' => false,
				'options'   => [
					'style_1' => 'Style 1',
					'style_2' => 'Style 2'
				],
				'default' => 'style_1'
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'title_sec', [
				'label' => __( 'Title', 'kidzo-core' ),
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title Text', 'kidzo-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => 'Welcome To'
			]
		);

		$this->add_control(
			'title_html_tag',
			[
				'label' => __( 'Title HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'div' => 'div',
				],
				'default' => 'h5',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'color_title', [
				'label' => __( 'Text Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section_tittle_style_02 .title' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name' => 'typography_title',
				'selector' => '
					{{WRAPPER}} .section_tittle_style_02 .title,'
			]
		);

		$this->end_controls_section(); // End title section


		// ------------------------------  Subtitle ------------------------------
		$this->start_controls_section(
			'subtitle_sec', [
				'label' => __( 'Subtitle', 'kidzo-core' ),
			]
		);

		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Text', 'kidzo-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default' => 'DroitCare Child Care'
			]
		);

		$this->add_control(
			'color_subtitle', [
				'label' => __( 'Text Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section_tittle_style_02 .description' => 'color: {{VALUE}};'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name' => 'typography_subtitle',
				'selector' => '
					{{WRAPPER}} .section_tittle_style_02 .description',
			]
		);

		$this->end_controls_section(); // End title section

		$this->start_controls_section(
			'content_sec', [
				'label' => __( 'Content', 'kidzo-core' ),
			]
		);

		$this->add_control(
			'Content_info', [
				'label' => esc_html__( 'Content', 'kidzo-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default' => 'The amazing way to olor sit amet, consectetur adipisicing elit, sed do eiusmod incididunt ut labore inventore The amazing way to olor sit amet, consectetur. consectetur adipisicing elit, sed do eiusmod incididunt ut labore inventore.'
			]
		);

		$this->end_controls_section();

	 	$this->start_controls_section(
            'ca2_button',
            [
                'label' => __( 'Button', 'kidzo-core' ),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Discover Now',
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => esc_html__( 'Button URL', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
		);
		
		$this->start_controls_tabs(
			'style_tabs'
		);
	
		//button Style Normal Style
		$this->start_controls_tab(
			'style_normal',
			[
				'label' => __( 'Normal', 'kidzo-core' ),
			]
		);
	
		$this->add_control(
			'btn_font_color', [
				'label' => esc_html__( 'Font color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cu_btn' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'btn_bg_color', [
				'label' => esc_html__( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cu_btn' => 'background-color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'cta_btn_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cu_btn' => 'border-color: {{VALUE}};',
				],
			]
		);
	
		$this->end_controls_tab();
		//Hover Color
		$this->start_controls_tab(
			'style_hover_btn',
			[
				'label' => __( 'Hover', 'kidzo-core' ),
			]
		);   
	
		$this->add_control(
			'hover_font_color', [
				'label' => __( 'Font Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cu_btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'hover_bg_color', [
				'label' => __( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cu_btn:hover' => 'background: {{VALUE}};',
				]
	
			]
		);
	
		$this->add_control(
			'hover_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cu_btn' => 'border-color: {{VALUE}};',
				]
	
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

         /*===================== Animation Images =========================*/
	    $this->start_controls_section(
		    'feature_img',
		    [
			    'label' => __( 'Feature Images', 'kidzo-core' ),
		    ]
	    );
	    $this->add_control(
		    'animation_one',
		    [
			    'label' => esc_html__( 'Image One', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
		    ]
	    );
	    $this->add_control(
		    'animation_two',
		    [
			    'label' => esc_html__( 'Images Two', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,

		    ]
	    );

	    $this->add_control(
		    'animation_three',
		    [
			    'label' => esc_html__( 'Shap Images', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,

		    ]
	    );
	    $this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings();
		$select_style  = !empty($settings['select_style']) ? $settings['select_style'] : '';
		$title_tag  = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
		$title      = !empty( $settings['title'] ) ? $settings['title'] : '';
		$subtitle   = !empty( $settings['subtitle'] ) ? $settings['subtitle'] : '';
		$Content_info  = !empty( $settings['Content_info'] ) ? $settings['Content_info'] : '';
		$button_text   = !empty( $settings['button_text'] ) ? $settings['button_text'] : '';
		$button_url    = !empty( $settings['button_url'] ) ? $settings['button_url'] : '';
?>	
<?php if($select_style == 'style_1'){ ?>
<!-- services part here -->
<section class="about_section section_padding">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
					<?php
						if(!empty($title)):
							echo '<' . $title_tag . ' class="wow title fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $title ) . '</' . $title_tag . '>';
						endif;
						if(!empty($subtitle)):
					?>
						<p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($subtitle); ?></p>
					<?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
					<div class="img_section">
						<?php if(!empty($settings['animation_three']['url'])): ?>
							<img src="<?php echo esc_url($settings['animation_three']['url']); ?>" alt="<?php esc_attr__('Animation Images', 'kidzo') ?>" class="about_img_1" data-parallax='{"x": 0, "y": 30, "rotateZ":0}'>
						<?php endif; ?>
						<?php if(!empty($settings['animation_one']['url'])): ?>
							<img src="<?php echo esc_url($settings['animation_one']['url']); ?>" alt="<?php esc_attr__('Animation Images', 'kidzo') ?>" class="about_img_2" >
						<?php endif; ?>
						<?php if(!empty($settings['animation_two']['url'])): ?>
							<img src="<?php echo esc_url($settings['animation_two']['url']); ?>" alt="<?php esc_attr__('Animation Images', 'kidzo') ?>" class="about_img_3" data-parallax='{"x": 0, "y": -50, "rotateZ":0}'>
						<?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-5">
                    <div class="about_section_content">
						<p class="wow fadeInDown" data-wow-delay=".3s"><?php echo  kidzo_extention_wp_kses( $Content_info ); ?></p>
						<?php if(!empty($button_text)): ?>
                        <a class="pc-button elementor-button button-link cu_btn mt-4" href="<?php echo esc_attr($button_url); ?>">
                            <div class="button-content-wrapper ">
                                <span class="elementor-button-text"><?php echo kidzo_extention_wp_kses($button_text); ?> </span>
                                <svg class="pc-dashes inner-dashed-border animated-dashes">
                                    <rect x="5px" y="5px" rx="22px" ry="22px" width="0" height="0"></rect>
                                </svg>
                            </div>
                        </a>
						<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

 <!-- services part end -->
<?php }elseif ($select_style == 'style_2') { ?>

	<section class="about_section section_padding s3_about_section">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
					<?php
						if(!empty($title)):
							echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $title ) . '</' . $title_tag . '>';
						endif;
						if(!empty($subtitle)):
					?>
					<p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($subtitle); ?></p>
					<?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-between">
                <div class="col-md-6 col-lg-6 col-xl-5">
                    <div class="about_section_content">
						<p class="wow fadeInDown" data-wow-delay=".3s"><?php echo  kidzo_extention_wp_kses( $Content_info ); ?></p>
						<?php if(!empty($button_text)): ?>
                        <a class="pc-button elementor-button button-link cu_btn mt-4" href="<?php echo esc_attr($button_url); ?>">
                            <div class="button-content-wrapper ">
                                <span class="elementor-button-text"><?php echo kidzo_extention_wp_kses($button_text); ?></span>
                                <svg class="pc-dashes inner-dashed-border animated-dashes">
                                    <rect x="5px" y="5px" rx="22px" ry="22px" width="0" height="0"></rect>
                                </svg>
                            </div>
                        </a>
						<?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6 col-lg-5">
					<div class="img_section">
                    	<?php if(!empty($settings['animation_three']['url'])): ?>
                        	<img src="<?php echo esc_url($settings['animation_three']['url']); ?>" alt="<?php esc_attr__('Animation Three', 'kidzo') ?>" class="about_img_4" data-parallax='{"x": 0, "y": 30, "rotateZ":0}'>
                    	<?php endif; ?>
                    	<?php if(!empty($settings['animation_one']['url'])): ?>
                        	<img src="<?php echo esc_url($settings['animation_one']['url']); ?>" alt="<?php esc_attr__('Animation One', 'kidzo') ?>" class="about_img_2">
                    	<?php endif; ?>
                    	<?php if(!empty($settings['animation_two']['url'])): ?>
                        	<img src="<?php echo esc_url($settings['animation_two']['url']); ?>" alt="<?php esc_attr__('Animation Two', 'kidzo') ?>" class="about_img_3" data-parallax='{"x": 0, "y": -50, "rotateZ":0}'>
                    	<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php }  ?>
<?php
	}
}