<?php
namespace kidzoCore\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_card extends Widget_Base {

	public function get_name() {
		return 'kidzo_card';
	}

	public function get_title() {
		return __( 'Card', 'kidzo-core' );
	}

	public function get_icon() {
		return ' eicon-call-to-action';
	}

	public function get_categories() {
		return [ 'kidzo-elements' ];
	}

	protected function register_controls() {

		// ------------------------------  Title  ------------------------------
		$this->start_controls_section(
            'card_style',
            [
                'label' => __( 'Card Style', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__( 'Card Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options'   => [
                    'style_1' => 'Style 1',
                    'style_2' => 'Style 2',
                ],
                'default' => 'style_1'
            ]
        );
        $this->end_controls_section();
		$this->start_controls_section(
			'section_content', [
				'label' => __( 'Section', 'kidzo-core' ),
				'condition' => [
                    'select_style' => 'style_1'
                ]
			]
		);
        $this->add_control(
            'card_title', [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Summer'
            ]
        );
        $this->add_control(
            'card_highlight', [
                'label' => esc_html__( 'HighLight Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Collection'
            ]
        );
        $this->add_control(
            'card_offer', [
                'label' => esc_html__( 'Offer Percentage', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'With up to 50% in savings'
            ]
        );
        $this->add_control(
			'card_img',
			[
				'label' => esc_html__( 'Choose Image', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
            'card_button', [
                'label' => esc_html__( 'Button', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Shop Now'
            ]
        );
		$this->add_control(
            'button_urls',
            [
                'label' => esc_html__( 'Button Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );

	    $this->end_controls_section();
		$this->start_controls_section(
            'section_information',
            [
                'label' => __( 'Card Information', 'kidzo-core' ),
                'condition' => [
                    'select_style' => 'style_2'
                ]
            ]
        );
		$this->add_control(
			'card_img_two',
			[
				'label' => esc_html__( 'Choose Image', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
            'card_title_two', [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Primary Education'
            ]
        );
		$this->add_control(
            'card_button_two', [
                'label' => esc_html__( 'Button', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Learn More'
            ]
        );
		$this->add_control(
            'button_urls_two',
            [
                'label' => esc_html__( 'Button Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );
		$this->end_controls_section();
        // style section
        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'kidzo-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
                    'select_style' => 'style_1'
                ]
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .promotion_item',
			]
		);
        $this->add_control(
			'card_title_options',
			[
				'label' => esc_html__( 'Title', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .__title',
			]
		);
        $this->add_control(
			'card_title_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'card_high_light_options',
			[
				'label' => esc_html__( 'High Light Title', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'high_typography',
				'selector' => '{{WRAPPER}} .__hightitle',
			]
		);
        $this->add_control(
			'card_highlight_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__hightitle' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'card_offer_options',
			[
				'label' => esc_html__( 'Percentage', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'offers_typography',
				'selector' => '{{WRAPPER}} .__offers',
			]
		);
        $this->add_control(
			'card_offer_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__offers' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'card_button_options',
			[
				'label' => esc_html__( 'Button', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .__button',
			]
		);
        $this->add_control(
			'card_button_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__button' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background_button',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .__button',
			]
		);
        $this->add_control(
			'card_offer_hover_options',
			[
				'label' => esc_html__( 'Button Hover', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'card_button_color_hover',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__button:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background_hover',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .__button:hover',
			]
		);

        $this->end_controls_section();

	}

	protected function render(){
        $settings = $this->get_settings();
		$select_style    = !empty($settings['select_style']) ? $settings['select_style'] : '';
        ?>
<?php if($select_style =='style_1'){ ?>
<div class="promotion_item">
    <img class="promo_bg" src="<?php echo esc_url($settings['card_img']['url']); ?>" alt="" />
    <div class="promotion_content">
        <h2 class="__title"><span class="__hightitle"><?php echo esc_html_e($settings['card_title']); ?></span>
            <?php echo esc_html_e($settings['card_highlight']); ?></h2>
        <p class="__offers"><?php echo esc_html_e($settings['card_offer']); ?></p>
        <a href="<?php echo esc_url($settings['button_urls']); ?>"
            class="cu_btn btn_2 __button"><?php echo esc_html_e($settings['card_button']); ?></a>
    </div>
</div>
<?php }elseif ($select_style == 'style_2') { ?>
<div class="features_new_item">
    <img src="<?php echo esc_url($settings['card_img_two']['url']); ?>" alt="">
    <h4><?php echo esc_html_e($settings['card_title_two']); ?></h4>
    <a href="<?php echo esc_url($settings['button_urls_two']); ?>"
        class="arrow_btn"><?php echo esc_html_e($settings['card_button_two']); ?> <i class="ti-arrow-right"></i></a>
</div>
<?php } ?>
<?php
	}
}