<?php
namespace kidzoCore\Widgets;
use Elementor\Group_Control_Background;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_contact extends Widget_Base {

    public function get_name() {
        return 'kidzo_contact';
    }

    public function get_title() {
        return __( 'Teacher Contact Form', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-mail';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    protected function register_controls() {

        // ------------------------------  Title  ------------------------------
        $this->start_controls_section(
            'contact_section', [
                'label' => __( 'Teacher Contact Info', 'kidzo-core' ),
            ]
        );
	    $this->add_control(
		    'title',
		    [
			    'label' => esc_html__( 'Title text', 'kidzo-core' ),
			    'description' => esc_html__( 'Use <span> tag for light text', 'kidzo-core' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'label_block' => true,
			    'default' => 'Don’t Hesitate to Contact us for any <span>Information.</span>'
		    ]
	    );
	    $this->add_control(
		    'title_html_tag',
		    [
			    'label' => __( 'Title HTML Tag', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'h1' => 'H1',
				    'h2' => 'H2',
				    'h3' => 'H3',
				    'h4' => 'H4',
				    'h5' => 'H5',
				    'h6' => 'H6',
				    'div' => 'div',
			    ],
			    'default' => 'h2',
			    'separator' => 'before',
		    ]
	    );
	    $this->add_control(
		    'title_color', [
			    'label' => __( 'Title Color', 'kidzo-core' ),
			    'type' => Controls_Manager::COLOR,
			    'selectors' => array(
				    '{{WRAPPER}} .kidzo_contact_form_content .title' => 'color: {{VALUE}};',
			    )
		    ]
	    );
	    $this->add_group_control(
		    Group_Control_Typography::get_type(), [
			    'name' => 'typography_title',
			    'selector' => '
                    {{WRAPPER}} .kidzo_contact_form_content .title
                '
		    ]
	    );


        $this->end_controls_section();


	    $this->start_controls_section(
		    'contact_shortcode', [
			    'label' => __( 'Contact Form ShortCode', 'kidzo-core' ),
		    ]
	    );
	    $this->add_control(
		    'cf7_shortcode',
		    [
			    'label' => esc_html__( 'ShortCode', 'kidzo-core' ),
			    'description' => esc_html__( 'Bring shortcode from Dashboard > Contact', 'kidzo-core' ),
			    'type'  => Controls_Manager::TEXT,
			    'label_block' => true,
			    'separator' => 'before',
		    ]
	    );
    $this->end_controls_section();

    /*======================= Animation Images ======================== */
    $animation_images = new \Elementor\Repeater();
    $this->start_controls_section(
        'client_images_features_sec', [
            'label' => __( 'Animation Images', 'kidzo-core' ),
        ]
    );
    $animation_images->add_control(
        'animation_img', [
            'label' => __( 'Images Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Animation Images'
        ]
    );
    $animation_images->add_responsive_control(
        'possition_top_buttom',
        [
            'label' => __( 'Horizontal', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'possition_left_right',
        [
            'label' => __( 'Vertical', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'horizontal',
        [
            'label' => __( 'Horizontal Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'vertical',
        [
            'label' => __( 'Vertical Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
    $animation_images->add_control(
        'animation_feature_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::MEDIA,
        ]
    );
    $this->add_control(
        'feature_animation', [
            'label' => __( 'Animation', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ animation_img }}}',
            'fields' => $animation_images->get_controls(),
        ]
    );
    $this->end_controls_section();
    /*================= End Animation Images =============*/
    /**
     * Style Section
     */
    $this->start_controls_section(
        'style_sec',
        [
            'label' => __( 'Style Section', 'kidzo-core' ),
            'tab' => Controls_Manager::TAB_STYLE
        ]
    );

    $this->add_responsive_control(
			'kizo_contact_margin',
			[
				'label' => __( 'Padding', 'kidzo-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .contact_part' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
    
    $this->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name' => 'sec_bg_color',
            'label' => __( 'Section Background', 'kidzo-core' ),
            'types' => [ 'classic', 'gradient' ],
            'selector' => '
                {{WRAPPER}} .contact_part'
        ]
    );
    $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();
        $titleTag      = !empty( $settings['title_html_tag'] ) ? $settings['title_html_tag'] : '';
	    $title      = !empty( $settings['title'] ) ? $settings['title'] : '';
        $cf7shortCode = !empty( $settings['cf7_shortcode'] ) ? $settings['cf7_shortcode'] : '';
        $animation_imags = !empty($settings['feature_animation']) ? $settings['feature_animation'] : '';
    ?>
    <section class="contact_part section_bg">
            <div class="container custom_container">
                <div class="row">
                    <div class="col-md-8">
                        <div class="contact_form">
                            <?php 
                            if( $title ){
                                    echo '<'.$titleTag.' data-wow-delay="0.2s">'. kidzo_extention_wp_kses( $title ) .'</'.$titleTag.'>';
                                }
                            ?>    
                            <?php
                            if( $cf7shortCode ){
                            echo do_shortcode( $cf7shortCode );
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
                if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
                    $i=1;
                    foreach ( $animation_imags as $feature_imgs ) {
                    $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                    $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                    $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                    $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
            ?>
            <div class="contact_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                    <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php esc_url($ani_img); ?>">
                </div>
            </div>
            <?php 
                $i++;
                } 
            } 
            ?>
    </section>
<?php
   }
}