<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_counter extends Widget_Base {

    public function get_name() {
        return 'kidzo_counter';
    }

    public function get_title() {
        return esc_html__( 'Counter', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {

        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'counter_style',
            [
                'label' => __( 'Counter Style', 'kidzo-core' ),
            ]
        );

        $this->add_control(
            'sec_style', [
                'label' => esc_html__( 'Select Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => 'Style One',
                    'style_2' => 'Style Two',
                    'style_3' => 'Style Three',
                ],
                'default'   => 'style_1'
            ]
        );

        $this->end_controls_section();

        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'counter_title',
            [
                'label' => __( 'Counter Title', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_1'
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Who We Are',
            ]
        );
	    $this->add_control(
		    'title_html_tag',
		    [
			    'label' => __( 'Title HTML Tag', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'h1' => 'H1',
				    'h2' => 'H2',
				    'h3' => 'H3',
				    'h4' => 'H4',
				    'h5' => 'H5',
				    'h6' => 'H6',
				    'div' => 'div',
			    ],
			    'default' => 'h4',
			    'separator' => 'before',
		    ]
	    );

	    $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'title_typo',
                'selector' => '
                    {{WRAPPER}} .event_time_countdown .time_countdown_content h4'
            ]
        );

       $this->add_control(
            'about_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .event_time_countdown .time_countdown_content h4' => 'color: {{VALUE}};',
                ),
            ]
        );
        $this->add_control(
            'reg_date',
            [
                'label' => esc_html__( 'Registration Date', 'kidzo-core' ),
                'type' => Controls_Manager::DATE_TIME,
                'default'     => date( "Y-m-d", strtotime( "+ 1 day" ) ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


	    /*===================== Feature Images =========================*/
	    $this->start_controls_section(
		    'counter_feature_img',
		    [
			    'label' => __( 'Feature Image', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_1'
                ]
		    ]
	    );
	    $this->add_control(
		    'feature_img',
		    [
			    'label' => esc_html__( 'Background Feature Image', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
		    ]
	    );

	    $this->add_control(
		    'feature_img_icon',
		    [
			    'label' => esc_html__( 'location Image', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
		    ]
	    );
	    
	    $this->end_controls_section();

        /*======================= Feature Settings [Style Two] ======================== */
        $client_features = new \Elementor\Repeater();
        $this->start_controls_section(
            'client_features_sec', [
                'label' => __( 'Client Features', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_2'
                ]
            ]
        );
        
        $client_features->add_control(
            'tf_title', [
                'label' => __( 'Feature title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Babysitters'
            ]
        );
        $client_features->add_control(
            'tf_number', [
                'label' => __( 'Feature Number', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => '850'
            ]
        );
        $client_features->add_control(
            'tf_feature_img', [
                'label' => __( 'Feature Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'tf_features', [
                'label' => __( 'Features', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ tf_title }}}',
                'fields' => $client_features->get_controls(),
            ]
        );
        $this->end_controls_section();
        /*================= End Feature [ Style Two ] =============*/

        /*======================= Feature Settings [Style Two] ======================== */
        $animation_images = new \Elementor\Repeater();
        $this->start_controls_section(
            'client_images_features_sec', [
                'label' => __( 'Animation Images', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_2'
                ]
            ]
        );
        $animation_images->add_control(
            'animation_img', [
                'label' => __( 'Images Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => 'Animation Images'
            ]
        );
        $animation_images->add_responsive_control(
            'possition_top_buttom',
            [
                'label' => __( 'Horizontal', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'possition_left_right',
            [
                'label' => __( 'Vertical', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'horizontal',
            [
                'label' => __( 'Horizontal Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'vertical',
            [
                'label' => __( 'Vertical Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
        $animation_images->add_control(
            'animation_feature_img', [
                'label' => __( 'Animation Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'client_animation', [
                'label' => __( 'Animation', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ animation_img }}}',
                'fields' => $animation_images->get_controls(),
            ]
        );
        $this->end_controls_section();
        // Counter Three
        $this->start_controls_section(
            'counte_three', [
                'label' => __( 'Counter', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_3'
                ]
            ]
        );
        $this->add_control(
			'counte_features_img',
			[
				'label' => esc_html__( 'Choose Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
            'counte_title', [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Deal of the week'
            ]
        );
        $this->add_control(
            'counte_first_text', [
                'label' => esc_html__( 'First Text', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Enjoy up to'
            ]
        );
        $this->add_control(
            'counte_second_text', [
                'label' => esc_html__( 'Second Text', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '50% off'
            ]
        );
        $this->add_control(
            'counte_third_text', [
                'label' => esc_html__( 'Third Text', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'and free delivery on products'
            ]
        );
        $this->add_control(
            'counter_reg_date',
            [
                'label' => esc_html__( 'Registration Date', 'kidzo-core' ),
                'type' => Controls_Manager::DATE_TIME,
                'default'     => date( "Y-m-d", strtotime( "+ 1 day" ) ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'counte_button', [
                'label' => esc_html__( 'Button', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'View Details'
            ]
        );

        $this->end_controls_section();
        /*================= End Feature  =============*/
        /**
        * Style Section
        */
        $this->start_controls_section(
            'style_sec',
            [
                'label' => __( 'Style Section', 'kidzo-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sec_bg_color',
                'label' => __( 'Section Background', 'kidzo-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '
                    {{WRAPPER}} .count_section'
            ]
        );
        $this->add_control(
			'counter_title_color',
			[
				'label' => esc_html__( 'Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'counter_title_typography',
				'selector' => '{{WRAPPER}} .__title',
			]
		);
        $this->end_controls_section();

    }

    protected function render() {
            $settings          = $this->get_settings();
            $sec_style         = !empty($settings['sec_style']) ? $settings['sec_style'] : '';
            $title_tag         = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
            $features          = isset($settings['tf_features']) ? $settings['tf_features'] : '';
            $animation_imags   = isset($settings['client_animation']) ? $settings['client_animation'] : '';
            $reg_date          = !empty( $settings['reg_date'] ) ? $settings['reg_date'] : '';
            $due_date_time = date( "M d Y G:i:s", strtotime( $reg_date ) );
            $counter_reg_date          = !empty( $settings['counter_reg_date'] ) ? $settings['counter_reg_date'] : '';
            $counter_due_date_time = date( "M d Y G:i:s", strtotime( $counter_reg_date ) );
        ?>
<?php if($sec_style == 'style_1'){ ?>
<section class="event_time_countdown section_padding" <?php if(!empty($settings['feature_img']['url'])): ?>
    style="background-image: url('<?php echo esc_url($settings['feature_img']['url']); ?>')" <?php endif; ?>>
    <div class="container custom_container">
        <div class="row justify-content-between align-items-center">
            <div class="col-xl-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                <div class="time_countdown_content">
                    <?php if(!empty($settings['feature_img_icon']['url'])){ ?>
                    <img src="<?php echo esc_url($settings['feature_img_icon']['url']); ?>"
                        alt="<?php echo kidzo_extention_wp_kses($settings['title']); ?>">
                    <?php } ?>
                    <?php
                                    if ( ! empty( $settings['title'] ) ) {
                                        echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
                                    }
                                ?>
                </div>
            </div>
            <div class="col-xl-6 col-md-5 wow fadeInUp" data-wow-delay=".4s">
                <div class="event_timer">
                    <div class="dl_countdown_wrapper">
                        <div class="dl_countdown_content"
                            data-Date='<?php echo kidzo_extention_wp_kses($due_date_time); ?>'
                            data-endText="Offer ended">
                            <div class="dl_countdown_running">
                                <div class="dl_countdown_inner_wrapper">
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_days"></span>
                                            <p class="dl_desc">Days</p>
                                        </div>
                                    </div>
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_hours"></span>
                                            <p class="dl_desc">Hours</p>
                                        </div>
                                    </div>
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_minutes"></span>
                                            <p class="dl_desc">Minutes</p>
                                        </div>
                                    </div>
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_seconds"></span>
                                            <p class="dl_desc">Seconds</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php }elseif ($sec_style == 'style_2') { ?>
<section class="count_section">
    <div class="container custom_container">
        <div class="row justify-content-between">
            <?php
                            if ( is_array( $animation_imags ) && count( $features ) > 0 ) {
                                foreach ( $features as $feature ) {
                                    ?>
            <div class="col-md-3 col-6 wow fadeInUp">
                <div class="single_count_section">
                    <?php if(!empty($feature['tf_feature_img']['url'])): ?>
                    <div class="single_count_icon">
                        <img src="<?php echo esc_url($feature['tf_feature_img']['url']); ?>"
                            alt="<?php echo wp_kses_post($feature['tf_title']); ?>">
                    </div>
                    <?php endif; ?>
                    <h4> <span class="counter"><?php echo kidzo_extention_wp_kses($feature['tf_number']); ?></span></h4>
                    <h5><?php echo kidzo_extention_wp_kses($feature['tf_title']); ?></h5>
                </div>
            </div>
            <?php
                                }
                            } 
                        ?>
        </div>
    </div>
    <?php
                    if ( is_array( $features ) && count( $animation_imags ) > 0 ) {
                        $i=1;
                        foreach ( $animation_imags as $feature_imgs ) {
                            $hori       = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                            $varti      = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                            $ani_img    = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                            $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                            ?>
    <div class="count_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
        <div
            data-parallax='{"x": <?php echo esc_attr( $hori ); ?>, "y": <?php echo esc_attr( $varti ); ?>, "rotateZ":0}'>
            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
        </div>
    </div>
    <?php 
                            $i++;
                        }
                    } 
                ?>
</section>
<?php }elseif ($sec_style == 'style_3') { ?>
<section class="event_time_countdown_area event_countdown_area_two" data-bg-color="#D7F0EB">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <img class="event_img" src="<?php echo esc_url($settings['counte_features_img']['url']); ?>" alt="" />
            </div>
            <div class="col-lg-6">
                <div class="event_timer">
                    <h2 class="__title"><?php echo esc_html_e($settings['counte_title']); ?></h2>
                    <p>
                        <?php echo esc_html_e($settings['counte_first_text']); ?>
                        <span><?php echo esc_html_e($settings['counte_second_text']); ?></span>
                        <?php echo esc_html_e($settings['counte_third_text']); ?>
                    </p>
                    <div class="dl_countdown_wrapper">
                        <div class="dl_countdown_content"
                            data-Date="<?php echo kidzo_extention_wp_kses($counter_due_date_time); ?>"
                            data-endText="Offer ended">
                            <div class="dl_countdown_running">
                                <div class="dl_countdown_inner_wrapper">
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_days"></span>
                                            <p class="dl_desc">Days</p>
                                        </div>
                                    </div>
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_hours"></span>
                                            <p class="dl_desc">Hours</p>
                                        </div>
                                    </div>
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_minutes"></span>
                                            <p class="dl_desc">Minutes</p>
                                        </div>
                                    </div>
                                    <div class="dl_countdown_inner">
                                        <div class="dl_countdown">
                                            <span class="dl_seconds"></span>
                                            <p class="dl_desc">Seconds</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a href="#" class="cu_btn btn_2"><?php echo esc_html_e($settings['counte_button']); ?></a>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
        } 
    }

}