<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_events extends Widget_Base {

	public function get_name() {
		return 'kidzo_events';
	}

	public function get_title() {
		return __( 'Events', 'kidzo-core' );
	}

	public function get_icon() {
		return ' eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'kidzo-elements' ];
	}

	public function get_script_depends() {
		return [ 'imagesloaded', 'isotope' ];
	}

	protected function register_controls() {

        // -------------------------------------------- Filtering
		$this->start_controls_section(
			'portfolio_filter', [
				'label' => __( 'Event Filter', 'kidzo-core' ),
			]
		);
        $this->add_control(
            'select_style', [
                'label' => esc_html__( 'Select Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => 'Style 01',
                    'style_2' => 'Style 02',
                    'style_3' => 'Style 03',
                    'style_4' => 'Style 04',
                ],
                'default' => 'style_1'
            ]
        );
		$this->add_control(
			'all_label', [
				'label' => esc_html__( 'All filter label', 'kidzo-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'See All'
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show count', 'kidzo-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 8
			]
		);

		$this->add_control(
			'order', [
				'label' => esc_html__( 'Order', 'kidzo-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
            'about_title',
            [
                'label' => __( 'Event Section', 'kidzo-core' ),
                'condition' => [
                    'select_style' => ['style_2','style_3']
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Event',
            ]
        );
        $this->add_control(
            'title_html_tag',
            [
                'label' => __( 'Title HTML Tag', 'elementor' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                ],
                'default' => 'h2',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'title_typo',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 h2'
            ]
        );

       $this->add_control(
            'about_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .section_tittle_style_02 h2' => 'color: {{VALUE}};',
                ),
            ]
        );

       $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'kidzo-core' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'default' => 'Upcoming Events',
            ]
        );

       $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'sub_title_typo',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 p'
            ]
        );

       $this->add_control(
            'event_sub_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .section_tittle_style_02 p' => 'color: {{VALUE}};',
                ),
            ]
        );
        $this->end_controls_section();
        /*===================== Animation Images =========================*/
        $this->start_controls_section(
            'event_animation_img',
            [
                'label' => __( 'Feature Image', 'kidzo-core' ),
                'condition' => [
                    'select_style' => 'style_3'
                ]

            ]
        );
        $this->add_control(
            'animation_five',
            [
                'label' => esc_html__( 'Feature Images ', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,

            ]
        );
        $this->end_controls_section();

        /*======================= Feature Settings [Style Two] ======================== */
        $animation_images = new \Elementor\Repeater();
        $this->start_controls_section(
            'client_images_features_sec', [
                'label' => __( 'Animation Images', 'kidzo-core' ),
            ]
        );
        $animation_images->add_control(
            'animation_img', [
                'label' => __( 'Images Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => 'Animation Images'
            ]
        );
        $animation_images->add_responsive_control(
            'possition_top_buttom',
            [
                'label' => __( 'Horizontal', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'possition_left_right',
            [
                'label' => __( 'Vertical', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


       $animation_images->add_responsive_control(
            'horizontal',
            [
                'label' => __( 'Horizontal Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'vertical',
            [
                'label' => __( 'Vertical Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
        $animation_images->add_control(
            'animation_feature_img', [
                'label' => __( 'Animation Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'feature_animation', [
                'label' => __( 'Animation', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ animation_img }}}',
                'fields' => $animation_images->get_controls(),
            ]
        );
        $this->end_controls_section();
        /*================= End Feature =============*/
    

	}

	protected function render() {
    $settings  = $this->get_settings();
    $tf_features      = !empty( $settings['tf_features'] ) ? $settings['tf_features'] : ''; 
    $title_tag        = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
    $stitle        = !empty( $settings['title'] ) ? $settings['title'] : '';
    $sub_title     = !empty( $settings['sub_title'] ) ? $settings['sub_title'] : '';
    $animation_imags  = !empty($settings['feature_animation']) ? $settings['feature_animation'] : '';
    $evemt_list = new WP_Query(array(
        'post_type'     => 'events',
        'posts_per_page'=> $settings['show_count'],
        'order' => $settings['order'],
    ));

?>
<?php 
    if( $settings['select_style'] == 'style_1' ){ ?>
<!-- event section part here -->
<div class="event_section section_padding">
    <div class="container custom_container">
        <?php
            if( $evemt_list->have_posts() ){
                while ( $evemt_list->have_posts() ){
                    $evemt_list->the_post();
                    $teachers_designation = function_exists( 'get_field' ) ? get_field( 'teachers_designation' ) : '';
                        if( has_post_thumbnail() ) {
                            $cats = get_the_terms(get_the_ID(), 'events_cat');
                            $cat_slug = '';
                            $cat_name = '';
                            if(is_array($cats)) {
                                foreach ($cats as $cat) {
                                $cat_slug .= $cat->slug.' ';
                                $cat_name .= $cat->name.' ';
                                }
                            } ?>
        <div class="row justify-content-between align-items-center">
            <div class="col-md-6">
                <div class="img_section">
                    <a href="<?php the_permalink(); ?>">
                        <?php echo get_the_post_thumbnail( get_the_ID(), 'kidzo_570x350', array( 'class' => 'about_img_6 img-fluid' ) );  ?>
                    </a>
                    <?php
                                        if ( ! empty( $settings['animation_five']['url'] ) ) { ?>
                    <img src="<?php echo esc_url( $settings['animation_five']['url'] ); ?>"
                        alt="<?php esc_attr__('Feature Images', 'kidzo') ?>" class="about_img_5"
                        data-parallax='{"x": 0, "y": 50, "rotateZ":0}'>
                    <?php } ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="event_section_content event_Page">
                    <h5><?php echo esc_html__($cat_name); ?></h5>
                    <h2><?php the_title(); ?></h2>
                    <p class="wow fadeInDown" data-wow-delay=".3s">
                        <?php echo  wp_trim_words( get_the_content(), 40, false ); ?></p>

                    <a class="pc-button elementor-button button-link cu_btn" href="<?php the_permalink(); ?>">
                        <div class="button-content-wrapper ">
                            <span class="elementor-button-text"><?php esc_html_e('Learn More','kidzo'); ?> </span>
                            <svg class="pc-dashes inner-dashed-border animated-dashes">
                                <rect x="5px" y="5px" rx="25px" ry="25px" width="0" height="0"></rect>
                            </svg>
                        </div>
                    </a>
                </div>
            </div>
        </div>
        <?php
                        }
                }
                wp_reset_postdata();
            }
            ?>
    </div>
    <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
    <div
        class="about_page_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
        <div
            data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
        </div>
    </div>
    <?php 
            $i++;
            }
        } 
        ?>
</div>
<!-- event section part end -->
<?php }elseif ( $settings['select_style'] == 'style_2' ) { ?>
<!-- event list part here -->
<div class="event_list section_padding section_bg_1">
    <div class="container custom_container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section_tittle_style_02">
                    <?php
                            if(!empty($stitle)):
                                echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $stitle ) . '</' . $title_tag . '>';
                            endif;
                            if(!empty($sub_title)):
                        ?>
                    <p class="description wow fadeInDown" data-wow-delay=".3s">
                        <?php echo kidzo_extention_wp_kses($sub_title); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <?php
                if( $evemt_list->have_posts() ){
                    while ( $evemt_list->have_posts() ){
                        $evemt_list->the_post();
                        $event_date     = strtotime(get_field('event_date'));
                        $event_time     = function_exists( 'get_field' ) ? get_field( 'event_time' ) : '';
                        $event_location = function_exists( 'get_field' ) ? get_field( 'event_location' ) : '';
                        $address = substr($event_location, 0, 7);
                            if( has_post_thumbnail() ) {
                                $cats = get_the_terms(get_the_ID(), 'events_cat');
                                $cat_slug = '';
                                $cat_name = '';
                                if(is_array($cats)) {
                                    foreach ($cats as $cat) {
                                    $cat_slug .= $cat->slug.' ';
                                    $cat_name .= $cat->name.' ';
                                    }
                                }
                                ?>
            <div class="col-lg-6 col-md-12 wow fadeInUp" data-wow-delay=".2s">
                <div class="single_event_list">
                    <div class="event_list_img">
                        <a href="<?php the_permalink(); ?>">
                            <?php
                                            the_post_thumbnail('kidzo_195x235', array('class' => 'img-fluid mobile-none'));
                                            the_post_thumbnail('kidzo_515x300', array('class' => 'img-fluid mobile-image'));
                                            ?>
                        </a>
                    </div>
                    <div class="event_list_content">
                        <h5><?php echo date('d', $event_date); ?> <?php echo date('M', $event_date); ?></h5>
                        <h3> <a
                                href="<?php the_permalink(); ?>"><?php echo  wp_trim_words( get_the_title(), 2, false ); ?></a>
                        </h3>
                        <p><?php echo  wp_trim_words( get_the_content(), 7, false ); ?></p>
                        <ul>
                            <li><i class="fas fa-clock"></i><?php esc_html_e('Time:','kidzo'); ?>
                                <span><?php echo kidzo_extention_wp_kses($event_time); ?></span>
                            </li>
                            <li><i
                                    class="fas fa-map-marker-alt"></i><?php esc_html_e('Location:','kidzo'); ?><span><?php echo kidzo_extention_wp_kses($address); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php
                            }
                    }
                    wp_reset_postdata();
                }
                ?>
        </div>
    </div>
    <?php
    if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
        $i=1;
        foreach ( $animation_imags as $feature_imgs ) {
            $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
            $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
            $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
            $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
            ?>
    <div
        class="event_list_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
        <div
            data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
            <?php if($ani_img): ?>
            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
            <?php endif; ?>
        </div>
    </div>
    <?php 
        $i++;
        } 
    } 
    ?>
</div>
<!-- event list part end -->
<?php }elseif ( $settings['select_style'] == 'style_3' ) { ?>
<!-- services part here -->
<section class="event_part section_padding">
    <div class="container custom_container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section_tittle_style_02">
                    <?php
                            if(!empty($stitle)):
                                echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $stitle ) . '</' . $title_tag . '>';
                            endif;
                            if(!empty($sub_title)):
                        ?>
                    <p class="description wow fadeInDown" data-wow-delay=".3s">
                        <?php echo kidzo_extention_wp_kses($sub_title); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="event_part_iner">
                    <div class="row justify-content-end">
                        <?php
                            if ( ! empty( $settings['animation_five']['url'] ) ) { ?>
                        <div class="event_img wow fadeInLeft" data-wow-delay=".5s">
                            <img src="<?php echo esc_url( $settings['animation_five']['url'] ); ?>" alt="Feature Images"
                                class="img-fluid">
                        </div>
                        <?php 
                            }   
                            ?>
                        <div class="col-md-6 col-xl-7">
                            <?php
                                if( $evemt_list->have_posts() ){
                                    while ( $evemt_list->have_posts() ){
                                        $evemt_list->the_post();
                                        $event_date     = strtotime(get_field('event_date'));
                                        $event_time     = function_exists( 'get_field' ) ? get_field( 'event_time' ) : '';
                                        $event_location = function_exists( 'get_field' ) ? get_field( 'event_location' ) : '';
                                            if( has_post_thumbnail() ) {
                                                $cats = get_the_terms(get_the_ID(), 'events_cat');
                                                $cat_slug = '';
                                                $cat_name = '';
                                                if(is_array($cats)) {
                                                    foreach ($cats as $cat) {
                                                    $cat_slug .= $cat->slug.' ';
                                                    $cat_name .= $cat->name.' ';
                                                    }
                                                }
                                                ?>
                            <div class="single_event_list wow fadeInDown" data-wow-delay=".2s">
                                <div class="event_date">
                                    <h3><?php echo date('d', $event_date); ?>
                                        <span><?php echo date('M', $event_date); ?></span>
                                    </h3>
                                </div>
                                <div class="event_content">
                                    <h4> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                    <p><?php echo kidzo_extention_wp_kses($event_time); ?></p>
                                </div>
                            </div>
                            <?php
                                            }
                                    }
                                    wp_reset_postdata();
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
    <div
        class="event_animation_sec event_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
        <div
            data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
        </div>
    </div>
    <?php 
                $i++;
            } 
        } 
        ?>
</section>
<!-- services part end -->
<?php }elseif ( $settings['select_style'] == 'style_4' ) { ?>

<section class="kidzo_event_area events_four">
    <div class="container">
        <div class="row ml-0 mr-0">
            <?php
            if( $evemt_list->have_posts() ){
                while ( $evemt_list->have_posts() ){
                    $evemt_list->the_post();
                    $event_date     = strtotime(get_field('event_date'));
                    $event_time     = function_exists( 'get_field' ) ? get_field( 'event_time' ) : '';
                    $event_location = function_exists( 'get_field' ) ? get_field( 'event_location' ) : '';
                    $background_color = function_exists( 'get_field' ) ? get_field( 'background_color' ) : '';
                    $event_icon = function_exists( 'get_field' ) ? get_field( 'event_icon' ) : '';
                    $border_icon = function_exists( 'get_field' ) ? get_field( 'border_icon' ) : '';
                    $subtitle = function_exists( 'get_field' ) ? get_field( 'subtitle' ) : '';
                        if( has_post_thumbnail() ) {
                            $cats = get_the_terms(get_the_ID(), 'events_cat');
                            $cat_slug = '';
                            $cat_name = '';
                            if(is_array($cats)) {
                            foreach ($cats as $cat) {
                            $cat_slug .= $cat->slug.' ';
                            $cat_name .= $cat->name.' ';
                            }
                        }
        ?>
            <div class="kidzo_event_item d-flex align-items-center"
                style="background-color: <?php echo esc_attr($background_color); ?>;">
                <div class="kidzo_event d-flex align-items-center">
                    <img src="<?php echo $event_icon['url']; ?>" alt="">
                    <div class="event_content">
                        <a href="<?php the_permalink(); ?>">
                            <h3><?php the_title(); ?></h3>
                        </a>
                        <p><?php echo $subtitle; ?></p>
                    </div>
                </div>
                <div class="kidzo_event_date d-flex align-items-center">
                    <img src="<?php echo $border_icon['url']; ?>" alt="">
                    <div class="date"><?php echo date('d', $event_date); ?></div>
                    <div class="date_content">
                        <h3><?php echo date('M', $event_date); ?></h3>
                        <p><?php echo kidzo_extention_wp_kses($event_time); ?></p>
                    </div>
                </div>
                <a href="<?php the_permalink(); ?>" class="event_btn"><i class="ti-arrow-right"></i></a>
            </div>
            <?php
                }
                    }
                    wp_reset_postdata();
                }
            ?>
        </div>
    </div>
</section>
<?php
 } 
}
}