<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_faq extends Widget_Base {

    public function get_name() {
        return 'kidzo_faq';
    }

    public function get_title() {
        return esc_html__( 'FAQ with Tabs', 'rogan-hero' );
    }

    public function get_icon() {
        return 'eicon-menu-bar';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {

        // ------------------------------  Category Title ------------------------------
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Tabs Style', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'select_style', [
                'label' => esc_html__( 'Select Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => 'Style 01',
                    'style_2' => 'Style 02',
                    'style_3' => 'Style 03',
                ],
                'default' => 'style_1'
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tabs',
            [
                'label' => __( 'Tabs Title', 'kidzo-core' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Frequently <br>Asked questions',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'title_typo',
                'selector' => '
                    {{WRAPPER}} .kidzo_faq_wrap .sec_title,
                    {{WRAPPER}} .food_title
                ',
            ]
        );

        $this->add_control(
            'faq_cat_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .kidzo_faq_wrap .sec_title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .food_title' => 'color: {{VALUE}};',
                ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_sub_title',
            [
                'label' => __( 'Sub Title', 'kidzo-core' ),
                'condition' => [
                    'select_style' => 'style_3'
                ]
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'He legged it plastered cheeky loo what a plonker some dodgy chav a barney wellies, gutted mate quaint.',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'sub_title_typo',
                'selector' => '
                    {{WRAPPER}} .section_title_three p
                ',
            ]
        );

        $this->add_control(
            'sub_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .section_title_three p' => 'color: {{VALUE}};',
                ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'faq_button',
            [
                'label' => __( 'FAQ Button', 'kidzo-core' ),
                'condition' => [
                    'select_style' => 'style_3'
                ]
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'View All FAQ',
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => esc_html__( 'Button URL', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );


        $this->end_controls_section();


        $repeater = new \Elementor\Repeater();
        $this->start_controls_section(
            'faq_accordion',
            [
                'label' => __( 'Accordion', 'kidzo-core' ),
                'condition' => [
                    'select_style' => [ 'style_1', 'style_2' ]
                ]
            ]
        );
        $repeater->add_control(
            'faq_title',
            [
                'label' => __( 'FAQ Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => 'What is Cohousing?'
            ]
        );
        $repeater->add_control(
            'faq_desc',
            [
                'label' => __( 'FAQ Description', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'   => 'Tosser wellies bog bobby bevvy crikey argy-bargy wind up mush Charles cuppa, 
                                bodge dropped a clanger Why James Bond knackered blower
                                 bamboozled pardon you fantastic lost the plot posh,'
            ]
        );
        $this->add_control(
            'accordions',
            [
                'label' => __( 'FAQ Items', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ faq_title }}}',
            ]
        );
        $this->end_controls_section();


        // FAQ Repeater Style 03 =================
        $faq_items = new \Elementor\Repeater();
        $this->start_controls_section(
            'faq_tab_style',
            [
                'label' => __( 'FAQ Tab', 'kidzo-core' ),
                'condition' => [
                    'select_style' => 'style_3'
                ]
            ]
        );
        $faq_items->add_control(
            't_title',
            [
                'label' => esc_html__( 'Tab Title', 'kidzo-core' ),
                'description' => esc_html__( 'Tab Title would be work as a category', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Customer'
            ]
        );
        $faq_items->add_control(
            'faq_title_s3',
            [
                'label' => __( 'FAQ Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => 'I got the wrong food. What should I do?'
            ]
        );
        $faq_items->add_control(
            'faq_desc_s3',
            [
                'label' => __( 'FAQ Description', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'   => 'Hanky panky codswallop tomfoolery Eaton blimey bugger all mate morish show off show off pick your nose and blow off, posh geeza gormless mufty buggered tinkety tonk old fruit. Chancer I don\'t want no agro nancy boy it\'s all gone to pot happy days I squiffy, only a quid bugger.!'
            ]
        );
        $this->add_control(
            'faqs_tab',
            [
                'label' => __( 'FAQ Items', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ faq_title_s3 }}}',
            ]
        );
        $this->end_controls_section();


        /** ====================== Style Tab ======================= */
        $this->start_controls_section(
            'style_faq_item',
            [
                'label' => __( 'FAQ Items', 'kidzo-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs(
            'faq_tabs'
        );
        $this->start_controls_tab(
            'faq_normal_item', [
                'label' => 'Normal'
            ]
        );
        $this->add_control(
            'faq_title_color', [
                'label'     => esc_html__('Title Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .kidzo_faq_item .kidzo_faq_title' => 'color: {{VALUE}};',
                ),
            ]
        );
        $this->add_control(
            'faq_border_color', [
                'label'     => esc_html__('Border Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .kidzo_faq_item' => 'border-color: {{VALUE}};',
                ),
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'faq_act_item', [
                'label' => 'Active'
            ]
        );
        $this->add_control(
            'act_title_color', [
                'label'     => esc_html__('Title Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .kidzo_faq_item.open .kidzo_faq_title' => 'color: {{VALUE}};',
                ),
            ]
        );

        $this->add_control(
            'act_border_color', [
                'label'     => esc_html__('Border Gradient 1st Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,

            ]
        );
        $this->add_control(
            'act_border_gradient_color', [
                'label'     => esc_html__('Border Gradient 2nd Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .kidzo_faq_item.open' => 'background-image:linear-gradient(50deg, #fff 0%, #fff 100%), linear-gradient(50deg, {{act_border_color.VALUE}} 0%, {{VALUE}} 100%);',
                ),
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'faq_box_shadow',
                'label' => __( 'Box Shadow', 'kidzo-core' ),
                'selector' => '{{WRAPPER}} .kidzo_faq_item.open',
            ]
        );
        $this->add_control(
            'act_desc_color', [
                'label'     => esc_html__('Description Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .kidzo_faq_item .kidzo_faq_para' => 'color: {{VALUE}};',
                ),
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_control(
            'type_separator', [
                'type' => Controls_Manager::HEADING,
                'label' => 'Typography',
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'faq_desc_typo',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .kidzo_faq_item .kidzo_faq_para',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'faq_title_typo',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .kidzo_faq_item .kidzo_faq_title',
            ]
        );
        $this->end_controls_section();
        /**
         * Style Section
         */
        $this->start_controls_section(
            'style_sec',
            [
                'label' => __( 'Style Section', 'kidzo-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sec_bg_color',
                'label' => __( 'Section Background', 'kidzo-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .kidzo_faq_wrap',
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        $style_class = '';
        if( $settings['select_style'] == 'style_3' ){
            $faqs_tab   = $settings['faqs_tab'];
            $cats       = array_column( $faqs_tab, 't_title' );
            $get_cats    = array_unique( $cats );
            $tab_data   = return_faq_tab_data( $get_cats , $faqs_tab );

        ?>
        <section class="kidzo_restaurant_faq">
            <div class="container custom_container">
                <div class="section_title_three text-center">
                    <?php
                    if ( ! empty( $settings['title'] ) ) { ?>
                        <h2 class="f_title food_title wow fadeInUp"><?php echo  wp_kses_post( nl2br( $settings['title'] ) ); ?></h2>
                        <?php
                    }
                    if ( ! empty( $settings['sub_title'] ) ) {
                        echo '<p class="wow fadeInUp" data-wow-delay="0.3s">' . wp_kses_post( nl2br( $settings['sub_title'] )) . '</p>';
                    }
                    ?>
                </div>
                <div class="restaurant_faq_inner">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <?php
                        if( is_array( $faqs_tab ) && count( $faqs_tab ) > 0 ){
                            $tabs   = '';
                            $i      = 0;
                            foreach ( $get_cats as $cat ){
                                $catForFilter = sanitize_title_with_dashes( $cat );
                                $i++;
                                $active = $i==1 ? 'active' : '';
                                $tabs .= '<li class="nav-item"><a class="nav-item nav-link '. esc_attr( $active ) .'" id="tabtitle_'.esc_attr( $catForFilter ).'" data-toggle="tab" href="#'.esc_attr( $catForFilter ).'">'. esc_html( $cat ) .'</a></li>';
                            }
                            echo $tabs;
                        } ?>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                        <?php
                        if( !empty( $tab_data ) ) {
                            $act = 0;
                            foreach ($tab_data as $key => $val) {
                                $tagforfilter = sanitize_title_with_dashes($key);
                                $act++;
                                $activee = $act == 1 ? 'show active' : '';

                                ?>
                                <div class="tab-pane fade <?php echo esc_attr( $activee ); ?>" id="<?php echo esc_attr( $tagforfilter ); ?>" role="tabpanel"
                                        aria-labelledby="customer-tab">
                                    <div id="accordion">
                                        <?php
                                        $i = 0;
                                        $a = 0;
                                        foreach ( $val as $data ) {
                                            $a++;
                                            $show = $a == 1 ? 'show' : '';
                                            $card_id = 'item_'.$i++;
                                            ?>
                                            <div class="card">
                                                <div class="card-header" id="<?php echo esc_attr( $card_id ) ?>">
                                                    <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_<?php echo esc_attr( $card_id ) ?>" aria-expanded="true" aria-controls="collapseOne">
                                                        <?php echo $data['faq_title_s3']; ?>
                                                        <i class="icon_plus"></i><i class="icon_minus-06"></i>
                                                    </button>
                                                </div>
                                                <div id="collapse_<?php echo esc_attr( $card_id ) ?>" class="collapse <?php echo esc_attr( $show ); ?>"
                                                        aria-labelledby="<?php echo esc_attr( $card_id ) ?>"
                                                        data-parent="#accordion">
                                                    <div class="card-body"><?php echo $data['faq_desc_s3']?></div>
                                                </div>
                                            </div>
                                            <?php
                                        } ?>
                                    </div>
                                </div>
                                <?php
                            }
                        } ?>
                    </div>
                    <?php if(!empty($settings['button_text'])): ?>
                        <div class="text-center">
                            <a href="<?php  echo esc_url($settings['button_url']); ?>" class="kidzo_dbtn restaurant_btn restaurant_btn_two btn_icon"><?php esc_html_e($settings['button_text']); ?><i class="arrow_right"></i></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <?php
        }else{
            $style_class = $settings['select_style'] == 'style_2' ? 'kidzo_travel_faq' : '';
        ?>
        <section class="kidzo_faq_wrap <?php echo esc_attr( $style_class ); ?>">
            <div class="container custom_container">
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-12">
                        <?php
                        if( !empty( $settings['title'] ) ){
                            echo '<h2 class="text-center sec_title wow fadeInUp" data-wow-delay="0.2s">'. wp_kses_post( nl2br( $settings['title'] ) ) .'</h2>';
                        }
                        ?>
                        <div class="kidzo_faq_content">
                            <div class="kidzo_accordion">
                                <?php
                                $i = 0;
                                $a = 0;
                                if( is_array($settings['accordions'] ) ){
                                    foreach ( $settings['accordions'] as $accordion ){
                                        $openClass = $i == 1 ? 'open' : '';
                                        $showClass = $i == 1 ? 'show' : '';
                                        ?>
                                        <div class="kidzo_faq_item wow fadeInUp <?php echo esc_attr( $openClass ); ?>" data-wow-delay="0.4s">
                                            <?php
                                            if( !empty( $accordion['faq_title'] ) ){
                                                echo '<h5 class="kidzo_faq_title" data-toggle="collapse" data-target="#app_faq_'.$i++.'" aria-expanded="false">'. esc_html( $accordion['faq_title'] ) .'</h5>';
                                            }
                                            ?>
                                            <div id="app_faq_<?php echo $a++; ?>" class="collapse kidzo_faq_item_body <?php echo esc_attr( $showClass ) ?>" data-parent=".kidzo_accordion">
                                                <?php
                                                if( !empty( $accordion['faq_desc'] ) ){
                                                    echo '<p class="kidzo_faq_para">'. esc_html( $accordion['faq_desc'] ) .'</p>';
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
        }
    }

}