<?php
namespace kidzoCore\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_features extends Widget_Base {

    public function get_name() {
        return 'kidzo_main_features';
    }

    public function get_title() {
        return __( 'Features', 'kidzo-core' );
    }

    public function get_icon() {
        return ' eicon-posts-grid';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    /*public function get_script_depends() {
        return [ 'circle-progress' ];
    }*/

    protected function register_controls() {
	   // $features = new \Elementor\Repeater();
        // ------------------------------  Title  ------------------------------
        $this->start_controls_section(
            'title_sec', [
                'label' => __( 'Section Information', 'kidzo-core' ),
            ]
        );
	    $this->add_control(
		    'select_style',
		    [
			    'label' => esc_html__( 'Select Feature Style', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'label_block' => false,
			    'options'   => [
				    'style_1' => 'Style 1',
				    'style_2' => 'Style 2',
                    'style_3' => 'Style 3',
			    ],
			    'default' => 'style_1'
		    ]
	    );
        $this->add_control(
            'sectitle', [
                'label'       => esc_html__( 'Title Text', 'kidzo-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,
                'default'     => 'FEATURES'
            ]
        );
        $this->add_control(
            'title_html_tag',
            [
                'label' => __( 'Title HTML Tag', 'elementor' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                ],
                'default' => 'h5',
            ]
        );

        $this->add_control(
            'color_title', [
                'label' => __( 'Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 .title'
            ]
        );

         $this->add_control(
            'sec_sub_title', [
                'label'       => esc_html__( 'Sub Title Text', 'kidzo-core' ),
                'description' => esc_html__( 'Use <br> tag for line breaking.', 'kidzo-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => 'Welcome to Droit Child Care',
                 'separator' => 'before',
            ]
        );

        $this->add_control(
            'color__sub_title', [
                'label' => __( 'Sub Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_sub_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 p,
                '
            ]
        );

        $this->end_controls_section(); // End title section

        /*======================= Feature Settings  ======================== */
        
        $kidzo_features = new \Elementor\Repeater();
        $kidzo_features->start_controls_tabs( 'feature_section_block_tab' );
        $kidzo_features->start_controls_tab( 'feature_section_block_tab_content', [
                'label' => __('Content', 'kidzo-core')
            ]
        );
        $this->start_controls_section(
            'images_features_sec', [
                'label' => __( 'Program Content', 'kidzo-core' ),
            ]
        );

        $kidzo_features->add_control(
            'tf_title', [
                'label' => __( 'Program title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Pre-School Sports'
            ]
        );
        
        $kidzo_features->add_control(
            'tf_desc', [
                'label' => __( 'Program Description', 'kidzo-core' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,

            ]
        );
        $kidzo_features->add_control(
            'tf_feature_img', [
                'label' => __( 'Feature Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $kidzo_features->add_control(
            'tf_title_url', [
                'label' => __( 'Program Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#'
            ]
        );
        $kidzo_features->end_controls_tab();


        $kidzo_features->start_controls_tab( 'feature_content_tab_style', [
            'label' => __('Style', 'kidzo-core')
        ]
        );

        $kidzo_features->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => __( 'Background', 'kidzo-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .single_fetures_part',
			]
		);

        $kidzo_features->add_control(
            'featue_title_color', [
                'label' => __( 'Title Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .single_fetures_part h4' => 'color: {{VALUE}}'
        ]
            ]
        );
        $kidzo_features->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'feature_title_typo',
                'label' => __( 'Title Typography', 'kidzo-core' ),
                'selector'  => '{{WRAPPER}} {{CURRENT_ITEM}} .single_fetures_part h4'
        ]
        );
        $kidzo_features->add_control(
            'featue_sub_title_color', [
                'label' => __( 'Sub Title Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .single_fetures_part p' => 'color: {{VALUE}}'
                ]
            ]
        );
        $kidzo_features->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'feature_sub_title_typo',
                'label' => __( 'Sub Title Typography', 'kidzo-core' ),
                'selector'  => '{{WRAPPER}} {{CURRENT_ITEM}} .single_fetures_part p'
            ]
        );
        $kidzo_features->end_controls_tab();
        $this->add_control(
            'tf_features', [
                'label' => __( 'Features', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ tf_title }}}',
                'fields' => $kidzo_features->get_controls(),
            ]
        );
        $kidzo_features->end_controls_tabs();
        $this->end_controls_section();
        /*================= End Feature  =============*/
        /*======================= Feature Settings ======================== */
        $animation_images = new \Elementor\Repeater();
        $this->start_controls_section(
            'client_images_features_sec', [
                'label' => __( 'Animation Images', 'kidzo-core' ),
                'condition' => [
                    'select_style' => 'style_1'
                ]
            ]
        );
        $animation_images->add_control(
            'animation_img', [
                'label' => __( 'Images Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => 'Animation Images'
            ]
        );
        $animation_images->add_responsive_control(
            'possition_top_buttom',
            [
                'label' => __( 'Horizontal', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'possition_left_right',
            [
                'label' => __( 'Vertical', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

       $animation_images->add_responsive_control(
            'horizontal',
            [
                'label' => __( 'Horizontal Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'vertical',
            [
                'label' => __( 'Vertical Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
        $animation_images->add_control(
            'animation_feature_img', [
                'label' => __( 'Animation Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'feature_animation', [
                'label' => __( 'Animation', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ animation_img }}}',
                'fields' => $animation_images->get_controls(),
            ]
        );
        $this->end_controls_section();
        /*================= End Feature =============*/
        /**
         * Style Section
         */
        $this->start_controls_section(
            'style_sec',
            [
                'label' => __( 'Style Section', 'kidzo-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sec_bg_color',
                'label' => __( 'Section Background', 'kidzo-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '
                    {{WRAPPER}} .home_two_feture,
                    {{WRAPPER}} .fetures_part',
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings   = $this->get_settings();
        $select_style  = !empty($settings['select_style']) ? $settings['select_style'] : '';
        $stitle        = !empty( $settings['sectitle'] ) ? $settings['sectitle'] : '';
        $sub_title     = !empty( $settings['sec_sub_title'] ) ? $settings['sec_sub_title'] : '';
        $title_tag     = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
        $tf_features   = !empty( $settings['tf_features'] ) ? $settings['tf_features'] : '';
        $animation_imags  = !empty($settings['feature_animation']) ? $settings['feature_animation'] : '';
?>
<?php if($select_style == 'style_1'){ ?>
<!-- fetures part here -->
    <section class="fetures_part section_padding_feature home_two_feture">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
                        <?php
                            if(!empty($stitle)):
                                echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $stitle ) . '</' . $title_tag . '>';
                            endif;
                            if(!empty($sub_title)):
                        ?>
                        <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($sub_title); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-between">
                <?php
                    if ( count( $tf_features ) > 0 ) {
                        $i=1;
                        foreach ( $tf_features as $feature ) {
                            ?>
                            <div class="col-lg-4 col-sm-6 wow fadeInUp elementor-repeater-item-<?php echo esc_attr(  $feature['_id'] ) ?>" data-wow-delay=".2s">
                                <a href="<?php echo esc_url($feature['tf_title_url']); ?>"  class="d-block single_fetures_part <?php if($i=='2'){ echo 'orange_bg'; }elseif($i =='3' ){ echo 'yellow_bg'; }else{ } ?>">
                                    <?php if(!empty($feature['tf_feature_img']['url'])): ?>
                                    <div class="single_fetures_icon_wrapper">
                                        <img src="<?php echo esc_url($feature['tf_feature_img']['url']); ?>" alt="<?php esc_attr__('Feature Images', 'kidzo') ?>" class="img-fluid">
                                    </div>
                                    <?php endif; ?>
                                    <h4><?php echo esc_html_e($feature['tf_title']); ?></h4>
                                    <p><?php echo wp_kses_post($feature['tf_desc']); ?></p>
                                </a>
                            </div>
                            <?php
                        $i++;
                        }
                    }
                ?>
            </div>
        </div>
        <?php
            if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
                $i=1;
                foreach ( $animation_imags as $feature_imgs ) {
                    $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                    $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                    $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                    $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                    ?>
                    <div class="feature_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                        <div data-parallax='{"x": <?php echo esc_attr( $hori ); ?>, "y": <?php echo esc_attr( $varti ); ?>, "rotateZ":0}'>
                        <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>"></div>
                    </div>
                    <?php 
                $i++;
                }
            } 
        ?>
    </section>
<!-- fetures part end -->
<?php }elseif ($select_style == 'style_2') { ?>
    <section class="fetures_part section_padding fetures_part_s3">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
                        <?php
                            if(!empty($stitle)):
                                echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $stitle ) . '</' . $title_tag . '>';
                            endif;
                            if(!empty($sub_title)):
                        ?>
                        <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($sub_title); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-between">
                <?php
                    if ( count( $tf_features ) > 0 ) {
                        $i=1;
                        foreach ( $tf_features as $feature ) {
                        ?>
                            <div class="col-lg-4 col-sm-6 wow fadeInUp elementor-repeater-item-<?php echo esc_attr(  $feature['_id'] ) ?>"" data-wow-delay=".2s">
                                <div class="single_fetures_part <?php if($i=='2'){ echo 'orange_bg'; }elseif($i =='3' ){ echo 'yellow_bg'; }else{ } ?>">
                                    <?php if(!empty($feature['tf_feature_img']['url'])): ?>
                                        <div class="single_fetures_icon_wrapper">
                                            <img src="<?php echo esc_url($feature['tf_feature_img']['url']); ?>" alt="<?php esc_attr__('Feature Images', 'kidzo') ?>" class="img-fluid">
                                        </div>
                                    <?php endif; ?>
                                    <h4><?php echo esc_html_e($feature['tf_title']); ?></h4>
                                    <p><?php echo wp_kses_post($feature['tf_desc']); ?></p>
                                </div>
                            </div>
                            <?php
                        $i++;
                        }
                    }
                ?>
            </div>
        </div>
    </section>
<?php }elseif ($select_style == 'style_3') { ?> <!-- fetaures part here -->
    <section class="features_new_area section_padding">
        <img class="f_shap_bg" src="img/home6/features_bg_shap.png" alt="">
        <div class="container">
            <div class="section_tittle_style_02 new_style mb-1">
                <h2 class="title wow fadeInDown" data-wow-delay=".3s">Discover Our <span
                        class="title_overlay_effect">Features</span></h2>
                <p class="description wow fadeInDown" data-wow-delay=".3s">Kidzo mission is to provide affordable,
                    high-quality early education and childcare<br> services for working families to ensure every child.
                </p>
            </div>
            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/bookshelf.png" alt="">
                        <a href="#">
                            <h4>Primary Education</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/school.png" alt="">
                        <a href="#">
                            <h4>Daycare Sections</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/playground.png" alt="">
                        <a href="#">
                            <h4>Playground Zones</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/fruit.png" alt="">
                        <a href="#">
                            <h4>Healthy Foods</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/medal.png" alt="">
                        <a href="#">
                            <h4>Cultural Activities</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/teacher.png" alt="">
                        <a href="#">
                            <h4>Expert Teachers</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/paint.png" alt="">
                        <a href="#">
                            <h4>Arts & Crafts</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="features_new_item">
                        <img src="img/home6/playground.png" alt="">
                        <a href="#">
                            <h4>Online Lessons</h4>
                        </a>
                        <a href="#" class="arrow_btn">Learn More <i class="ti-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- features part end -->
<?php
 }         
}
}