<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_gallery extends Widget_Base {

    public function get_name() {
        return 'kidzo_gallery';
    }

    public function get_title() {
        return __( 'kidzo Gallery', 'kidzo-core' );
    }

    public function get_icon() {
        return ' eicon-carousel';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    protected function register_controls() {

        // ----------------------------------------  Gallery Style ------------------------------
        $this->start_controls_section(
            'gallery_style',
            [
                'label' => __( 'Gallery Style', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__( 'Select Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options'   => [
                    'style_1' => 'Style 1',
                    'style_2' => 'Style 2',
                ],
                'default' => 'style_1'
            ]
        );
        $this->add_control(
            'sectitle', [
                'label'       => esc_html__( 'Title Text', 'kidzo-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,
                'default'     => 'Gallery'
            ]
        );
        $this->add_control(
            'title_html_tag',
            [
                'label' => __( 'Title HTML Tag', 'elementor' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                ],
                'default' => 'h5',
            ]
            );

        $this->add_control(
            'color_title', [
                'label' => __( 'Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 .title'
            ]
        );

         $this->add_control(
            'sec_sub_title', [
                'label'       => esc_html__( 'Sub Title Text', 'kidzo-core' ),
                'description' => esc_html__( 'Use <br> tag for line breaking.', 'kidzo-core' ),
                'type'        => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'default'     => 'Welcome to Droit Child Care',
                 'separator' => 'before',
            ]
        );

        $this->add_control(
            'color__sub_title', [
                'label' => __( 'Sub Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 .description' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_sub_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 .description,
                '
            ]
        );
        $this->end_controls_section(); // End Hero content

        $this->start_controls_section(
            'partner_logo', [
                'label' => __( 'Gallery Images', 'kidzo-core' ),
            ]
        );

        /// --------------- Images ----------------
	    $image_fields = new \Elementor\Repeater();
	    $image_fields->add_control(
		    'gallery_title', [
			    'label' => __( 'Gallery Title', 'kidzo-core' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			    'default' => 'Magic Prince Birthday Party'
		    ]
	    );
        $image_fields->add_control(
            'gallery_sub_title', [
                'label' => __( 'Gallery Sub Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Kids, Daycare, Kindergarten'
            ]
        );

	    $image_fields->add_control(
		    'image', [
			    'label' => __( 'Gallery Images', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
		    ]
        );
        
        $image_fields->add_control(
		    'image_hover', [
			    'label' => __( 'Icon Images', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
		    ]
	    );

	    $this->add_control(
		    'gallery_images', [
			    'label' => __( 'Slide Gallery', 'kidzo-core' ),
			    'type' => Controls_Manager::REPEATER,
			    'title_field' => '{{{ gallery_title }}}',
			    'fields' => $image_fields->get_controls(),
		    ]
	    );
	$this->end_controls_section(); // End Hero content 

        /*======================= Feature Settings [Style Two] ======================== */
    $animation_images = new \Elementor\Repeater();
    $this->start_controls_section(
        'client_images_features_sec', [
            'label' => __( 'Animation Images', 'kidzo-core' ),
        ]
    );
    $animation_images->add_control(
        'animation_img', [
            'label' => __( 'Images Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Animation Images'
        ]
    );
    $animation_images->add_responsive_control(
        'possition_top_buttom',
        [
            'label' => __( 'Horizontal', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'possition_left_right',
        [
            'label' => __( 'Vertical', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'horizontal',
        [
            'label' => __( 'Horizontal Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'vertical',
        [
            'label' => __( 'Vertical Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
    $animation_images->add_control(
        'animation_feature_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::MEDIA,
        ]
    );
    $this->add_control(
        'feature_animation', [
            'label' => __( 'Animation', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ animation_img }}}',
            'fields' => $animation_images->get_controls(),
        ]
    );
    $this->end_controls_section();
    /*================= End Animation Images =============*/
    }

    protected function render()
    {
        $this->load_widget_script();
        $settings = $this->get_settings();
        $select_style = !empty( $settings['select_style'] ) ? $settings['select_style'] : '';
        $stitle     = !empty( $settings['sectitle'] ) ? $settings['sectitle'] : '';
        $sub_title  = !empty( $settings['sec_sub_title'] ) ? $settings['sec_sub_title'] : '';
        $title_tag  = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h5';
        $gallery_images  = !empty( $settings['gallery_images'] ) ? $settings['gallery_images'] : '';
        $animation_imags = isset($settings['feature_animation']) ? $settings['feature_animation'] : '';
    ?>
    <?php if($select_style == 'style_1'){ ?>
    <!-- kidzo_gallery One -->
    <section class="our_gallery gallery_style_2 section_padding">
        <div class="container-fluid no-gutters">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-7">
                    <div class="section_tittle_style_02">
                        <?php
                            if(!empty($stitle)):
                                echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $stitle ) . '</' . $title_tag . '>';
                            endif;
                            if(!empty($sub_title)):
                        ?>
                        <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($sub_title); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row wow fadeInDown" data-wow-delay=".5s">
                <div class="col-lg-12 p-0">
                    <div class="gallery_slider owl-carousel">
                        <?php
                        if ( is_array( $gallery_images ) && count( $gallery_images ) > 0 ) {
                            $i=1;
                            foreach ( $gallery_images as $feature_imgs ) { ?>   
                                <div class="grid-item" <?php if(!empty($feature_imgs['image']['url'])): ?> style="background-image: url('<?php echo esc_url( $feature_imgs['image']['url'] ); ?>')" <?php endif; ?>>
                                    <div class="grid_item_content">
                                        <h3><?php echo kidzo_extention_wp_kses($feature_imgs['gallery_title']); ?></h3>
                                        <p><?php echo kidzo_extention_wp_kses($feature_imgs['gallery_sub_title']); ?></p>
                                    </div>
                                </div>
                                <?php
                            } 
                        } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
            if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
                $i=1;
                foreach ( $animation_imags as $feature_imgs ) {
                    $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                    $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                    $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                    $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                    ?>
                        <div class="gallery_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                            <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                                <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo $img_title; ?>">
                            </div>
                        </div>
                    <?php 
                $i++;
                } 
            } 
        ?>
    </section>
    <?php }elseif( $select_style == 'style_2' ){ ?>
    <section class="our_gallery padding_top">
        <div class="container-fluid no-gutters">
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="section_tittle_style_02">
                        <?php
                            if(!empty($stitle)):
                                echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $stitle ) . '</' . $title_tag . '>';
                            endif;
                            if(!empty($sub_title)):
                        ?>
                        <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($sub_title); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row wow fadeInDown" data-wow-delay=".5s">
                <div class="col-lg-12 p-0">
                    <div class="grid gallery_iner gallery_popup_img">
                        <div class="grid-sizer"></div>
                        <?php
                        if ( is_array( $gallery_images ) && count( $gallery_images ) > 0 ) {
                            $i=1;
                            foreach ( $gallery_images as $feature_imgs ) {
                                if($i == 1){
                                    $classes = 'grid_item_width2 grid_item_height2'; 
                                }elseif($i == 3 || $i == 6 || $i == 7){
                                    $classes = 'grid_item_height2';
                                }else{ 
                                    $classes = '';
                                }
                                ?> 
                                <a href="<?php echo esc_url( $feature_imgs['image']['url'] ); ?>" class=" grid-item <?php echo $classes; ?>" <?php if(!empty($feature_imgs['image']['url'])): ?> style="background-image: url('<?php echo esc_url( $feature_imgs['image']['url'] ); ?>')" <?php endif; ?> >
                                    <div class="grid_item_content">
                                        <img src="<?php echo esc_url($feature_imgs['image_hover']['url']); ?>" class="gallery_item_icon" alt="<?php esc_attr__('Feature Images', 'kidzo') ?>">
                                        <h3 class="gallery_title"><?php echo kidzo_extention_wp_kses($feature_imgs['gallery_title']); ?></h3>
                                        <p><?php echo kidzo_extention_wp_kses($feature_imgs['gallery_sub_title']); ?></p>
                                    </div></a>
                                <?php
                            $i++;
                            }
                        } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
            if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
                $i=1;
                foreach ( $animation_imags as $feature_imgs ) {
                    $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                    $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                    $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                    $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : ''; ?>
                    <div class="gallery_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                        <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo $img_title; ?>">
                        </div>
                    </div>
                    <?php 
                $i++;
                } 
            } 
        ?>
    </section>
<?php }
}
    public function load_widget_script(){
        if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
            ?>
            <script>
                ( function( $ ){

                    //popular courses js
                        var popular_courses = $(".gallery_slider");
                        if (popular_courses.length) {
                            popular_courses.owlCarousel({
                                items: 4,
                                loop: true,
                                nav: false,
                                dots: false,
                                autoplay: true,
                                autoplayHoverPause: true,
                                margin: 15,
                                smartSpeed: 300,
                                dotsSpeed: 300,
                                autoplayTimeout: 3000,
                                responsive: {
                                    0: {
                                        items: 1
                                    },
                                    576: {
                                        items: 2
                                    },
                                    767: {
                                        items: 3
                                    },
                                    1200: {
                                        items: 4
                                    }
                                }
                            });
                        }
                   

                })(jQuery);
            </script>
            <?php
        }
    }

}