<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_hero extends Widget_Base {

    public function get_name() {
        return 'kidzo-hero';
    }

    public function get_title() {
        return __( 'Slide Hero', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-device-desktop';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    protected function register_controls() {

    // ----------------------------------------  Hero content ------------------------------
    $this->start_controls_section(
        'slide_style',
        [
            'label' => __( 'Slide Style', 'kidzo-core' ),
        ]
    );
    $this->add_control(
	    'select_style',
	    [
		    'label' => esc_html__( 'Select Banner Style', 'kidzo-core' ),
		    'type' => Controls_Manager::SELECT,
		    'label_block' => false,
		    'options'   => [
		        'style_1' => 'Style 1',
		        'style_2' => 'Style 2',
		        'style_3' => 'Style 3',
		        'style_4' => 'Style 4',
                'style_5' => 'Style 5',
            ],
		    'default' => 'style_1'
	    ]
    );
    $this->end_controls_section(); // End Hero content

    // ------------------------------ Title ------------------------------
    $this->start_controls_section(
        'slide_content',
        [
            'label' => __( 'Title Content', 'kidzo-core' ),
            'condition' => [
                    'select_style' => ['style_1','style_2','style_3']
            ],
        ]
    );


    $this->add_control(
        'title',
        [
            'label' => esc_html__( 'Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXTAREA,
            'label_block' => true,
            'default' => 'Baby Care & Kindergarten School',
        ]
    );
    $this->add_control(
	    'title_html_tag',
	    [
		    'label' => __( 'Title HTML Tag', 'kidzo-core' ),
		    'type' => Controls_Manager::SELECT,
		    'options' => [
			    'h1' => 'H1',
			    'h2' => 'H2',
			    'h3' => 'H3',
			    'h4' => 'H4',
			    'h5' => 'H5',
			    'h6' => 'H6',
			    'div' => 'div',
		    ],
		    'default' => 'h5',
		    'separator' => 'before',
	    ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'title_typo',
            'selector' => '
                {{WRAPPER}} .home_two_banner .single_banner_part .banner_iner h5,
                {{WRAPPER}} .get_start_part .get_start_content h4,
                {{WRAPPER}} .banner_style_3 .single_banner_part .banner_iner h5'
        ]
    );

   $this->add_control(
        'about_title_color', [
            'label'     => esc_html__('Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .home_two_banner .single_banner_part .banner_iner h5' => 'color: {{VALUE}};',
                '{{WRAPPER}} .get_start_part .get_start_content h4' => 'color: {{VALUE}};',
                '{{WRAPPER}} .banner_style_3 .single_banner_part .banner_iner h5' => 'color: {{VALUE}};',
            ),
        ]
    );

    $this->end_controls_section();

    /*===================== Sub Title =========================*/
    $this->start_controls_section(
	    'hero_subtitle',
	    [
		    'label' => __( 'Sub-title', 'kidzo-core' ),
            'condition' => [
                    'select_style' => ['style_1','style_2','style_3']
            ],
	    ]
    );
    $this->add_control(
	    'subtitle',
	    [
		    'label' => esc_html__( 'Sub Title', 'kidzo-core' ),
		    'type' => Controls_Manager::TEXTAREA,
		    'label_block' => true,
		    'default' => 'We Create Something New',
	    ]
    );
    $this->add_group_control(
	    Group_Control_Typography::get_type(), [
		    'name' => 'subtitle_typo',
		    'selector' => '
		        {{WRAPPER}} .home_two_banner .single_banner_part .banner_iner h2,
                {{WRAPPER}} .banner_style_3 .single_banner_part .banner_iner h2',
	    ]
    );

    $this->add_control(
	    'subtitle_color', [
		    'label'     => esc_html__('Color', 'kidzo-core'),
		    'type'      => Controls_Manager::COLOR,
		    'selectors' => array(
			    '{{WRAPPER}} .home_two_banner .single_banner_part .banner_iner h2' => 'color: {{VALUE}};',
                '{{WRAPPER}} .banner_style_3 .single_banner_part .banner_iner h2' => 'color: {{VALUE}};',
		    ),
	    ]
    );
    $this->end_controls_section();


    /*===================== Sub Title =========================*/
    $this->start_controls_section(
        'hero_content',
        [
            'label' => __( 'Content', 'kidzo-core' ),
            'condition' => [
                    'select_style' => 'style_3'
            ]
        ]
    );
    $this->add_control(
        'content',
        [
            'label' => esc_html__( 'Content', 'kidzo-core' ),
            'type' => Controls_Manager::TEXTAREA,
            'label_block' => true,
            'default' => 'We Create Something New',
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'content_typo',
            'selector' => '
                {{WRAPPER}} .home_two_banner .single_banner_part .banner_iner h2,
                {{WRAPPER}} .banner_style_3 .single_banner_part .banner_iner p',
        ]
    );

    $this->add_control(
        'content_color', [
            'label'     => esc_html__('Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .home_two_banner .single_banner_part .banner_iner h2' => 'color: {{VALUE}};',
                '{{WRAPPER}} .banner_style_3 .single_banner_part .banner_iner p' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->end_controls_section();


    /*===================== Button =========================*/
    $this->start_controls_section(
        'section_button',
        [
            'label' => __( 'Button', 'kidzo-core' ),
            'condition' => [
                    'select_style' => ['style_1','style_2','style_3']
            ],
        ]
    );
    $this->add_control(
        'button_label',
        [
            'label' => esc_html__( 'Button Label', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => 'Learn More',
        ]
    );
    $this->add_control(
        'button_url',
        [
            'label' => esc_html__( 'Button Url', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => '#',
        ]
    );

    $this->start_controls_tabs(
        'style_tabs'
    );

    //button Style Normal Style
    $this->start_controls_tab(
        'style_normal',
        [
            'label' => __( 'Normal', 'kidzo-core' ),
        ]
    );

    $this->add_control(
        'btn_font_color', [
            'label' => esc_html__( 'Font color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .cu_btn.btn_2' => 'color: {{VALUE}};',
                '{{WRAPPER}} .cu_btn.btn_3' => 'color: {{VALUE}};',
            ],
        ]
    );

    $this->add_control(
        'btn_bg_color', [
            'label' => esc_html__( 'Background Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .cu_btn.btn_2' => 'background-color: {{VALUE}};',
                '{{WRAPPER}} .cu_btn.btn_3' => 'background-color: {{VALUE}};',
            ],
        ]
    );

    $this->add_control(
        'cta_btn_border_color', [
            'label' => __( 'Border Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .cu_btn.btn_2' => 'border-color: {{VALUE}};',
                '{{WRAPPER}} .cu_btn.btn_3' => 'border-color: {{VALUE}};',
            ],
        ]
    );

    $this->end_controls_tab();
    //Hover Color
    $this->start_controls_tab(
        'style_hover_btn',
        [
            'label' => __( 'Hover', 'kidzo-core' ),
        ]
    );   

    $this->add_control(
        'hover_font_color', [
            'label' => __( 'Font Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .cu_btn.btn_2:hover' => 'color: {{VALUE}};',
                '{{WRAPPER}} .cu_btn.btn_3:hover' => 'color: {{VALUE}};',
            ],
        ]
    );

    $this->add_control(
        'hover_bg_color', [
            'label' => __( 'Background Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .cu_btn.btn_2:hover' => 'background: {{VALUE}};',
                '{{WRAPPER}} .cu_btn.btn_3:hover' => 'background: {{VALUE}};',
            ]

        ]
    );

    $this->add_control(
        'hover_border_color', [
            'label' => __( 'Border Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .cu_btn.btn_2' => 'border-color: {{VALUE}};',
                '{{WRAPPER}} .cu_btn.btn_3' => 'border-color: {{VALUE}};',
            ]

        ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

/*===================== Feature Images  With Videos=========================*/
    $this->start_controls_section(
	    'feature_img',
	    [
		   'label' => __( 'Feature Image', 'kidzo-core' ),
           'condition' => [
                    'select_style' => ['style_1','style_3']
            ],
	    ]
    );
    $this->add_control(
	    'feature_img_bg',
	    [
		    'label' => esc_html__( 'Feature Image', 'kidzo-core' ),
		    'type' => Controls_Manager::MEDIA,
		    'label_block' => true,
	    ]
    );
    $this->add_control(
        'video_url',
        [
            'label' => esc_html__( 'Videos URL', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'condition' => [
                    'select_style' => 'style_3'
            ]
        ]
    );
    $this->end_controls_section();


    /*======================= Feature Settings [Style Two] ======================== */
    $animation_images = new \Elementor\Repeater();
    $this->start_controls_section(
        'client_images_features_sec', [
            'label' => __( 'Animation Images', 'kidzo-core' ),
            'condition' => [
                'select_style' => ['style_1','style_2','style_3']
        ],
        ]
    );
    $animation_images->add_control(
        'animation_img', [
            'label' => __( 'Images Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Animation Images'
        ]
    );
    $animation_images->add_responsive_control(
        'possition_top_buttom',
        [
            'label' => __( 'Horizontal', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'possition_left_right',
        [
            'label' => __( 'Vertical', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]
    );


   $animation_images->add_responsive_control(
        'horizontal',
        [
            'label' => __( 'Horizontal Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'vertical',
        [
            'label' => __( 'Vertical Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
    $animation_images->add_control(
        'animation_feature_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::MEDIA,
        ]
    );
    $this->add_control(
        'feature_animation', [
            'label' => __( 'Animation', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ animation_img }}}',
            'fields' => $animation_images->get_controls(),
        ]
    );
    $this->end_controls_section();
    /*================= End Feature =============*/

    $this->start_controls_section(
        'style_sec',
        [
            'label' => __( 'Style Section', 'kidzo-core' ),
            'condition' => [
                    'select_style' => [ 'style_2', 'style_3']
            ],
            'tab' => Controls_Manager::TAB_STYLE
        ]
    );

    $this->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name' => 'sec_bg_color',
            'label' => __( 'Section Background', 'kidzo-core' ),
            'types' => [ 'classic', 'gradient' ],
            'selector' => '
                {{WRAPPER}} .banner_style_3 .single_banner_part, .animated_hero .single_banner_part,
                {{WRAPPER}} .banner_part .single_banner_part:after'
        ]
    );
    $this->end_controls_section();

    /*======================= Feature Settings  ======================== */
        
    $kidzo_slide = new \Elementor\Repeater();
    $kidzo_slide->start_controls_tabs( 'slide_section_block_tab' );
    $kidzo_slide->start_controls_tab( 'slide_section_block_tab_content', [
            'label' => __('Content', 'kidzo-core')
        ]
    );
    $this->start_controls_section(
        'images_slide_sec', [
            'label' => __( 'Slide Content', 'kidzo-core' ),
            'condition' => [
                'select_style' => 'style_4'
        ],
        ]
    );

    $kidzo_slide->add_control(
        'tf_title', [
            'label' => __( 'Slide title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXTAREA,
            'label_block' => true,
            'default' => 'We are childcare professionals'
        ]
    );
    $kidzo_slide->add_control(
        'tf_desc', [
            'label' => __( 'Sub Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXTAREA,
            'label_block' => true,
            'default' => 'We are childcare professionals'

        ]
    );
    $kidzo_slide->add_control(
        'tf_button', [
            'label' => __( 'Button Level', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Contact Us'
        ]
    );
    $kidzo_slide->add_control(
        'tf_button_url', [
            'label' => __( 'Button URL', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => '#'
        ]
    );
    $kidzo_slide->add_control(
        'slide_animaion_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::GALLERY,
        ]
    );
    $kidzo_slide->end_controls_tab();


    $kidzo_slide->start_controls_tab( 'feature_content_tab_style', [
        'label' => __('Style', 'kidzo-core')
    ]
    );

    $kidzo_slide->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'background',
            'label' => __( 'Background', 'kidzo-core' ),
            'types' => [ 'classic', 'gradient', 'video' ],
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
        ]
    );

    $kidzo_slide->add_control(
        'featue_title_color', [
            'label' => __( 'Title Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .banner_iner h2' => 'color: {{VALUE}}'
    ]
        ]
    );
    $kidzo_slide->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'feature_title_typo',
            'label' => __( 'Title Typography', 'kidzo-core' ),
            'selector'  => '{{WRAPPER}} {{CURRENT_ITEM}} .banner_iner h2'
    ]
    );
    $kidzo_slide->add_control(
        'featue_sub_title_color', [
            'label' => __( 'Sub Title Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .banner_iner p' => 'color: {{VALUE}}'
        ]
        ]
    );
    $kidzo_slide->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'feature_sub_title_typo',
            'label' => __( 'Sub Title Typography', 'kidzo-core' ),
            'selector'  => '{{WRAPPER}} {{CURRENT_ITEM}} .banner_iner p'
    ]
    );

    $kidzo_slide->add_control(
        'slide_buton_bg', [
            'label' => __( 'Button Background Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'separator' => 'before',
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .cu_btn.btn_2' => 'background-color: {{VALUE}}'
        ]
        ]
    );

    $kidzo_slide->add_control(
        'slide_button_color', [
            'label' => __( 'Button Text Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .cu_btn.btn_2' => 'color: {{VALUE}}'
        ]
        ]
    );
    $kidzo_slide->add_control(
        'slide_button_borde_color', [
            'label' => __( 'Border Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .cu_btn.btn_2' => 'border: {{VALUE}}'
        ]
        ]
    );


    $kidzo_slide->add_control(
        'slide_buton_hover_bg', [
            'label' => __( 'Button Hover Background Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'separator' => 'before',
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .cu_btn.btn_2:hover' => 'background-color: {{VALUE}}'
        ]
        ]
    );

    $kidzo_slide->add_control(
        'slide_button_hover_color', [
            'label' => __( 'Button Hover Text Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .cu_btn.btn_2:hover' => 'color: {{VALUE}}'
        ]
        ]
    );
    $kidzo_slide->add_control(
        'slide_button_hover_borde_color', [
            'label' => __( 'Hover Border Color', 'kidzo-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}} .cu_btn.btn_2:hover' => 'border: {{VALUE}}'
        ]
        ]
    );

    
 
    $kidzo_slide->end_controls_tab();
    $this->add_control(
        'tf_slide_info', [
            'label' => __( 'Slide Content', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ tf_title }}}',
            'fields' => $kidzo_slide->get_controls(),
        ]
    );
    $kidzo_slide->end_controls_tabs();
    $this->end_controls_section();
    /*================= End Feature  =============*/
    $this->start_controls_section(
        'content_section',
        [
            'label' => esc_html__( 'Content', 'kidzo-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [
                'select_style' => 'style_5'
                ],
        ]
    );
    $kidzo_repeater = new \Elementor\Repeater();

        $kidzo_repeater->add_control(
            'slide_title',
            [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Title' , 'kidzo-core' ),
                'label_block' => true,
            ]
        );
		$kidzo_repeater->add_control(
			'slide_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Sub Title' , 'kidzo-core' ),
				'label_block' => true,
			]
		);

		$kidzo_repeater->add_control(
			'slide_content',
			[
				'label' => esc_html__( 'Content', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'Kidzo mission is to provide affordable, high-quality early education and childcare services for working families.' , 'kidzo-core' ),
				'show_label' => false,
			]
		);
        $kidzo_repeater->add_control(
            'slide_button',
            [
                'label' => esc_html__( 'Button', 'kidzo-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Shop Now' , 'kidzo-core' ),
                'label_block' => true,
            ]
        );
        $kidzo_repeater->add_control(
            'button_urls', [
                'label' => __( 'Button URL', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => '#'
            ]
        );
        // all image list
        $kidzo_repeater->add_control(
			'slide_main_img',
			[
				'label' => esc_html__( 'Main Image', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $kidzo_repeater->add_control(
			'slide_shape_01',
			[
				'label' => esc_html__( 'Shape 01', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
        $kidzo_repeater->add_control(
			'slide_shape_02',
			[
				'label' => esc_html__( 'Shape 02', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
        $kidzo_repeater->add_control(
			'slide_shape_03',
			[
				'label' => esc_html__( 'Shape 03', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
        $kidzo_repeater->add_control(
			'slide_shape_04',
			[
				'label' => esc_html__( 'Shape 04', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
        $kidzo_repeater->add_control(
			'slide_shape_05',
			[
				'label' => esc_html__( 'Shape 05', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'slide_list',
			[
				'label' => esc_html__( 'Repeater List', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $kidzo_repeater->get_controls(),
				'title_field' => '{{{ slide_title }}}',
                'fields' => $kidzo_repeater->get_controls(),
			]
		);

		$this->end_controls_section();
        // style slider
        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'kidzo-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_style' => 'style_5'
                    ],
			]
		);
        $this->add_control(
			'badges_options',
			[
				'label' => esc_html__( 'Badges', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'badges_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .badges' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'badges_typography',
				'selector' => '{{WRAPPER}} .badges',
			]
		);
        //
        $this->add_control(
			'sl_title_options',
			[
				'label' => esc_html__( 'Title', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sl_title_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'sl_title_typography',
				'selector' => '{{WRAPPER}} .__title',
			]
		);
        //
        $this->add_control(
			'sl_content_options',
			[
				'label' => esc_html__( 'Content', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sl_content_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__content' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'sl_content_typography',
				'selector' => '{{WRAPPER}} .__content',
			]
		);

		$this->end_controls_section();

}

protected function render() {

$settings = $this->get_settings();
$this->load_widget_script();
$select_style    = !empty($settings['select_style']) ? $settings['select_style'] : '';
$title_tag       = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h5';
$feature_img_bg  = !empty($settings['feature_img_bg']['url']) ? $settings['feature_img_bg']['url'] : '';
$animation_imags = !empty($settings['feature_animation']) ? $settings['feature_animation'] : '';
$tf_slider       = !empty($settings['tf_slide_info']) ? $settings['tf_slide_info'] : '';
$kidzo_repeater  = !empty($settings['slide_list']) ? $settings['slide_list'] : '';
?>
<?php if($select_style == 'style_1'){ ?>
<!-- banner part here -->
<section class="banner_part home_two_banner">
    <div class="single_banner_part home_two_bg" <?php if(!empty($feature_img_bg)): ?>
        style="background-image: url('<?php echo esc_url($feature_img_bg); ?>')" <?php endif; ?>>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-7 col-lg-8 col-md-7">
                    <div class="banner_iner">
                        <?php
						    if ( ! empty( $settings['title'] ) ) {
							    echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
						    }
						    if ( ! empty( $settings['subtitle'] ) ) {
						 ?>
                        <h2><?php echo kidzo_extention_wp_kses($settings['subtitle']); ?></h2>
                        <?php 
                    		} if ( ! empty( $settings['button_label'] ) ) {
                    	?>
                        <a href="<?php echo esc_url($settings['button_url']); ?>" class="cu_btn btn_2">
                            <?php echo kidzo_extention_wp_kses($settings['button_label']); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
        <div class="banner_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
            <div
                data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
            </div>
        </div>
        <?php 
            $i++;
            } 
        } 
        ?>
    </div>
</section>
<!-- banner part end -->
<?php }elseif ($select_style == 'style_2') { ?>
<!-- banner part here -->
<section class="banner_part animated_hero">
    <div class="single_banner_part parallax_bg">
        <div class="container custom_container">
            <div class="row align-items-center justify-content-center">
                <div class="col-xl-7 col-md-10">
                    <div class="banner_iner">
                        <?php
                            if ( ! empty( $settings['title'] ) ) {
                                echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
                            }
                            if ( ! empty( $settings['subtitle'] ) ) {
                         ?>
                        <h2><?php echo kidzo_extention_wp_kses($settings['subtitle']); ?></h2>
                        <?php 
                            } if ( ! empty( $settings['button_label'] ) ) {
                        ?>
                        <a href="<?php echo esc_url($settings['button_url']); ?>" class="cu_btn btn_2">
                            <?php echo kidzo_extention_wp_kses($settings['button_label']); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
            if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
                $i=1;
                foreach ( $animation_imags as $feature_imgs ) {
                    $hori       = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                    $varti      = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                    $ani_img    = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                    $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                    ?>
        <div
            class="banner_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
            <div
                data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo $hori; ?>">
            </div>
        </div>
        <?php 
                $i++;
                } 
            } 
        ?>
    </div>
</section>
<!-- banner part end -->
<?php }elseif ($select_style == 'style_3') { ?>
<!-- banner part here -->
<section class="banner_part banner_style_3">
    <div class="single_banner_part">
        <div class="container custom_container">
            <div class="row align-items-center justify-content-between">
                <div class="col-xl-6 col-md-6 order-2 order-md-1">
                    <div class="banner_iner">
                        <?php
                            if ( ! empty( $settings['title'] ) ) {
                                echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
                            }
                            if ( ! empty( $settings['subtitle'] ) ) {
                         ?>
                        <h2><?php echo kidzo_extention_wp_kses($settings['subtitle']); ?></h2>
                        <?php } ?>
                        <?php if($settings['content']): ?>
                        <p><?php echo kidzo_extention_wp_kses($settings['content']); ?></p>
                        <?php endif; ?>
                        <?php if($settings['button_label']): ?>
                        <a href="<?php echo esc_url($settings['button_url']); ?>"
                            class="cu_btn btn_3"><?php echo wp_kses_post($settings['button_label']); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 order-1 order-md-1">
                    <?php if($settings['feature_img_bg']['url']): ?>
                    <div class="banner_video">
                        <img src="<?php echo esc_url($settings['feature_img_bg']['url']); ?>" alt="Feature Image"
                            class="img-fluid">
                        <a href="<?php echo esc_url($settings['video_url']); ?>" class="video_popup"><span
                                class="polygon_shape"></span></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
        <div class="banner_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
            <div
                data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ": 0}'>
                <img src="<?php echo esc_url($ani_img);  ?>" alt="#">
            </div>
        </div>
        <?php 
            $i++;
            } 
        }
        ?>
    </div>
</section>
<!-- banner part end -->
<?php }elseif ($select_style == 'style_4') { ?>
<section class="banner_part bannerslider owl-carousel">
    <?php
        if ( is_array( $tf_slider ) && count( $tf_slider ) > 0 ) {
            foreach ( $tf_slider as $tf_sliders ) {
            ?>
    <div class="single_banner_part bg_1 elementor-repeater-item-<?php echo esc_attr(  $tf_sliders['_id'] ) ?>">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-xl-8 col-lg-10 col-md-10">
                    <div class="banner_iner">
                        <?php if(!empty($tf_sliders['tf_title'])): ?>
                        <h2><?php echo wp_kses_post($tf_sliders['tf_title']); ?></h2>
                        <?php endif; ?>
                        <?php if(!empty($tf_sliders['tf_desc'])): ?>
                        <p><?php echo wp_kses_post($tf_sliders['tf_desc']); ?></p>
                        <?php endif; ?>
                        <?php if(!empty($tf_sliders['tf_button'])): ?>
                        <a href="<?php echo esc_url($tf_sliders['tf_button_url']); ?>"
                            class="cu_btn btn_2"><?php echo kidzo_extention_wp_kses($tf_sliders['tf_button']); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
                        $gallery = $tf_sliders['slide_animaion_img'];
                        $i=1;
                        foreach ( $gallery as $image ) { ?>
        <div class="banner_animation_<?php echo $i; ?>">
            <div data-parallax='{"x": 20, "y": 200, "rotateZ":0}'>
                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['url']); ?>">
            </div>
        </div>
        <?php 
                        $i++;
                        } 
                    ?>
    </div>
    <?php
            }
        }
        ?>
</section>
<?php }elseif ($select_style == 'style_5') { ?>
<section class="banner_part banner_slider_two bannerslider owl-carousel">
    <?php
        if ( is_array( $kidzo_repeater ) && count( $kidzo_repeater ) > 0 ) {
            $i=1;
            foreach ( $kidzo_repeater as $kidzo_repeate ) {
        ?>
    <div
        class="single_banner_part <?php if($i==2){ echo 'bg_2'; } else { echo 'bg_1'; } ?> elementor-repeater-item-<?php echo esc_attr(  $kidzo_repeate['_id'] ) ?>">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-10 col-md-12 align-items-center d-flex">
                    <div class="banner_iner text-left">
                        <?php if(!empty($kidzo_repeate['slide_sub_title'])): ?>
                        <h1 class="<?php if($i==2){ echo 'badges two'; } else { echo 'badges'; } ?>">
                            <?php echo wp_kses_post($kidzo_repeate['slide_sub_title']); ?></h1>
                        <?php endif; ?>
                        <?php if(!empty($kidzo_repeate['slide_title'])): ?>
                        <h2 class="__title"><?php echo wp_kses_post($kidzo_repeate['slide_title']); ?></h2>
                        <?php endif; ?>
                        <?php if(!empty($kidzo_repeate['slide_content'])): ?>
                        <p class="__content"><?php echo wp_kses_post($kidzo_repeate['slide_content']); ?></p>
                        <?php endif; ?>
                        <?php if(!empty($kidzo_repeate['slide_button'])): ?>
                        <a href="<?php echo esc_url($kidzo_repeate['button_urls']); ?>"
                            class="cu_btn btn_2"><?php echo kidzo_extention_wp_kses($kidzo_repeate['slide_button']); ?><i
                                class="ti-arrow-right"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-5">
                    <div class="banner_img">
                        <img src="<?php echo esc_url($kidzo_repeate['slide_shape_01']['url']); ?>" class="offer">
                        <img src="<?php echo esc_url($kidzo_repeate['slide_main_img']['url']); ?>" alt="boys_img"
                            class="boys_img">
                    </div>
                </div>
            </div>
        </div>
        <div class="banner_animation_1">
            <div data-parallax='{"x": 20, "y": 200, "rotateZ":0}'>
                <img src="<?php echo esc_url($kidzo_repeate['slide_shape_02']['url']); ?>">
            </div>
        </div>
        <div class="banner_animation_2">
            <div data-parallax='{"x": 15, "y": 150, "rotateZ":0}'>
                <img src="<?php echo esc_url($kidzo_repeate['slide_shape_03']['url']); ?>">
            </div>
        </div>
        <div class="banner_animation_3">
            <div data-parallax='{"x": 0, "y": 200, "rotateZ":0}'>
                <img src="<?php echo esc_url($kidzo_repeate['slide_shape_04']['url']); ?>">
            </div>
        </div>
        <div class="banner_animation_4">
            <div data-parallax='{"x": 10, "y": 150, "rotateZ":0}'>
                <img src="<?php echo esc_url($kidzo_repeate['slide_shape_05']['url']); ?>">
            </div>
        </div>
    </div>

    <?php
    $i++;
            }
        }
        ?>
</section>

<?php
 }  
}
public function load_widget_script(){
        if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
            ?>
<script>
(function($) {
    //banner slider js
    var bannerSlider = $(".bannerslider");
    if (bannerSlider.length) {
        bannerSlider.owlCarousel({
            items: 1,
            loop: true,
            nav: true,
            navText: ["<i class='fas fa-arrow-left'></i>", "<i class='fas fa-arrow-right'></i>"],
            dots: false,
            autoplay: true,
            autoplayHoverPause: true,
            smartSpeed: 800,
            autoplayTimeout: 3000,
            responsive: {
                0: {
                    nav: false
                },
                768: {
                    nav: true
                }
            },
        });
    }

})(jQuery);
</script>
<?php
        }
    }



}