<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_pro_category extends Widget_Base {

    public function get_name() {
        return 'kidzo_pro_category';
    }

    public function get_title() {
        return esc_html__( 'Product Category', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {
        
		$products_cats = new \Elementor\Repeater();
        $this->start_controls_section(
            'filter', [
                'label' => __( 'Shop Categories', 'kidzo-core' ),
            ]
        );
        $products_cats->add_control(
            'product_cat_id', [
                'label' => __( 'Category Name', 'kidzo-core' ),
                'description' => __( 'Choose a category name to display.', 'kidzo-core' ),
                'separator' => 'before',
                'type' => Controls_Manager::SELECT,
                'options' => kidzo_pro_cat_array('product_cat'),
                'default' => 'uncategorized'
            ]
        );
        $products_cats->add_control(
            'product_cat_img', [
                'label' => __( 'Featured Image', 'kidzo-core' ),
                'separator' => 'before',
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shop_categories', [
                'label' => __( 'Categories', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ product_cat_id }}}',
                'fields' => $products_cats->get_controls(),

            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'kidzo-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .__button',
			]
		);
        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Text Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__button' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .__button',
			]
		);
        $this->add_control(
			'button_options',
			[
				'label' => esc_html__( 'Hover Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'button_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__button:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_hover_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .__button:hover',
			]
		);
        $this->end_controls_section();


        
    }

    protected function render() {
        $settings = $this->get_settings();

	?>
<section class="product_categorie_area">
    <div class="container">
        <div class="row masonry_gallery">
            <?php
                    if ( is_array( $settings['shop_categories'] ) ) {
                        $i = 1;
                    foreach ($settings['shop_categories'] as $cat) {
                    $term   = get_term_by( 'slug', $cat['product_cat_id'], 'product_cat' ); 
                    ?>
            <div
                class="item <?php if($i==2){ echo 'col-lg-6 col-md-8 col-sm-6 col-6'; } else { echo 'col-lg-3 col-md-4 col-sm-6 col-6'; } ?>">
                <div class="pr_categorie_item <?php echo $i; ?>">
                    <?php echo wp_get_attachment_image( $cat['product_cat_img']['id'], '', array('class'=>'img-fluid') ) ?>
                    <?php 
                                if( !empty( $term ) ){                                        
                                    echo '<a class="__button pr_categorie" href="'. esc_url( get_term_link( $term->term_id ) ) .'"> '. $term->name .'</a>';
                                }                                        
                                ?>
                </div>
            </div>
            <?php
                    $i++;
                            }
                        }
                    ?>
        </div>
    </div>
</section>

<?php     
    }
    public function load_widget_script(){
		if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
			?>
<script>
(function($) {

    // product category
    var gallerys = $(".masonry_gallery");
    if (gallerys.length) {
        gallerys.imagesLoaded(function() {
            gallerys.isotope({
                itemSelector: ".item",
                percentPosition: true,
                masonry: {
                    // columnWidth: '1'
                },
            });
        });
    }
    //
})(jQuery);
</script>
<?php
		}
	}
}