<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_program extends Widget_Base {

	public function get_name() {
		return 'kidzo_program';
	}

	public function get_title() {
		return __( 'Program Info', 'kidzo-core' );
	}

	public function get_icon() {
		return ' eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'kidzo-elements' ];
	}

	public function get_script_depends() {
		return [ 'imagesloaded', 'isotope' ];
	}

	protected function register_controls() {
        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'program_style',
            [
                'label' => __( 'Program Style', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'sec_style', [
                'label' => esc_html__( 'Select Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => 'Style One',
                    'style_2' => 'Style Two',
                    'style_3' => 'Style Three',
                ],
                'default'   => 'style_1'
            ]
        );
        $this->end_controls_section();
        // Section Information
        $this->start_controls_section(
            'section_information',
            [
                'label' => __( 'Section Information', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_2'
                ]
            ]
        );

        $this->add_control(
            'sectitle', [
                'label'       => esc_html__( 'Title Text', 'kidzo-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => 'PROGRAM'
            ]
        );

        $this->add_control(
            'title_html_tag',
            [
                'label' => __( 'Title HTML Tag', 'elementor' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                ],
                'default' => 'h5',
                'separator' => 'before',
            ]
            );

        $this->add_control(
            'color_title', [
                'label' => __( 'Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 .title'
            ]
        );

        $this->add_control(
            'sec_sub_title', [
                'label'       => esc_html__( 'Sub Title Text', 'kidzo-core' ),
                'type'        => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'default'     => 'Kidzo mission is to provide affordable, high-quality early education and childcare services for working families to ensure every child.'
            ]
        );

        $this->add_control(
            'color__sub_title', [
                'label' => __( 'Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_sub_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 p'
            ]
        );

        $this->end_controls_section(); // End title section

		// -------------------------------------------- Filtering
		$this->start_controls_section(
			'program_filter', [
				'label' => __( 'Program Filter', 'kidzo-core' ),
			]
		);

		$this->add_control(
			'all_label', [
				'label' => esc_html__( 'All filter label', 'kidzo-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'See All'
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show count', 'kidzo-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 8
			]
		);

		$this->add_control(
			'order', [
				'label' => esc_html__( 'Order', 'kidzo-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

	$this->end_controls_section();

     // Section Information
     $this->start_controls_section(
        'program_title_info',
        [
            'label' => __( 'Program Title', 'kidzo-core' ),
        ]
    );

    $this->add_control(
        'age', [
            'label'       => esc_html__( 'Age Text', 'kidzo-core' ),
            'type'        => Controls_Manager::TEXT,
            'label_block' => true,
            'default'     => 'Age'
        ]
    );

    $this->add_control(
        'program_tution_fee', [
            'label'       => esc_html__( 'Tution Fee Text', 'kidzo-core' ),
            'type'        => Controls_Manager::TEXT,
            'label_block' => true,
            'default'     => 'Tution Fee'
        ]
    );

    $this->add_control(
        'program_time', [
            'label'       => esc_html__( 'Program Time Text', 'kidzo-core' ),
            'type'        => Controls_Manager::TEXT,
            'label_block' => true,
            'default'     => 'Time'
        ]
    );

   
    $this->end_controls_section(); // End title section





    /*======================= Animation Images ======================== */
    $animation_images = new \Elementor\Repeater();
    $this->start_controls_section(
        'client_images_features_sec', [
            'label' => __( 'Animation Images', 'kidzo-core' ),
            'condition' => [
                'sec_style' => 'style_1'
            ]
        ]
    );
    $animation_images->add_control(
        'animation_img', [
            'label' => __( 'Images Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Animation Images'
        ]
    );
    $animation_images->add_responsive_control(
        'possition_top_buttom',
        [
            'label' => __( 'Horizontal', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'possition_left_right',
        [
            'label' => __( 'Vertical', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]
    );


   $animation_images->add_responsive_control(
        'horizontal',
        [
            'label' => __( 'Horizontal Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'vertical',
        [
            'label' => __( 'Vertical Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
    $animation_images->add_control(
        'animation_feature_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::MEDIA,
        ]
    );
    $this->add_control(
        'feature_animation', [
            'label' => __( 'Animation', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ animation_img }}}',
            'fields' => $animation_images->get_controls(),
        ]
    );
    $this->end_controls_section();

    /*================= End Animation Images =============*/

   
    $this->start_controls_section(
        'style_sec',
        [
            'label' => __( 'Program Style', 'kidzo-core' ),
            'tab' => Controls_Manager::TAB_STYLE
        ]
    );
   
    $this->add_control(
        'title_color', [
            'label'     => esc_html__('Title Text Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_program_list .single_program_list_content h4 a' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'title_typo',
            'selector' => '
                {{WRAPPER}} .single_program_list .single_program_list_content h4 a',
        ]
    );

    $this->add_control(
        'content_color', [
            'label'     => esc_html__('Content Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_program_list .single_program_list_content p' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'content_typo',
            'selector' => '
                {{WRAPPER}} .single_program_list .single_program_list_content p',
        ]
    );

    $this->add_control(
        'list_title_color', [
            'label'     => esc_html__('List title Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_program_list .single_program_list_content .program_list_details h5' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'list_title_typo',
            'selector' => '
                {{WRAPPER}} .single_program_list .single_program_list_content .program_list_details h5',
        ]
    );

    $this->add_control(
        'list_content_color', [
            'label'     => esc_html__('List Content Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_program_list .single_program_list_content .program_list_details h5 span' => 'color: {{VALUE}};',
            ),
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'list_content_typo',
            'selector' => '
                {{WRAPPER}} .single_program_list .single_program_list_content .program_list_details h5 span',
        ]
    );
    
    
    $this->end_controls_section();

	}
	protected function render() {
        $this->load_widget_script();
		$settings  = $this->get_settings();
        $sec_style   = !empty($settings['sec_style']) ? $settings['sec_style'] : '';
        $title_tag      = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h5';
        $stitle         = !empty( $settings['sectitle'] ) ? $settings['sectitle'] : '';
        $sec_sub_title  = !empty( $settings['sec_sub_title'] ) ? $settings['sec_sub_title'] : '';
        $animation_imags  = !empty($settings['feature_animation']) ? $settings['feature_animation'] : '';

        $program_age         = !empty($settings['age']) ? $settings['age'] : '';
        $program_tution_fee  = !empty($settings['program_tution_fee']) ? $settings['program_tution_fee'] : '';
        $program_time        = !empty($settings['program_time']) ? $settings['program_time'] : '';

		$programs = new WP_Query(array(
			'post_type'     => 'program',
			'posts_per_page'=> $settings['show_count'],
			'order' => $settings['order'],
		));
		$program_cats = get_terms(array(
			'taxonomy' => 'program_cat',
			'hide_empty' => true
		));
	?>
    <?php if($sec_style == 'style_1'){ ?>
     <!-- program list part here -->
    <div class="program_list program_list_page section_padding" id="program_list">
        <div class="container custom_container">
            <div class="row">
                <div class="col-md-12">
                    <div class="filters">
                        <ul>
                            <?php
                            if(!empty($settings['all_label'])){
                                echo '<li class="is-checked" data-filter="*">'. esc_html($settings['all_label']) .'</li>';
                            }
                            if(is_array($program_cats)) {
                                foreach ( $program_cats as $program_cat ) { ?>
                                    <li data-filter=".<?php echo $program_cat->slug ?>"><?php echo $program_cat->name ?></li> <?php
                                }
                            } 
                            ?>
                        </ul>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row grid program_list_filter">
                        <?php
                        if( $programs->have_posts() ){
                            while ( $programs->have_posts() ){
                                $programs->the_post();
                                if( has_post_thumbnail() ) {
                                    $cats = get_the_terms(get_the_ID(), 'program_cat');
                                    $cat_slug = '';
                                    if(is_array($cats)) {
                                        foreach ($cats as $cat) {
                                            $cat_slug .= $cat->slug.' ';
                                        }
                                    }
                                    
                                    $age        = function_exists( 'get_field' ) ? get_field( 'age' ) : '';
                                    $tution_fee = function_exists( 'get_field' ) ? get_field( 'tution_fee' ) : '';
                                    $class_time = function_exists( 'get_field' ) ? get_field( 'class_time' ) : '';
                                    ?>
                                    <div class="col-md-6 col-lg-4 col-sm-6 grid-item <?php echo esc_attr($cat_slug);?>">
                                        <div class="single_program_list wow fadeInUp" data-wow-delay=".4s">
                                            <?php  if( has_post_thumbnail() ){ ?>
                                                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('kidzo_740x400', array('class' => 'img-fluid')) ?></a>
                                            <?php } ?>
                                            <div class="single_program_list_content">
                                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                                <p><?php echo  wp_trim_words( get_the_content(), 15, false ); ?></p>
                                                <div class="program_list_details">
                                                    <h5><?php echo kidzo_extention_wp_kses($program_age); ?><span><?php echo wp_kses_post( $age ); ?></span> </h5>
                                                    <h5><?php echo kidzo_extention_wp_kses($program_tution_fee); ?><span><?php echo wp_kses_post( $tution_fee ); ?></span> </h5>
                                                    <h5><?php echo kidzo_extention_wp_kses($program_time); ?> <span><?php echo wp_kses_post( $class_time ); ?></span> </h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php
                            }
                        }
                        wp_reset_postdata();
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?php
			if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
				$i=1;
				foreach ( $animation_imags as $feature_imgs ) {
					$hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
					$varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
					$ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
					$img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
					?>
					<div class="list_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                        <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
                        </div>
					</div>
					<?php
				$i++;
				}
			} 
       		?>
    </div>
</div>
    <!-- program list part end -->
<?php }elseif ($sec_style == 'style_2') { ?>

    <section class=" section_padding">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
                    <?php
                        if(!empty($stitle)):
                            echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">'. '<span class="title_overlay_effect">' . kidzo_extention_wp_kses( nl2br( $stitle ) ) .'</span>' . '</' . $title_tag . '>';
                        endif;
                        if(!empty($sec_sub_title)):
                    ?>
                     <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($sec_sub_title); ?></p>
                     <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php
                if( $programs->have_posts() ){
                    while ( $programs->have_posts() ){
                        $programs->the_post();
                        if( has_post_thumbnail() ) {
                            $cats = get_the_terms(get_the_ID(), 'program_cat');
                            $cat_slug = '';
                            if(is_array($cats)) {
                                foreach ($cats as $cat) {
                                    $cat_slug .= $cat->slug.' ';
                                }
                            }
                            $age        = function_exists( 'get_field' ) ? get_field( 'age' ) : '';
                            $tution_fee = function_exists( 'get_field' ) ? get_field( 'tution_fee' ) : '';
                            $class_time = function_exists( 'get_field' ) ? get_field( 'class_time' ) : ''; ?>
                            <div class="col-lg-4 col-sm-6">
                                <div class="single_program_list wow fadeInUp" data-wow-delay=".3s">
                                    <?php  if( has_post_thumbnail() ){ ?>
                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('kidzo_370x310', array('class' => 'img-fluid')) ?></a>
                                    <?php } ?>
                                    <div class="single_program_list_content">
                                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <p><?php echo  wp_trim_words( get_the_content(), 15, false ); ?></p>
                                        <div class="program_list_details">
                                            <h5><?php echo kidzo_extention_wp_kses($program_age); ?><span><?php echo kidzo_extention_wp_kses( $age ); ?></span> </h5>
                                            <h5><?php echo kidzo_extention_wp_kses($program_tution_fee); ?><span><?php echo kidzo_extention_wp_kses( $tution_fee ); ?></span> </h5>
                                            <h5><?php echo kidzo_extention_wp_kses($program_time); ?> <span><?php echo kidzo_extention_wp_kses( $class_time ); ?></span> </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        }
                    }
                    wp_reset_postdata();
                }
                ?>
            </div>
        </div>
    </section>
<?php 
    }  
}
    public function load_widget_script(){
        if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
            ?>
            <script>
                ( function( $ ){
                //banner slider js
                $(document).ready(function () {
                    var $grid = $('.program_list_filter').isotope({
                        itemSelector: '.grid-item',
                        layoutMode: 'fitRows',
                    });
                    var $buttonGroup = $('.filters');
                    $buttonGroup.on('click', 'li', function (event) {
                        $buttonGroup.find('.is-checked').removeClass('is-checked');
                        var $button = $(event.currentTarget);
                        $button.addClass('is-checked');
                        var filterValue = $button.attr('data-filter');
                        $grid.isotope({
                            filter: filterValue
                        });
                    });
                });
               
                })(jQuery);
            </script>
            <?php
        }
    }

}