<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_program_cat extends Widget_Base {

	public function get_name() {
		return 'kidzo_program_cat';
	}

	public function get_title() {
		return __( 'Program Info Cat', 'kidzo-core' );
	}

	public function get_icon() {
		return ' eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'kidzo-elements' ];
	}

	public function get_script_depends() {
		return [ 'imagesloaded', 'isotope' ];
	}

	protected function register_controls() {
        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'program_style',
            [
                'label' => __( 'Program Style', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'sec_style', [
                'label' => esc_html__( 'Select Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => 'Style One',
                ],
                'default'   => 'style_1'
            ]
        );
        $this->end_controls_section();
        // Section Information

		// -------------------------------------------- Filtering
		$this->start_controls_section(
			'program_filter', [
				'label' => __( 'Program Filter', 'kidzo-core' ),
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show count', 'kidzo-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 8
			]
		);
        $this->add_control(
            'cats', [
                'label' => esc_html__( 'Category', 'makro-core' ),
                'type' => Controls_Manager::SELECT2,
                'options' => kidzoo_cat_array( 'program_cat' ),
                'multiple' => true,
            ]
        );

	$this->end_controls_section();

    $this->start_controls_section(
        'style_sec',
        [
            'label' => __( 'Program Style', 'kidzo-core' ),
            'tab' => Controls_Manager::TAB_STYLE
        ]
    );
    $this->add_control(
        'title_options',
        [
            'label' => esc_html__( 'Title', 'kidzo-core' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ]
    );
    $this->add_control(
        'title_color', [
            'label'     => esc_html__('Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .__title' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'title_typo',
            'selector' => '
                {{WRAPPER}} .__title',
        ]
    );
    $this->add_control(
        'content_options',
        [
            'label' => esc_html__( 'Content', 'kidzo-core' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ]
    );
    $this->add_control(
        'content_color', [
            'label'     => esc_html__('Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .__content' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'content_typo',
            'selector' => '
                {{WRAPPER}} .__content',
        ]
    );
    $this->add_control(
        'age_options',
        [
            'label' => esc_html__( 'Age', 'kidzo-core' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ]
    );
    $this->add_control(
        'list_title_color', [
            'label'     => esc_html__('Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .__age' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'list_title_typo',
            'selector' => '
                {{WRAPPER}} .__age',
        ]
    );
    
    $this->end_controls_section();

	}
	protected function render() {
        $settings = $this->get_settings_for_display();
        extract($settings);
        $args = [
            'post_type' => 'program',
        ];
        if ( !empty($show_count) ) {
            $args['posts_per_page'] = $show_count;
        }
        if ( !empty($cats) ) {
            $args['tax_query'] = [
                [
                    'taxonomy' => 'program_cat',
                    'field' => 'id',
                    'terms' => $cats,
                ],
            ];
        }

        $programs = new WP_Query($args);

        ?>
<div class="container promotions_kidzo">
    <div class="row">
        <?php
            while( $programs->have_posts() ) :
            $programs->the_post();
            $cats = get_the_terms (get_the_ID(), 'program_cat');
            $age = function_exists( 'get_field' ) ? get_field( 'age' ) : '';
            $background_color = function_exists( 'get_field' ) ? get_field( 'background_color' ) : '';
            $features_img = function_exists( 'get_field' ) ? get_field( 'features_img' ) : '';
        ?>
        <div class="col-lg-6">
            <div class="promotion_item programe_item"
                style="background-color: <?php echo esc_attr($background_color); ?>;">
                <?php  if( has_post_thumbnail() ){ ?>
                <a href="<?php the_permalink(); ?>"><img class="promo_bg" src="<?php echo $features_img['url']; ?>" alt="<?php echo $features_img['alt']; ?>" /></a>
                <?php } ?>
                <div class="promotion_content">
                    <a href="<?php the_permalink(); ?>">
                        <h3 class="__title"><?php the_title(); ?></h3>
                    </a>
                    <h6 class="__age">
                        <?php echo kidzo_extention_wp_kses($age); ?><span><?php echo kidzo_extention_wp_kses( $age ); ?></span>
                    </h6>
                    <p class="__content"><?php echo  wp_trim_words( get_the_content(), 15, false ); ?></p>
                    <a href="<?php the_permalink(); ?>" class="arrow_btn">Enroll now <i class="ti-arrow-right"></i></a>
                </div>
            </div>
        </div>
        <?php
           endwhile;
        ?>
    </div>
    <?php
        }
}