<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_program_enroll extends Widget_Base {

    public function get_name() {
        return 'kidzo_program_enroll';
    }

    public function get_title() {
        return esc_html__( 'Program Enrollment', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {

        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'enroll_title',
            [
                'label' => __( 'Enrollment Title', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__( 'Enrollment Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options'   => [
                    'style_1' => 'Style 1',
                    'style_2' => 'Style 2',
                ],
                'default' => 'style_1'
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Enrollment Is Going On',
            ]
        );
	    $this->add_control(
		    'title_html_tag',
		    [
			    'label' => __( 'Title HTML Tag', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'h1' => 'H1',
				    'h2' => 'H2',
				    'h3' => 'H3',
				    'h4' => 'H4',
				    'h5' => 'H5',
				    'h6' => 'H6',
				    'div' => 'div',
			    ],
			    'default' => 'h2',
			    'separator' => 'before',
		    ]
	    );

	    $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'title_typo',
                'selector' => '
                    {{WRAPPER}} .cta_part h2,
                    {{WRAPPER}} .cta_section h2'
            ]
        );

       $this->add_control(
            'about_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .cta_part h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cta_section h2' => 'color: {{VALUE}};',
                ),
            ]
        );

        $this->end_controls_section();

        /*===================== Sub Title =========================*/
	    $this->start_controls_section(
		    'enroll_subtitle',
		    [
			    'label' => __( 'Sub-title', 'kidzo-core' ),
		    ]
	    );
	    $this->add_control(
		    'subtitle',
		    [
			    'label' => esc_html__( 'Sub-title', 'kidzo-core' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'label_block' => true,
			    'default' => 'Gain access to over 1000 Premiun resourses',
		    ]
	    );
	    $this->add_group_control(
		    Group_Control_Typography::get_type(), [
			    'name' => 'subtitle_typo',
			    'selector' => '
                    {{WRAPPER}} .cta_part p,
                    {{WRAPPER}} .single_team_section p'
		    ]
	    );

	    $this->add_control(
		    'subtitle_color', [
			    'label'     => esc_html__('Color', 'kidzo-core'),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => array(
                    '{{WRAPPER}} .cta_part p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cta_section p' => 'color: {{VALUE}};',
			    ),
		    ]
	    );
        $this->end_controls_section();

        /*===================== Button =========================*/
        $this->start_controls_section(
            'section_button',
            [
                'label' => __( 'Button', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'button_label',
            [
                'label' => esc_html__( 'Button Label', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Book Now',
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => esc_html__( 'Button Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );

        $this->start_controls_tabs(
			'style_tabs'
		);
	
		//button Style Normal Style
		$this->start_controls_tab(
			'style_normal',
			[
				'label' => __( 'Normal', 'kidzo-core' ),
			]
		);
	
		$this->add_control(
			'btn_font_color', [
				'label' => esc_html__( 'Font color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .cu_btn.btn_2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cu_btn.white_bg' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'btn_bg_color', [
				'label' => esc_html__( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .cu_btn.btn_2' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .cu_btn.white_bg' => 'background-color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'cta_btn_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .cu_btn.btn_2' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .cu_btn.white_bg' => 'border-color: {{VALUE}};',
				],
			]
		);
	
		$this->end_controls_tab();
		//Hover Color
		$this->start_controls_tab(
			'style_hover_btn',
			[
				'label' => __( 'Hover', 'kidzo-core' ),
			]
		);   
	
		$this->add_control(
			'hover_font_color', [
				'label' => __( 'Font Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .cu_btn.btn_2:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cu_btn.white_bg:hover' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'hover_bg_color', [
				'label' => __( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .cu_btn.btn_2:hover' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .cu_btn.white_bg:hover' => 'background: {{VALUE}};',
				]
	
			]
		);
	
		$this->add_control(
			'hover_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
                    '{{WRAPPER}} .cu_btn.btn_2' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .cu_btn.white_bg' => 'border-color: {{VALUE}};',
				]
	
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
        
        
	    /*===================== Feature Images =========================*/
	    $this->start_controls_section(
		    'enroll_feature_img',
		    [
			    'label' => __( 'Feature Image', 'kidzo-core' ),
		    ]
	    );
	    $this->add_control(
		    'feature_img',
		    [
			    'label' => esc_html__( 'Feature Image', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
		    ]
	    );
	    $this->add_control(
		    'feature_img_2',
		    [
			    'label' => esc_html__( 'Feature Image ', 'kidzo-core' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,

		    ]
	    );
	    $this->end_controls_section();

    /*======================= Feature Settings [Style Two] ======================== */
        $animation_images = new \Elementor\Repeater();
        $this->start_controls_section(
            'client_images_features_sec', [
                'label' => __( 'Animation Images', 'kidzo-core' ),
                'condition' => [
                    'select_style' => 'style_2'
                ]
            ]
        );
        $animation_images->add_control(
            'animation_img', [
                'label' => __( 'Images Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => 'Animation Images'
            ]
        );
        $animation_images->add_responsive_control(
            'possition_top_buttom',
            [
                'label' => __( 'Horizontal', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'possition_left_right',
            [
                'label' => __( 'Vertical', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


       $animation_images->add_responsive_control(
            'horizontal',
            [
                'label' => __( 'Horizontal Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'vertical',
            [
                'label' => __( 'Vertical Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
        $animation_images->add_control(
            'animation_feature_img', [
                'label' => __( 'Animation Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'feature_animation', [
                'label' => __( 'Animation', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ animation_img }}}',
                'fields' => $animation_images->get_controls(),
            ]
        );
        $this->end_controls_section();
        /*================= End Feature =============*/
	    
    }

    protected function render() {
        $settings = $this->get_settings();
        $select_style    = !empty($settings['select_style']) ? $settings['select_style'] : '';
	    $title_tag       = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
        $tf_features     = !empty( $settings['tf_features'] ) ? $settings['tf_features'] : '';
        $animation_imags = isset($settings['feature_animation']) ? $settings['feature_animation'] : '';
	?>
    <?php if($select_style =='style_1'){ ?>
	<!-- cta part here -->
    <section class="cta_part section_padding">
        <div class="container custom_container">
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-8">
                    <div class="cta_part_iner">
                        <?php 
                         	if ( ! empty( $settings['title'] ) ) {
								    echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
							}
                        	if ( ! empty( $settings['subtitle'] ) ) {
                 		?>
                        <p><?php echo kidzo_extention_wp_kses( $settings['subtitle'] ); ?></p>
                    	<?php } ?>
                    	<?php if ( ! empty( $settings['button_label'] ) ){ ?>
                        <a href="<?php echo esc_url($settings['button_url']); ?>" class="cu_btn white_bg"><?php echo kidzo_extention_wp_kses( $settings['button_label'] ); ?></a>
                   		<?php } ?>

                    </div>
                </div>
            </div>
        </div>
        <?php
		if ( ! empty( $settings['feature_img']['url'] ) ) { ?>
            <div class="breadcrumb_animation_1">
                <div data-parallax='{"x": 30, "y": -20}'>
                    <img src="<?php echo esc_url( $settings['feature_img']['url'] ); ?>" alt="#">
                </div>
            </div>
            <?php
        }
        if ( ! empty( $settings['feature_img_2']['url'] ) ) { ?>
            <div class="breadcrumb_animation_2">
                <div data-parallax='{"x": 20, "y": -100}'>
                    <img src="<?php echo esc_url( $settings['feature_img_2']['url'] ); ?>" alt="<?php echo esc_attr( $settings['feature_img_2'] ); ?>">
                </div>
            </div>
            <?php
        } 
        ?>
    </section>
    <!-- cta part end -->
    <?php }elseif ($select_style == 'style_2') { ?>
    
    <section class="cta_section section_padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-9 col-sm-8 wow fadeInUp" data-wow-delay=".3s">
                    <div class="cta_section_wrapper text-center">
                        <?php
                            if ( ! empty( $settings['feature_img']['url'] ) ) { ?>
                            <img src="<?php echo esc_url( $settings['feature_img']['url'] ); ?>" class="img-fluid">
                        <?php } ?>
                        <?php 
                            if ( ! empty( $settings['title'] ) ) {
                                    echo '<' . $title_tag . '>' . kidzo_extention_wp_kses( $settings['title'] ) . '</' . $title_tag . '>';
                            }
                        ?>
                        <p><?php echo kidzo_extention_wp_kses( $settings['subtitle'] ); ?></p>
                        <?php if ( ! empty( $settings['button_label'] ) ){ ?>
                        <a class="pc-button elementor-button button-link cu_btn" href="<?php echo esc_url($settings['button_url']); ?>">
                            <div class="button-content-wrapper ">
                                <span class="elementor-button-text"><?php echo kidzo_extention_wp_kses( $settings['button_label'] ); ?></span>
                                <svg class="pc-dashes inner-dashed-border animated-dashes">
                                    <rect x="5px" y="5px" rx="22px" ry="22px" width="0" height="0"></rect>
                                </svg>
                            </div>
                        </a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
                <div class="cta_animation_<?php echo $i; ?> elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                    <div data-parallax='{"x": 2, "y": 120, "rotateZ":0}'><img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>"></div>
                </div>
                <?php 
            $i++;
            } 
        } 
        ?>
    </section>
    <?php
    } 
}
}