<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_services extends Widget_Base {

    public function get_name() {
        return 'kidzo_features';
    }

    public function get_title() {
        return __( 'Services', 'kidzo-core' );
    }

    public function get_icon() {
        return ' eicon-column';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    protected function register_controls() {

	    $services = new \Elementor\Repeater();
        // ------------------------------  Title  ------------------------------
        $this->start_controls_section(
            'title_sec', [
                'label' => __( 'Section Information', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'sectitle', [
                'label'       => esc_html__( 'Title Text', 'kidzo-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,
                'default'     => 'Service'
            ]
        );
        $this->add_control(
            'title_html_tag',
            [
                'label' => __( 'Title HTML Tag', 'elementor' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                ],
                'default' => 'h2',
            ]
            );

        $this->add_control(
            'color_title', [
                'label' => __( 'Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 h2'
            ]
        );

         $this->add_control(
            'sec_sub_title', [
                'label'       => esc_html__( 'Sub Title Text', 'kidzo-core' ),
                'description' => esc_html__( 'Use <br> tag for line breaking.', 'kidzo-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => 'Welcome to Droit Child Care',
                 'separator' => 'before',
            ]
        );

        $this->add_control(
            'color__sub_title', [
                'label' => __( 'Sub Text Color', 'kidzo-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_tittle_style_02 p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_sub_title',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 p,
                '
            ]
        );
        $this->end_controls_section(); // End Sub title section

        /*======================= Feature Settings  ======================== */
        $kidzo_services = new \Elementor\Repeater();
        $this->start_controls_section(
            'kidzo_features_sec', [
                'label' => __( 'Kidzo Service', 'kidzo-core' ),
            ]
        );
        
        $kidzo_services->add_control(
            'tf_title', [
                'label' => __( 'Service title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Pre-School Sports'
            ]
        );
        $kidzo_services->add_control(
            'tf_title_url', [
                'label' => __( 'Service link', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#'
            ]
        );
        $kidzo_services->add_control(
            'tf_feature_img', [
                'label' => __( 'Feature Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $kidzo_services->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => __( 'Background', 'kidzo-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .single_service_part',
			]
        );

        $kidzo_services->add_responsive_control(
            'service_iam_width', [
                'label' => __( 'Images Width', 'kidzo-core' ),
                'type'       => Controls_Manager::SLIDER,
                'default' => [
                    'size' => '250',
                ],
                'size_units' => ['px', '%', 'em', 'rem'],
                'range'      => [
                    'px'  => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%'   => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'em'  => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],

                'selectors'  => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .service_section_img-wrapper img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $kidzo_services->add_control(
            'service_border-radius', [
                'label'      => __('Border Radius', 'droit-elementor-addons'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .single_service_part' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $kidzo_services->add_control(
            'service_iam_padding', [
                'label'      => __('Images Padding', 'droit-elementor-addons'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .service_section_img-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
       

        $this->add_control(
            'tf_features', [
                'label' => __( 'Features', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ tf_title }}}',
                'fields' => $kidzo_services->get_controls(),
            ]
        );
        $this->end_controls_section();
        /*================= End Feature  =============*/

        /*===================== Button =========================*/
        $this->start_controls_section(
            'section_button',
            [
                'label' => __( 'Button', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'button_label',
            [
                'label' => esc_html__( 'Button Label', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Get Started',
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => esc_html__( 'Button Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );

        $this->start_controls_tabs(
			'style_tabs'
		);

		//button Style Normal Style
		$this->start_controls_tab(
			'style_normal',
			[
				'label' => __( 'Normal', 'kidzo-core' ),
			]
		);

		$this->add_control(
			'btn_font_color', [
				'label' => esc_html__( 'Font color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pc-button.elementor-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bg_color', [
				'label' => esc_html__( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pc-button.elementor-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cta_btn_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pc-button.elementor-button' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		//Hover Color
		$this->start_controls_tab(
			'style_hover_btn',
			[
				'label' => __( 'Hover', 'kidzo-core' ),
			]
		);   

		$this->add_control(
			'hover_font_color', [
				'label' => __( 'Font Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pc-button.elementor-button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'hover_bg_color', [
				'label' => __( 'Background Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pc-button.elementor-button:hover' => 'background: {{VALUE}};',
				]

			]
		);

		$this->add_control(
			'hover_border_color', [
				'label' => __( 'Border Color', 'kidzo-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pc-button.elementor-button:hover' => 'border-color: {{VALUE}};',
				]

			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();

    // Animated Images 

    $animation_images = new \Elementor\Repeater();
    $this->start_controls_section(
        'client_images_service_sec', [
            'label' => __( 'Animation Images', 'kidzo-core' ),
        ]
    );
    $animation_images->add_control(
        'animation_img', [
            'label' => __( 'Images Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Animation Images'
        ]
    );
    $animation_images->add_responsive_control(
        'possition_top_buttom',
        [
            'label' => __( 'Horizontal', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'possition_left_right',
        [
            'label' => __( 'Vertical', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]
    );

   $animation_images->add_responsive_control(
        'horizontal',
        [
            'label' => __( 'Horizontal Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'vertical',
        [
            'label' => __( 'Vertical Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
    $animation_images->add_control(
        'animation_feature_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::MEDIA,
        ]
    );
    $this->add_control(
        'feature_animation', [
            'label' => __( 'Animation', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ animation_img }}}',
            'fields' => $animation_images->get_controls(),
        ]
    );
    $this->end_controls_section();
    /*================= End Feature =============*/

    
    }
    protected function render() {
    $settings = $this->get_settings();
    $stitle     = !empty( $settings['sectitle'] ) ? $settings['sectitle'] : '';
    $sub_title  = !empty( $settings['sec_sub_title'] ) ? $settings['sec_sub_title'] : '';
    $title_tag  = !empty($settings['title_html_tag']) ? $settings['title_html_tag'] : 'h2';
    $tf_features   = !empty( $settings['tf_features'] ) ? $settings['tf_features'] : '';

    $animation_imags  = !empty($settings['feature_animation']) ? $settings['feature_animation'] : '';
    ?>

    <section class="services_part section_padding position-relative">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
                        <?php
                            if(!empty($stitle)):
                                echo '<' . $title_tag . ' class="title wow fadeInDown" data-wow-delay=".5s">' . kidzo_extention_wp_kses( $stitle ) . '</' . $title_tag . '>';
                            endif;
                            if(!empty($sub_title)):
                        ?>
                        <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($sub_title); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php
                    if ( count( $tf_features ) > 0 ) {
                        $i=1;
                        foreach ( $tf_features as $feature ) { ?>
                            <div class="col-sm-6 col-lg-6 wow fadeInDown elementor-repeater-item-<?php echo esc_attr(  $feature['_id'] ) ?>" data-wow-delay=".2s">
                                <a class="single_service_part d-block" href="<?php echo esc_url($feature['tf_title_url']); ?>">
                                    <div class="service_section_img-wrapper">
                                        <?php if(!empty($feature['tf_feature_img']['url'])): ?>
                                            <img src="<?php echo esc_url( $feature['tf_feature_img']['url'] ); ?>" alt="<?php echo esc_attr( $feature['tf_feature_img'] ); ?>" class="img-fluid">
                                        <?php endif; ?>
                                    </div>
                                    <?php if(!empty($feature['tf_title'])): ?>
                                      <h5 class="service_title"><?php echo kidzo_extention_wp_kses($feature['tf_title']); ?></h5>
                                    <?php endif; ?>
                                </a>
                            </div>
                            
                            <?php
                            $i++;
                        }
                    }
                 ?>
            </div>
            <?php if(!empty($settings['button_label'])): ?>
                <a class="pc-button elementor-button button-link cu_btn" href="<?php echo esc_url($settings['button_url']); ?>">
                    <div class="button-content-wrapper ">
                        <span class="elementor-button-text"><?php echo kidzo_extention_wp_kses($settings['button_label']); ?> </span>
                        <svg class="pc-dashes inner-dashed-border animated-dashes">
                            <rect x="5px" y="5px" rx="25px" ry="25px" width="0" height="0"></rect>
                        </svg> 
                    </div>
                </a>
            <?php endif; ?>
        </div>

        <?php
            if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
                $i=1;
                foreach ( $animation_imags as $feature_imgs ) {
                    $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                    $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                    $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                    $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                    ?>
                    <div class="service_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                        <div data-parallax='{"x": <?php echo esc_attr( $hori ); ?>, "y": <?php echo esc_attr( $varti ); ?>, "rotateZ":0}'>
                        <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>"></div>
                    </div>
                    <?php 
                $i++;
                }
            } 
        ?>


    </section>
    <?php
    }
}