<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_single_button extends Widget_Base {

    public function get_name() {
        return 'kidzo_single_button';
    }

    public function get_title() {
        return __( 'Kidzo Single Button', 'kidzo-core' );
    }

    public function get_icon() {
        return ' eicon-column';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'program_style',
            [
                'label' => __( 'Program Style', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'sec_style', [
                'label' => esc_html__( 'Select Style', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => 'Style One',
                    'style_2' => 'Style Two',
                ],
                'default'   => 'style_1'
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'textdomain' ),
			]
		);
        $this->add_control(
            'button_label',
            [
                'label' => esc_html__( 'Button Label', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Get Started',
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => esc_html__( 'Button Url', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => __( 'Icon', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'ti-arrow-right',
                    'library' => 'solid',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
			'style_sec',
			[
				'label' => esc_html__( 'Style', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'sec_style' => 'style_2',
                ],
			]
		);
        // tabs start
        $this->start_controls_tabs( 'tabs_button_style' );
        $this->start_controls_tab(
            'tab_button_normal',
            [
                'label' => __( 'Normal', 'asset-coro' ),
            ]
        );
        $this->add_control(
            'icon_color_normal', [
                'label' => __( 'Icon Color', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .single_button' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .ub-btn svg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_color_normal', [
                'label' => __( 'Background Color', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single_button' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_border_radius',
            [
                'label' => __( 'Border Radius', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .single_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .ub-btn svg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_hover',
            [
                'label' => __( 'Hover', 'asset-coro' ),
            ]
        );
        $this->add_control(
            'icon_color_hover', [
                'label' => __( 'Icon Color', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .single_button:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .ub-btn svg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_color_hover', [
                'label' => __( 'Background Color', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single_button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_border_radius_hover',
            [
                'label' => __( 'Border Radius', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .single_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .ub-btn svg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        // tabs end
        $this->add_control(
            'icon_size',
            [
                'label' => __( 'Icon Size', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .single_button i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .ub-btn svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        
        $this->add_responsive_control(
            'text_padding',
            [
                'label' => __( 'Padding', 'asset-coro' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .single_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'asset-coro'),
                'type' => Controls_Manager::CHOOSE,
                'default' => '',
                'options' => [
                    'left' => [
                        'title' => __('Left', 'asset-coro'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'asset-coro'),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'asset-coro'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'selectors_dictionary' => [
                    'left' => 'flex-start',
                    'center' => 'center',
                    'right' => 'flex-end',
                ],
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .single_button' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render() {
        $this->load_widget_script();
        $settings  = $this->get_settings();
        $sec_style   = !empty($settings['sec_style']) ? $settings['sec_style'] : '';
        ?>
<?php if($sec_style == 'style_1'){ ?>
<a class="pc-button elementor-button button-link cu_btn single_button"
    href="<?php echo esc_url($settings['button_url']); ?>">
    <div class="button-content-wrapper ">
        <span class="elementor-button-text"><?php echo kidzo_extention_wp_kses($settings['button_label']); ?> </span>
        <svg class="pc-dashes inner-dashed-border animated-dashes">
            <rect x="5px" y="5px" rx="25px" ry="25px" width="0" height="0"></rect>
        </svg>

    </div>
    <span>
        <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
    </span>
</a>
<?php }elseif ($sec_style == 'style_2') { ?>
<a class="single_button" href="<?php echo esc_url($settings['button_url']); ?>">
    <span class="elementor-button-text"><?php echo kidzo_extention_wp_kses($settings['button_label']); ?> </span>
    <span><?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
</a>
<?php } ?>
<?php
   
    }
    public function load_widget_script(){
        if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
            ?>
<script>
(function($) {
    //scorll animation js

    var $title_overlay_effect = $(".title_overlay_effect");
    var $window = $(window);

    function scroll_addclass() {
        var window_height = $(window).height() - 50;
        var window_top_position = $window.scrollTop();
        var window_bottom_position = window_top_position + window_height;

        $.each($title_overlay_effect, function() {
            var $element = $(this);
            var element_height = $element.outerHeight();
            var element_top_position = $element.offset().top;
            var element_bottom_position = element_top_position + element_height;
            if (
                element_bottom_position >= window_top_position &&
                element_top_position <= window_bottom_position
            ) {
                $element.addClass("is_show");
            }
        });
    }
    $window.on("scroll resize", scroll_addclass);
    $window.trigger("scroll");

    $window.on("scroll resize", scroll_addclass);
    $window.trigger("scroll");

    //scorll animation js

})(jQuery);
</script>
<?php
        }
    }
}