<?php
namespace kidzoCore\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_subscriber extends Widget_Base {

    public function get_name() {
        return 'subscriber';
    }

    public function get_title() {
        return __( 'subscriber', 'kidzo-core' );
    }

    public function get_icon() {
        return ' eicon-column';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    protected function register_controls() {
        do_action('dl_widgets/subscriber/register_control/start', $this);

        // add content 
        $this->_content_control();
        
        do_action('dl_widgets/subscriber/register_control/end', $this);

        do_action('dl_widget/section/style/custom_css', $this);
       
    }
    public function _content_control(){
        //start subscribe fields render
        $this->start_controls_section(
            '_dl_pr_subscriber_fields_section',
            [
                'label' => __('Fields', 'kidzo-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            '_dl_field_enable',
            [
                'label' => __('Enable', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes',
            ]
        );
        
        $repeater->add_control(
            '_dl_field_title',
            [
                'label' => __('Label', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            '_dl_field_require',
            [
                'label' => __('Require', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes',
            ]
        );
        $repeater->add_control(
            '_dl_field_place',
            [
                'label' => __('Placeholder', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            '_dl_field_id',
            [
                'label' => __('Id', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::HIDDEN,
            ]
        );
        
        $this->add_control(
            '_dl_pro_subscriber_fields',
            [
                'label' => __('Setup Fields', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'item_actions' =>[
                    'duplicate' => false,
                    'add' => false,
                    'remove' => false
                ],
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        '_dl_field_enable' => 'yes',
                        '_dl_field_title' => 'Email',
                        '_dl_field_id' => 'email',
                        '_dl_field_require' => 'yes',
                        '_dl_field_place' => 'Email'
                    ],
                ],
                'title_field' => '<i class="eicon-editor-list-ul"></i> {{{ _dl_field_title }}} [{{{ _dl_field_id }}}]',
            ]
        );

        do_action('dl_widgets/subscriber/fields/content', $this);

        $this->end_controls_section();
        //start subscribe layout end


         //start intregration
        $this->start_controls_section(
            '_dl_pr_subscriber_integration_section',
            [
                'label' => __('Integration with', 'kidzo-core'),
            ]
        );
        $this->add_control(
			'_dl_pr_sub_inte_chimp',
			[
				'label' => __( 'Mailchimp', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            '_dl_pr_sub_inte_chimp_enable',
            [
                'label' => __('Enable', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'Yes',
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            '_dl_pr_sub_inte_chimp_list',
            [
                'label' => esc_html__('Select List', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => false,
                // 'options' => $this->_get_list('mailchimp'),
                'condition' => [ '_dl_pr_sub_inte_chimp_enable' => 'yes']
            ]
        );

        if( did_action('droitPro/loaded')){
            $this->add_control(
                '_dl_pr_sub_inte_response',
                [
                    'label' => __( 'Get Response', 'kidzo-core' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                '_dl_pr_sub_inte_response_list',
                [
                    'label' => esc_html__('Select List', 'kidzo-core'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'label_block' => false,
                    'options' => $this->_get_list('response'),
                ]
            );
        }

        do_action('dl_widgets/subscriber/integration/content', $this);

        $this->end_controls_section();
        //start intregration end

        // form settings
        $this->start_controls_section(
            '_dl_pr_subscriber_form_section',
            [
                'label' => __('Form settings', 'kidzo-core'),
            ]
        );
        $this->add_control(
            '_dl_sub_button_text',
            [
                'label' => __('Button Text', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Check Now', 'kidzo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            '_dl_sub_success_text',
            [
                'label' => __('Success message', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Successfully listed.', 'kidzo-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            '_dl_sub_error_text',
            [
                'label' => __('Error message', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Please enter correct info.', 'kidzo-core'),
                'label_block' => true,
            ]
        );
         

        $this->add_control(
            '_dl_pr_sub_inte_confirm_enable',
            [
                'label' => __('Confirm Checkbox', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            '_dl_pr_sub_inte_confirm_message',
            [
                'label' => __('Error message', 'kidzo-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Agree with our terms & conditions.', 'kidzo-core'),
                'label_block' => true,
                'condition' => [ '_dl_pr_sub_inte_confirm_enable' => 'yes']
            ]
        );
         

        $this->end_controls_section();
        // form settings end


    }
   /** subscriber content style controls function list wrapper **/

    public function _get_list( $provider = 'mailchimp'){
        $res = \DROIT_ELEMENTOR_PRO\Dl_Subscribe::instance()->_get_list($provider);
        if( is_array($res) && !empty($res) ){
            return $res;
        }
        return [ '' => 'Select once'];
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        extract($settings);

        $dl_sub_type = [];
        // mailchimp
        if( $_dl_pr_sub_inte_chimp_enable == 'yes'){
            $dl_sub_type['providers']['mailchimp'] = [
                'enable' => 'yes',
                'listid' => $_dl_pr_sub_inte_chimp_list
            ];
        }
        // get response
        $require = [];
        foreach($_dl_pro_subscriber_fields as $f){
            if( $f['_dl_field_enable'] == 'yes' ){
                $require[$f['_dl_field_id']] = $f['_dl_field_require'];
            }
        }
        $dl_sub_type['require'] = $require;
        $dl_sub_type['setup']['success'] = $_dl_sub_success_text;
        $dl_sub_type['setup']['error'] = $_dl_sub_error_text;
        if( $_dl_pr_sub_inte_confirm_enable == 'yes'){
            $dl_sub_type['confirm_submit'] = 'yes';
        }
        ?>

<form action="" method="post" name="dl_subscribe_addons" class="subscribe_mail input-group"
    data-settings='<?php echo json_encode($dl_sub_type, true);?>'>
    <?php
                foreach($_dl_pro_subscriber_fields as $v){
                    if( $v['_dl_field_enable'] != 'yes'){
                        continue;
                    }
                    $type = 'text';
                    $name = isset($v['_dl_field_id']) ? $v['_dl_field_id'] : '';
                    $placeholder = isset($v['_dl_field_place']) ? $v['_dl_field_place'] : '';
                    if( $name == 'email'){
                        $type = 'email';
                    }
                    ?>
    <input type="<?php echo esc_attr($type);?>" name="<?php echo esc_attr($name) ;?>" class="form-control"
        placeholder="<?php _e( esc_attr($placeholder), 'kidzo-core' );?>">

    <?php
                }
                ?>
    <button type="submit" class="cu_btn btn_2"><?php echo esc_html__($_dl_sub_button_text, 'kidzo-core');?></button>
</form>
<?php
   
    }
}