<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_teachers extends Widget_Base {

	public function get_name() {
		return 'kidzo_portfolio';
	}

	public function get_title() {
		return __( 'Teachers Info', 'kidzo-core' );
	}

	public function get_icon() {
		return ' eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'kidzo-elements' ];
	}

	public function get_script_depends() {
		return [ 'imagesloaded', 'isotope' ];
	}

	protected function register_controls() {


        // ----------------------------------------  Hero content ------------------------------
    $this->start_controls_section(
        'teacher_style',
        [
            'label' => __( 'Teachers Style', 'kidzo-core' ),
        ]
    );
    $this->add_control(
        'select_style',
        [
            'label' => esc_html__( 'Select Style', 'kidzo-core' ),
            'type' => Controls_Manager::SELECT,
            'label_block' => false,
            'options'   => [
                'style_1' => 'Style 1',
                'style_2' => 'Style 2',
                'style_3' => 'Style 3 (Without Title Bar)',
            ],
            'default' => 'style_1'
        ]
    );
     $this->add_control(
        'title',
        [
            'label' => esc_html__( 'Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'condition' => [
                'select_style' => ['style_1','style_2']
            ],
            'default' => 'Need  a Teacher',
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'title_typo',
            'condition' => [
                'select_style' => ['style_1','style_2']
            ],
            'selector' => '
                {{WRAPPER}} .section_tittle_style_02 h2,
                {{WRAPPER}} .section_tittle_style_02 h2'
        ]
    );

   $this->add_control(
        'about_title_color', [
            'label'     => esc_html__('Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'condition' => [
                'select_style' => ['style_1','style_2']
            ],
            'selectors' => array(
                '{{WRAPPER}} .section_tittle_style_02 h2' => 'color: {{VALUE}};',
                '{{WRAPPER}} .section_tittle_style_02 h2' => 'color: {{VALUE}};',
            ),
        ]
    );

    $this->add_control(
        'subtitle',
        [
            'label' => esc_html__( 'Sub Title', 'kidzo-core' ),
            'type' => Controls_Manager::WYSIWYG,
            'label_block' => true,
            'condition' => [
                'select_style' => 'style_1'
            ],
            'default' => 'Kidzo mission is to provide affordable, high-quality early education and childcare services for working families to ensure every child.',
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typo',
            'condition' => [
                'select_style' => 'style_1'
            ],
            'selector' => '
                {{WRAPPER}} .section_tittle_style_02 p',
        ]
    );
    $this->add_control(
        'subtitle_color', [
            'label'     => esc_html__('Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'condition' => [
                'select_style' => 'style_1'
            ],
            'selectors' => array(
                '{{WRAPPER}} .section_tittle_style_02 p' => 'color: {{VALUE}};',
            ),
        ]
    );
    
    $this->end_controls_section(); // End Hero content

    // -------------------------------------------- Filtering
    $this->start_controls_section(
        'portfolio_filter', [
            'label' => __( 'Teacher Filter', 'kidzo-core' ),
        ]
    );

    $this->add_control(
        'all_label', [
            'label' => esc_html__( 'All filter label', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => 'See All'
        ]
    );

    $this->add_control(
        'show_count', [
            'label' => esc_html__( 'Show count', 'kidzo-core' ),
            'type' => Controls_Manager::NUMBER,
            'default' => 8
        ]
    );

    $this->add_control(
        'order', [
            'label' => esc_html__( 'Order', 'kidzo-core' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'ASC' => 'ASC',
                'DESC' => 'DESC'
            ],
            'default' => 'ASC'
        ]
    );

    $this->end_controls_section();
    /*======================= Animation Images ======================== */
    $animation_images = new \Elementor\Repeater();
    $this->start_controls_section(
        'client_images_features_sec', [
            'label' => __( 'Animation Images', 'kidzo-core' ),
        ]
    );
     $this->add_control(
            'center_shap_images',
            [
                'label' => esc_html__( 'Center Shap Images', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
                'condition' => [
                    'select_style' => ['style_1','style_2']
                ],
                'label_block' => true,

            ]
        );
    $animation_images->add_control(
        'animation_img', [
            'label' => __( 'Images Title', 'kidzo-core' ),
            'type' => Controls_Manager::TEXT,
            'label_block' => false,
            'default' => 'Animation Images'
        ]
    );
    $animation_images->add_responsive_control(
        'possition_top_buttom',
        [
            'label' => __( 'Horizontal', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'possition_left_right',
        [
            'label' => __( 'Vertical', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 2000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]
    );

   $animation_images->add_responsive_control(
        'horizontal',
        [
            'label' => __( 'Horizontal Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
   $animation_images->add_responsive_control(
        'vertical',
        [
            'label' => __( 'Vertical Animation', 'kidzo-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 5,
                ],
                '%' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 50,
            ],
        ]
    );
    $animation_images->add_control(
        'animation_feature_img', [
            'label' => __( 'Animation Image', 'kidzo-core' ),
            'type' => Controls_Manager::MEDIA,
        ]
    );
    $this->add_control(
        'feature_animation', [
            'label' => __( 'Animation', 'kidzo-core' ),
            'type' => Controls_Manager::REPEATER,
            'title_field' => '{{{ animation_img }}}',
            'fields' => $animation_images->get_controls(),
        ]
    );
    $this->end_controls_section();
    /*================= End Feature =============*/

    /**
    * Style Section
    */
    $this->start_controls_section(
        'style_sec',
        [
            'label' => __( 'Style Section', 'kidzo-core' ),
            'tab' => Controls_Manager::TAB_STYLE
        ]
    );
    $this->add_control(
        'position_bg_color', [
            'label'     => esc_html__('Possition Background Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_team_section span' => 'background-color: {{VALUE}};',
            ),
        ]
    );
    $this->add_control(
        'position_color', [
            'label'     => esc_html__('Possition Text Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_team_section span' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'position_typo',
            'selector' => '
                {{WRAPPER}} .single_team_section span',
        ]
    );

    $this->add_control(
        'name_color', [
            'label'     => esc_html__('Teacher Name Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_team_section h4 a' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'name_typo',
            'selector' => '
                {{WRAPPER}} .single_team_section h4 a',
        ]
    );

    $this->add_control(
        'subject_color', [
            'label'     => esc_html__('Subject Color', 'kidzo-core'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .single_team_section p' => 'color: {{VALUE}};',
            ),
        ]
    );
    $this->add_group_control(
        Group_Control_Typography::get_type(), [
            'name' => 'subject_typo',
            'selector' => '
                {{WRAPPER}} .single_team_section p',
        ]
    );
    
    
    $this->end_controls_section();


	}

	protected function render() {
        $this->load_widget_script();
		$settings  = $this->get_settings();
        $select_style    = !empty($settings['select_style']) ? $settings['select_style'] : '';
        $animation_imags = isset($settings['feature_animation']) ? $settings['feature_animation'] : '';

		$portfolios = new WP_Query(array(
			'post_type'     => 'teachers',
			'posts_per_page'=> $settings['show_count'],
			'order' => $settings['order'],
		));

		$portfolio_cats = get_terms(array(
			'taxonomy' => 'teachers_cat',
			'hide_empty' => true
		));

		?>
        <!-- team part here -->
<?php if($select_style == 'style_1'){ ?>
    <section class="team_section section_padding">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
                        <?php if ( ! empty( $settings['title'] ) ) { ?>
                            <h2 class="title wow fadeInDown" data-wow-delay=".5s"><?php echo kidzo_extention_wp_kses( $settings['title'] ); ?></h2>
                        <?php } ?>
                        <?php if ( ! empty( $settings['subtitle'] ) ) { ?>
                        <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo kidzo_extention_wp_kses($settings['subtitle']); ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php
                    if( $portfolios->have_posts() ){
                        while ( $portfolios->have_posts() ){
                            $portfolios->the_post();
                            $teachers_designation = function_exists( 'get_field' ) ? get_field( 'teachers_designation' ) : '';
                            if( has_post_thumbnail() ) {
                                $cats = get_the_terms(get_the_ID(), 'teachers_cat');
                                $cat_slug = '';
                                $cat_name = '';
                                if(is_array($cats)) {
                                    foreach ($cats as $cat) {
                                        $cat_slug .= $cat->slug.' ';
                                        $cat_name .= $cat->name.' ';
                                    }
                                }
                                ?>
                                <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".3s">
                                    <div class="single_team_section">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php echo get_the_post_thumbnail( get_the_ID(), 'kidzo_350x250', array( 'class' => 'img-fluid' ) );  ?>
                                        </a>
                                        <span><?php echo kidzo_extention_wp_kses( $cat_name ); ?></span>
                                        <h4> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <p><?php echo kidzo_extention_wp_kses( $teachers_designation ); ?></p>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        wp_reset_postdata();
                    }
                ?>
            </div>
        </div>
        <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
                    <div class="team_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                        <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
                        </div>
                    </div>
                <?php 
                $i++;
            } 
        } 
        ?>
    </section>
<?php }elseif ($select_style == 'style_2') { ?>
 <section class="teacher_list section_padding">
        <div class="container custom_container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section_tittle_style_02">
                        <?php if ( ! empty( $settings['title'] ) ) { ?>
                            <h2 class="title wow fadeInDown" data-wow-delay=".5s"><?php echo kidzo_extention_wp_kses( $settings['title'] ); ?></h2>
                        <?php } ?>
                    </div>
                    
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="teacher_list_iner">
                        <?php
                        if( $portfolios->have_posts() ){
                            $i=1;
                            while ( $portfolios->have_posts() ){
                                $portfolios->the_post();
                                $teachers_designation = function_exists( 'get_field' ) ? get_field( 'teachers_designation' ) : '';
                                    if( has_post_thumbnail() ) {
                                            $cats = get_the_terms(get_the_ID(), 'teachers_cat');
                                            $cat_slug = '';
                                            $cat_name = '';
                                            if(is_array($cats)) {
                                                foreach ($cats as $cat) {
                                                    $cat_slug .= $cat->slug.' ';
                                                    $cat_name .= $cat->name.' ';
                                                }
                                            }
                                        ?>
                                        <div class="single_teacher_list">
                                            <div class="teacher_list_img <?php if( $i == 1 || $i== 3 ){ echo 'square'; }else{ echo 'circle';} ?>">
                                            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('thumbnail', array('class' => 'img-fluid')); ?></a>
                                            </div>
                                            <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                                        </div>
                                        <?php
                                    }
                            $i++;
                            }
                            
                            wp_reset_postdata();
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
                <div class="teacher_list_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                    <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                        <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
                    </div>
                </div>
                <?php 
            $i++;
           } 
        } 
        ?>
        <?php if(!empty($settings['center_shap_images']['url'])): ?>
            <div class="teacher_list_shape">
                <div><img src="<?php echo esc_url($settings['center_shap_images']['url']); ?>" alt="<?php echo esc_attr($settings['center_shap_images']); ?>"></div>
            </div>
        <?php endif; ?>
    </section>

<?php }elseif( $select_style == 'style_3' ){ ?>

    <section class="team_section single_page_team section_padding">
        <div class="container custom_container">
            <div class="row">
                <?php
                    if( $portfolios->have_posts() ){
                        while ( $portfolios->have_posts() ){
                            $portfolios->the_post();
                            $teachers_designation = function_exists( 'get_field' ) ? get_field( 'teachers_designation' ) : '';
                            if( has_post_thumbnail() ) {
                                $cats = get_the_terms(get_the_ID(), 'teachers_cat');
                                $cat_slug = '';
                                $cat_name = '';
                                if(is_array($cats)) {
                                    foreach ($cats as $cat) {
                                        $cat_slug .= $cat->slug.' ';
                                        $cat_name .= $cat->name.' ';
                                    }
                                }
                                ?>
                                <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".3s">
                                    <div class="single_team_section">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php echo get_the_post_thumbnail( get_the_ID(), 'kidzo_350x250', array( 'class' => 'img-fluid' ) );  ?>
                                        </a>
                                        <span><?php echo  kidzo_extention_wp_kses( $cat_name ); ?></span>
                                        <h4> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <p><?php echo kidzo_extention_wp_kses( $teachers_designation); ?></p>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        wp_reset_postdata();
                    }
                ?>
            </div>
        </div>
        <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
                    <div class="team_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                        <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                            <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
                        </div>
                    </div>
                <?php 
                $i++;
            } 
        } 
        ?>
    </section>

<?php } ?>
<?php
	}
	public function load_widget_script(){
		if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
			?>
            <script>
                ( function( $ ){

                   

                })(jQuery);
            </script>
			<?php
		}
	}

}