<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_testimonials extends Widget_Base {

    public function get_name() {
        return 'kidzo_testimonials';
    }

    public function get_title() {
        return __( 'Kidzo Testimonials', 'kidzo-core' );
    }

    public function get_icon() {
        return ' eicon-testimonial-carousel';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    public function get_style_depends() {
        return [ 'appart-style', 'appart-responsive', 'owl-carousel' ];
    }

    public function get_script_depends() {
        return [ 'owl-carousel' ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'title_sec', [
                'label' => __( 'Title section', 'kidzo-core' ),
            ]
        );

        $this->add_control(
		    'sec_style', [
			    'label' => esc_html__( 'Select Style', 'kidzo-core' ),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'style_1' => 'Style One',
				    'style_2' => 'Style Two',
			    ],
			    'default'   => 'style_1'
		    ]
	    );



        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title text', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'What Parents Say'
            ]
        );
        $this->add_control(
            'testimonial_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .section_tittle_style_02 h2, .__title' => 'color: {{VALUE}};',
                ),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'title_typo',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 .title, .__title'
            ]
        );
        $this->add_control(
            'sub_title', [
                'label' => esc_html__( 'Sub Title text', 'kidzo-core' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'default' => 'Kidzo mission is to provide affordable, high-quality early education and childcare services for working families to ensure every child.'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'sub_title_typo',
                'selector' => '
                    {{WRAPPER}} .section_tittle_style_02 p'
            ]
        );

        $this->add_control(
            'sub_title_color', [
                'label'     => esc_html__('Color', 'kidzo-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .section_tittle_style_02 p' => 'color: {{VALUE}};',
                ),
            ]
        );
        $this->end_controls_section(); // End title section

        // ------------------------------ Testimonial items ------------------------------
        $this->start_controls_section(
            'testimonial_sec', [
                'label' => __( 'Testimonial items', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_1'
                ],
            ]
        );
        $this->add_control(
            'testimonials', [
                'label' => __( 'Testimonials', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ author_name }}}',
                'fields' => [
                    [
                        'name' => 'author_name',
                        'label' => esc_html__('Author Name', 'kidzo-core'),
                        'type' => Controls_Manager::TEXT,
                        'default' => 'Hanson Deck',
                    ],
                    [
                        'name' => 'father_of_kid',
                        'type' => Controls_Manager::TEXT,
                        'label' => esc_html__('Designation', 'kidzo-core'),
                        'default' => 'Father of 2 Kids'
                        
                    ],
                    [
                        'name' => 'messages',
                        'type' => Controls_Manager::TEXTAREA,
                        'label' => esc_html__('Feedback Text', 'kidzo-core'),
                        'default' => 'Lorem ipsum dolor sit amet consectetur adipiscing elit donec tempus pellentesque dui vel tristique purus justo vestibulum eget lectus non gravida ultrices'
                    ],
                    [
                        'name' => 'author_image',
                        'type' => Controls_Manager::MEDIA,
                        'label' => esc_html__('Author image', 'kidzo-core'),
                    ],
                    [
                        'name' => 'quot_image',
                        'type' => Controls_Manager::MEDIA,
                        'label' => esc_html__('Quote image', 'kidzo-core'),
                    ],
                    [
                        'name' => 'shap_image',
                        'type' => Controls_Manager::MEDIA,
                        'label' => esc_html__('Shap image', 'kidzo-core'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();

    /*======================= Feature Settings [Style Two] ======================== */
        $animation_images = new \Elementor\Repeater();
        $this->start_controls_section(
            'client_images_features_sec', [
                'label' => __( 'Animation Images', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_1'
                ],
            ]
        );
        $animation_images->add_control(
            'animation_img', [
                'label' => __( 'Images Title', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => 'Animation Images'
            ]
        );
        $animation_images->add_responsive_control(
            'possition_top_buttom',
            [
                'label' => __( 'Horizontal', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'possition_left_right',
            [
                'label' => __( 'Vertical', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


       $animation_images->add_responsive_control(
            'horizontal',
            [
                'label' => __( 'Horizontal Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
       $animation_images->add_responsive_control(
            'vertical',
            [
                'label' => __( 'Vertical Animation', 'kidzo-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
            ]
        );
        $animation_images->add_control(
            'animation_feature_img', [
                'label' => __( 'Animation Image', 'kidzo-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'feature_animation', [
                'label' => __( 'Animation', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ animation_img }}}',
                'fields' => $animation_images->get_controls(),
            ]
        );
        $this->end_controls_section();
        /*================= End Feature =============*/
        $this->start_controls_section(
            'banner_sec_testi', [
                'label' => __( 'Testimonial Section', 'kidzo-core' ),
                'condition' => [
                    'sec_style' => 'style_2'
                ],
            ]
        );
        $this->add_control(
			'features_testi',
			[
				'label' => esc_html__( 'Features Image', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'shape01_testi',
			[
				'label' => esc_html__( 'Shape 01', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'shape02_testi',
			[
				'label' => esc_html__( 'Shape 02', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $testimonial_new = new \Elementor\Repeater();
        $testimonial_new->add_control(
            'content_testi', [
                'label' => esc_html__( 'Content', 'kidzo-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'It is a long established fact that a reader will be  the point of using.'
            ]
        );
        $testimonial_new->add_control(
            'name_testi', [
                'label' => esc_html__( 'Name', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Faruk'
            ]
        );
        $testimonial_new->add_control(
            'desgi_testi', [
                'label' => esc_html__( 'Desgination', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'WordPress'
            ]
        );
        $testimonial_new->add_control(
			'image_testi',
			[
				'label' => esc_html__( 'Choose Image', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);

        $this->add_control(
            'testimonals_new', [
                'label' => __( 'Testimonals', 'kidzo-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ name_testi }}}',
                'fields' => $testimonial_new->get_controls(),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $this->load_widget_script();
        $settings = $this->get_settings();
        $testimonials = isset($settings['testimonials']) ? $settings['testimonials'] : '';
        $animation_imags = isset($settings['feature_animation']) ? $settings['feature_animation'] : '';
        $testimonials_new = isset($settings['testimonals_new']) ? $settings['testimonals_new'] : '';
?>
 <?php  if( $settings['sec_style'] == 'style_1' ) {   ?>
<section class="testimonial_part section_padding">
    <div class="container custom_container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section_tittle_style_02">
                <?php if ( ! empty( $settings['title'] ) ) { ?>
                    <h2 class="title wow fadeInDown" data-wow-delay=".3s"> <span class="title_overlay_effect"><?php echo  kidzo_extention_wp_kses( $settings['title'] ); ?></span></h2>
                <?php } ?>
                <?php
                    if ( ! empty( $settings['sub_title'] ) ) { ?>
                    <p class="description wow fadeInDown" data-wow-delay=".3s"><?php echo  kidzo_extention_wp_kses( $settings['sub_title'] ); ?></p>
                <?php } ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="testimonial_slider owl-carousel">
                    <?php
                        if ( is_array( $testimonials ) && count( $testimonials ) > 0 ) {
                            $i=1;
                            foreach ( $testimonials as $testimonial_imgs ) {
                                ?>
                                <div class="single_testimonial_slider">
                                    <div class="client_speech bg_<?php echo $i; ?>">
                                        <?php if(!empty($testimonial_imgs['quot_image']['url'])): ?>
                                            <img src="<?php echo esc_url($testimonial_imgs['quot_image']['url']); ?>" alt="<?php echo esc_html_e($testimonial_imgs['author_name']); ?>">
                                        <?php endif; ?>
                                            <p><?php echo wp_kses_post($testimonial_imgs['messages']); ?></p>
                                        <?php if(!empty($testimonial_imgs['shap_image']['url'])): ?>
                                            <img src="<?php echo esc_url($testimonial_imgs['shap_image']['url']); ?>" alt="<?php echo esc_html_e($testimonial_imgs['author_name']); ?>" class="client_speech_shape">
                                        <?php endif; ?>
                                    </div>
                                    <div class="client_info">
                                        <?php if(!empty($testimonial_imgs['author_image']['url'])): ?>
                                        <img src="<?php echo esc_url($testimonial_imgs['author_image']['url']); ?>" alt="<?php echo esc_html_e($testimonial_imgs['author_name']); ?>">
                                        <?php endif; ?>
                                        <h4><?php echo esc_html_e($testimonial_imgs['author_name']); ?><span><?php echo esc_html_e($testimonial_imgs['father_of_kid']); ?></span> </h4>
                                    </div>
                                </div>
                            <?php 
                            $i++;
                            } 
                        } 
                    ?>                        
                </div>
            </div>
        </div>
    </div>
    <?php
        if ( is_array( $animation_imags ) && count( $animation_imags ) > 0 ) {
            $i=1;
            foreach ( $animation_imags as $feature_imgs ) {
                $hori    = ! empty( $feature_imgs['horizontal'] ) ? $feature_imgs['horizontal'] : '';
                $varti   = ! empty( $feature_imgs['vertical'] ) ? $feature_imgs['vertical'] : '';
                $ani_img = ! empty( $feature_imgs['animation_feature_img']['url'] ) ? $feature_imgs['animation_feature_img']['url'] : '';
                $img_title  = ! empty( $feature_imgs['animation_img'] ) ? $feature_imgs['animation_img'] : '';
                ?>
                <div class="testimonial_animation_1 elementor-repeater-item-<?php echo esc_attr(  $feature_imgs['_id'] ) ?>">
                    <div data-parallax='{"x": <?php echo esc_attr( $hori['size'] ); ?>, "y": <?php echo esc_attr( $varti['size'] ); ?>, "rotateZ":0}'>
                        <img src="<?php echo esc_url($ani_img);  ?>" alt="<?php echo esc_attr($img_title); ?>">
                    </div>
                </div>
                <?php 
            $i++;
            } 
        } 
    ?>
</section> 
<?php
 }
 elseif ( $settings['sec_style'] == 'style_2' ){
?>
 <section class="testimonial_area_new">
    <div class="testimonial_inner">
        <div class="parallax_img_one" data-parallax='{"x": 2, "y": 120, "rotateZ":0}'><img src="<?php echo esc_url($settings['shape01_testi']['url']); ?>"
                alt="#"></div>
        <div class="parallax_img_two" data-parallax='{"x": 2, "y": 120, "rotateZ":0}'><img
                src="<?php echo esc_url($settings['shape02_testi']['url']); ?>" alt="#"></div>
        <div class="row align-items-center">
            <div class="col-lg-5">
                <div class="section_tittle_style_03">
                    <h2 class="title wow fadeInDown __title" data-wow-delay=".3s"><?php echo esc_html_e($settings['title']); ?></h2>
                </div>
                <div class="testimonial_slider_new owl-carousel">
                <?php
                    foreach ( $testimonials_new as $testimonial_new ) {
                        ?>
                    <div class="item">
                        <img src="<?php echo esc_url($testimonial_new['image_testi']['url']); ?>">
                        <p><?php echo esc_html_e($testimonial_new['content_testi']); ?></p>
                        <div class="author"><?php echo esc_html_e($testimonial_new['name_testi']); ?> <span><?php echo esc_html_e($testimonial_new['desgi_testi']); ?></span></div>
                    </div>
                    <?php 
                        } 
                    ?>  
                </div>
            </div>
            <div class="col-lg-7 text-right">
                <img class="testimonial_img" src="<?php echo esc_url($settings['features_testi']['url']); ?>" alt="">
            </div>
        </div>
    </div>
</section>
 <?php 
 }

    }
	public function load_widget_script(){
		if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
			?>
            <script>
                ( function( $ ){

                    var testimonial = $(".testimonial_slider");
                    if (testimonial.length) {
                        testimonial.owlCarousel({
                            items: 2,
                            loop: true,
                            margin: 30,
                            nav: false,
                            dots: false,
                            autoplay: true,
                            autoplayHoverPause: true,
                            smartSpeed: 500,
                            dots: false,
                            responsive: {
                                0: {
                                    items: 1
                                },
                                600: {
                                    items: 2
                                }
                            }
                        });
                    }
                    // end Slider Script
                    // testimonial slider
                    var testimonialTwo = $(".testimonial_slider_new");
                    if (testimonialTwo.length) {
                        testimonialTwo.owlCarousel({
                        items: 1,
                        loop: true,
                        margin: 30,
                        nav: false,
                        dots: true,
                        autoplay: true,
                        autoplayHoverPause: true,
                        smartSpeed: 500,
                        });
                    }
                })(jQuery);
            </script>
			<?php
		}
	}
}