<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_title extends Widget_Base {

    public function get_name() {
        return 'kidzo_title';
    }

    public function get_title() {
        return __( 'Kidzo Title', 'kidzo-core' );
    }

    public function get_icon() {
        return ' eicon-column';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'Title', 'kidzo-core' ),
            ]
        );
        $this->add_control(
            'title_normal',
            [
                'label' => esc_html__( 'Title Normal', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Welcome to Droit Kids',
            ]
        );
        $this->add_control(
            'title_highlight',
            [
                'label' => esc_html__( 'Title Highlight', 'kidzo-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => ' Campus',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'kidzo-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'kidzo_title_color',
			[
				'label' => esc_html__( 'Normal Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'kidzo_title_highlights',
			[
				'label' => esc_html__( 'Highlight Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .new_style .title_overlay_effect' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'gradient'],
				'selector' => '{{WRAPPER}} .new_style .title_overlay_effect::before',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .__title',
			]
		);
        $this->add_control(
			'icon-align',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Alignment', 'textdomain' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'textdomain' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'textdomain' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'textdomain' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
			]
		);

        $this->end_controls_section();
    }
    protected function render() {
        $settings  = $this->get_settings();
        $settings = $this->get_settings_for_display();
        ?>
<div class="new_style kidzo_titles">
    <h2 class="__title wow fadeInDown" data-wow-delay=".3s">
        <?php  echo kidzo_extention_wp_kses( $settings['title_normal'] ); ?>
        <span
            class="title_overlay_effect"><?php  echo kidzo_extention_wp_kses( $settings['title_highlight'] ); ?></span>
    </h2>
</div>
<?php
    }
}