<?php
namespace kidzoCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use WP_Query;



// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class kidzo_woo_product extends Widget_Base {

    public function get_name() {
        return 'kidzo_woo_product';
    }

    public function get_title() {
        return esc_html__( 'Woo Product', 'kidzo-core' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'kidzo-elements' ];
    }


    protected function register_controls() {

        // ------------------------------ Title ------------------------------
        $this->start_controls_section(
            'product',
            [
                'label' => __( 'Product', 'kidzo-core' ),
            ]
        );
		$this->add_control(
			'select_style',
			[
				'label' => esc_html__( 'Select Product Style', 'kidzo-core' ),
				'type' => Controls_Manager::SELECT,
				'label_block' => false,
				'options'   => [
					'style_1' => 'Style 1',
					'style_2' => 'Style 2',
				],
				'default' => 'style_1'
			]
		);
		$this->add_control(
            'display_product',
            [
                'label' => __( 'Display product', 'kidzo-core' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 8,
            ]
        );
		$this->add_control(
            'order', [
                'label' => esc_html__( 'Order', 'kidzo-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => 'ASC',
                    'DESC' => 'DESC'
                ],
                'default' => 'ASC'
            ]
        );

        $this->end_controls_section();

		// style section
		
		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'kidzo-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		
		// title
		$this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .__title',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_margin',
			[
				'label' => __( 'Margin', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		// Category
		$this->add_control(
			'category_options',
			[
				'label' => esc_html__( 'Category', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .__category',
			]
		);

		$this->add_control(
			'category_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__category a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'category_margin',
			[
				'label' => __( 'Margin', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .__category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// del price
		$this->add_control(
			'old_price_options',
			[
				'label' => esc_html__( 'Old Price', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'old_typography',
				'selector' => '{{WRAPPER}} .content .price del span bdi',
			]
		);

		$this->add_control(
			'old_price_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content .price del span bdi' => 'color: {{VALUE}}',
				],
			]
		);
		// ins price
		$this->add_control(
			'new_price_options',
			[
				'label' => esc_html__( 'New Price', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'new_typography',
				'selector' => '{{WRAPPER}} .content .price ins span bdi, .content .price span bdi',
			]
		);

		$this->add_control(
			'new_price_color',
			[
				'label' => esc_html__( 'Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .content .price ins span bdi, .content .price span bdi' => 'color: {{VALUE}}',
				],
			]
		);
		
		// icons
		$this->add_control(
			'icons_options',
			[
				'label' => esc_html__( 'Icons', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'rating_icons_color',
			[
				'label' => esc_html__( 'Rating Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_area .star-rating span::before' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'regular_icons_color',
			[
				'label' => esc_html__( 'Regular Color', 'kidzo-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_area .star-rating::before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

        
    }

    protected function render() {
        $settings = $this->get_settings();
		$select_style  = !empty($settings['select_style']) ? $settings['select_style'] : '';
            $query = new WP_Query(array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'ignore_sticky_posts' => 1,
                'posts_per_page' => !empty($settings['display_product']) ? $settings['display_product'] : -1,
                'order' => !empty($settings['order']) ? $settings['order'] : 'DESC',
                'post__not_in' => !empty($settings['pro_exclude']) ? explode(',', $settings['pro_exclude']) : '',
            ));


		$column = !empty($settings['column'])  ? $settings['column'] : '3';
		$column5 = '';
		$has_col5 = '';
		if ( $column == 'w20' ) {
			$column5 = ' item_col col-lg-3';
			$column = '';
			$has_col5 = 'has_five_items';
		}
?>
<?php if($select_style == 'style_1'){ ?>
<section class="product_area">
    <div class="container">
        <div class="row <?php echo esc_attr($has_col5) ?>">
            <?php
            while( $query->have_posts() ) : $query->the_post();
                global $product;
                ?>
            <div class="col-lg-<?php echo esc_attr($column.$column5); ?> col-md-4 col-sm-6">
                <div class="pr_item <?php post_class('product_item'); ?>">
                    <a href="<?php the_permalink(); ?>" class="pr_img">
                        <?php the_post_thumbnail( 'coro_270x352' ); ?>
                    </a>
                    <div class="content">
                        <?php woocommerce_template_loop_price(); ?>
                        <a href="<?php the_permalink(); ?>">
                            <h3 class="__title" title="<?php echo esc_attr(get_the_title()) ?>">
                                <?php the_title(); ?></h3>
                        </a>
                        <div class="___dl_rating">
                            <div class="star-rating">
                                <?php
								$rating_count = $product->get_rating_count();
                                $review_count = $product->get_review_count();
                                $average = $product->get_average_rating();
                                echo wc_get_star_rating_html($average, $review_count);
							 ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            endwhile;
            wp_reset_postdata();
            ?>
        </div>
    </div>
</section>
<?php }elseif ($select_style == 'style_2'){ ?>
<section class="product_area">
    <div class="container">
        <div class="row <?php echo esc_attr($has_col5) ?>">
            <?php
            while( $query->have_posts() ) : $query->the_post();
                global $product;
                ?>
            <div class="col-lg-<?php echo esc_attr($column.$column5); ?> col-md-4 col-sm-6">
                <div class="pr_item <?php post_class('product_item'); ?>">
                    <a href="<?php the_permalink(); ?>" class="pr_img">
                        <?php the_post_thumbnail( 'coro_270x352' ); ?>
                    </a>
                    <div class="content">
                        <h4 class="__category"><?php echo wc_get_product_category_list($product->get_id()) ?></h4>
                        <a href="<?php the_permalink(); ?>">
                            <h3 class="__title" title="<?php echo esc_attr(get_the_title()) ?>">
                                <?php the_title(); ?></h3>
                        </a>
                        <?php woocommerce_template_loop_price(); ?>

                    </div>
                </div>
            </div>
            <?php
            endwhile;
            wp_reset_postdata();
            ?>
        </div>
    </div>
</section>
<?php }  ?>
<?php     
    }
}