<?php
// About us
class kidzo_Widget_Social extends WP_Widget {
    public function __construct()  { // 'About us' Widget Defined
        parent::__construct('social_links', esc_html__('(kidzo) Social Links', 'kidzo-core'), array(
            'classname'     => 'social-widget'
        ));
    }

    // Front End
    public function widget($args, $instance) {
        $title      = isset($instance['title']) ? $instance['title'] : '';
        $allowed_html = array(
                            'div' => array(
                                'id' => array(),
                                'class' => array(),
                            ),
                            'h3' => array(
                                'class' => array(),
                            ),
                            'h4' => array(
                                'class' => array(),
                            ),
                            'h5' => array(
                                'class' => array(),
                            ),
                            'h6' => array(
                                'class' => array(),
                            ),
                        );

        echo wp_kses($args['before_widget'], $allowed_html);
        echo wp_kses($args['before_title'], $allowed_html).esc_html($title).wp_kses($args['after_title'], $allowed_html);
        ?>
        
        <?php echo !empty($subtitle) ? wpautop($subtitle) : ''; ?>

        <div class="f_social_icon">
            <?php if(!empty($instance['fb'])) : ?>
                <a href="<?php echo esc_url($instance['fb']) ?>" class="social_facebook"></a>
            <?php endif; ?>
            <?php if(!empty($instance['twitter'])) : ?>
                <a href="<?php echo esc_url($instance['twitter']) ?>" class="social_twitter"></a>
            <?php endif; ?>
            <?php if(!empty($instance['google_plus'])) : ?>
                <a href="<?php echo esc_url($instance['google_plus']) ?>" class="social_googleplus"></a>
            <?php endif; ?>
            <?php if(!empty($instance['vimeo'])) : ?>
                <a href="<?php echo esc_url($instance['vimeo']) ?>" class="social_vimeo"></a>
            <?php endif; ?>
            <?php if(!empty($instance['youtube'])) : ?>
                <a href="<?php echo esc_url($instance['youtube']) ?>" class="social_youtube"></a>
            <?php endif; ?>
            <?php if(!empty($instance['pinterest'])) : ?>
                <a href="<?php echo esc_url($instance['pinterest']) ?>" class="social_pinterest"></a>
            <?php endif; ?>
        </div>

        <?php
        echo wp_kses($args['after_widget'], $allowed_html);
    }

    // Backend
    public function form($instance) {
        $title      = isset($instance['title']) ? $instance['title'] : esc_html__('Find Us On', 'kidzo-core');
        $fb         = isset($instance['fb']) ? $instance['fb'] : '';
        $twitter    = isset($instance['twitter']) ? $instance['twitter'] : '';
        $google_plus= isset($instance['google_plus']) ? $instance['google_plus'] : '';
        $vimeo      = isset($instance['vimeo']) ? $instance['vimeo'] : '';
        $youtube    = isset($instance['youtube']) ? $instance['youtube'] : '';
        $pinterest    = isset($instance['pinterest']) ? $instance['pinterest'] : '';
        ?>
        <table style="width:100%">
            <!-- Title -->
            <tr> <th style="text-align: left"> <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title', 'kidzo-core') ?></label> </th> </tr>
            <tr> <td> <input type="text" name="<?php echo esc_attr($this->get_field_name('title')); ?>" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                             class="widefat" value="<?php echo esc_attr($title); ?>" placeholder="<?php esc_attr_e('Enter the widget title', 'kidzo-core'); ?>"> </td> </tr>

            <!-- Facebook -->
            <tr> <th style="text-align: left"> <label for="<?php echo esc_attr($this->get_field_id('fb')); ?>"><?php esc_html_e('Facebook', 'kidzo-core') ?></label> </th> </tr>
            <tr> <td> <input type="text" name="<?php echo esc_attr($this->get_field_name('fb')); ?>" id="<?php echo esc_attr($this->get_field_id('fb')); ?>"
                             class="widefat" value="<?php echo esc_attr($fb); ?>"> </td> </tr>
            <!-- Twitter -->
            <tr> <th style="text-align: left"> <label for="<?php echo esc_attr($this->get_field_id('twitter')); ?>"><?php esc_html_e('Twitter', 'kidzo-core') ?></label> </th> </tr>
            <tr> <td> <input type="text" name="<?php echo esc_attr($this->get_field_name('twitter')); ?>" id="<?php echo esc_attr($this->get_field_id('twitter')); ?>"
                             class="widefat" value="<?php echo esc_attr($twitter); ?>"> </td> </tr>
            <!-- Google Plus -->
            <tr> <th style="text-align: left"> <label for="<?php echo esc_attr($this->get_field_id('google_plus')); ?>"><?php esc_html_e('Google Plus', 'kidzo-core') ?></label> </th> </tr>
            <tr> <td> <input type="text" name="<?php echo esc_attr($this->get_field_name('google_plus')); ?>" id="<?php echo esc_attr($this->get_field_id('google_plus')); ?>"
                             class="widefat" value="<?php echo esc_attr($google_plus); ?>"> </td> </tr>
            <!-- Vimeo -->
            <tr> <th style="text-align: left"> <label for="<?php echo esc_attr($this->get_field_id('vimeo')); ?>"><?php esc_html_e('Vimeo', 'kidzo-core') ?></label> </th> </tr>
            <tr> <td> <input type="text" name="<?php echo esc_attr($this->get_field_name('vimeo')); ?>" id="<?php echo esc_attr($this->get_field_id('vimeo')); ?>"
                             class="widefat" value="<?php echo esc_attr($vimeo); ?>"> </td> </tr>
            <!-- Youtube -->
            <tr> <th style="text-align: left"> <label for="<?php echo esc_attr($this->get_field_id('youtube')); ?>"><?php esc_html_e('Youtube', 'kidzo-core') ?></label> </th> </tr>
            <tr> <td> <input type="text" name="<?php echo esc_attr($this->get_field_name('youtube')); ?>" id="<?php echo esc_attr($this->get_field_id('youtube')); ?>"
                             class="widefat" value="<?php echo esc_attr($youtube); ?>"> </td> </tr>
            <!-- Pinterest -->
            <tr> <th style="text-align: left"> <label for="<?php echo esc_attr($this->get_field_id('pinterest')); ?>"><?php esc_html_e('Pinterest', 'kidzo-core') ?></label> </th> </tr>
            <tr> <td> <input type="text" name="<?php echo esc_attr($this->get_field_name('pinterest')); ?>" id="<?php echo esc_attr($this->get_field_id('pinterest')); ?>"
                             class="widefat" value="<?php echo esc_attr($pinterest); ?>"> </td> </tr>

        </table>
    <?php
    }

    // Update Data
    public function update($new_instance, $old_instance){
        $instance = $old_instance;
        $instance['title']      = $new_instance['title'];
        $instance['fb']      = $new_instance['fb'];
        $instance['twitter']      = $new_instance['twitter'];
        $instance['google_plus']      = $new_instance['google_plus'];
        $instance['vimeo']      = $new_instance['vimeo'];
        $instance['youtube']      = $new_instance['youtube'];
        $instance['pinterest']      = $new_instance['pinterest'];

        return $instance;
    }

}