<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

if ( !function_exists( 'chld_thm_cfg_parent_css' ) ):
    function chld_thm_cfg_parent_css() {
        wp_enqueue_style( 'chld_thm_cfg_parent', trailingslashit( get_template_directory_uri() ) . 'style.css', array( 'bootstrap','flaticon','kidzomainstyle','wpdstyle','kidzogutenberg','kidzoshop','themefyicon','owlcarousel','niceselectstyle','magnific_popup','fontawesome','woocommerce-kidzo','elegenticon' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'chld_thm_cfg_parent_css', 10 );

// END ENQUEUE PARENT ACTION
/****************************our custom changes******************************/
//disable auto update
add_filter( 'auto_update_theme', '__return_false' );
add_filter( 'auto_update_plugin', '__return_false' );
/*custom ultimate member validation*/
add_action( 'um_custom_field_validation_user_email_details','um_custom_validate_user_email_details', 999, 3 );

function um_custom_validate_user_email_details( $key, $array, $args ) {

    if ( $key == 'user_email' && isset( $args['user_email'] )) {

        if ( empty( $args['user_email'] )) {

            UM()->form()->add_error( 'user_email', __( 'You must provide your email', 'ultimate-member' ));
        
        } elseif ( !is_email( $args['user_email'] ) || !filter_var( $args['user_email'], FILTER_VALIDATE_EMAIL )) {

            UM()->form()->add_error( 'user_email', __( 'Please provide a valid e-mail', 'ultimate-member' ));

        } elseif ( email_exists( $args['user_email'] )) {

            UM()->form()->add_error( 'user_email', __( 'The email you entered is already registered', 'ultimate-member' ) );
      }

    }
    
}
function um_custom_validate_username( $args ) {    

        
    
        if(username_exists( $args["user_login"] ))
        {
            UM()->form()->add_error( 'user_login', __( 'Your username already exist.', 'ultimate-member' ));
        }
        
    
    
}
add_action('um_submit_form_errors_hook_','um_custom_validate_username', 999, 1);