<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Kidzo
 */
$opt = get_option('kidzo_opt');
$site_preloder_active  = isset( $opt['site_preloder_active']) ? $opt['site_preloder_active'] : '';

$is_menu_btn     = isset( $opt['is_menu_btn']) ? $opt['is_menu_btn'] : '';
$menu_btn_label  = isset( $opt['menu_btn_label']) ? $opt['menu_btn_label'] : '';
$menu_btn_url    = isset( $opt['menu_btn_url']) ? $opt['menu_btn_url'] : '';
$main_logo       = isset( $opt['main_logo']['url'] ) ? $opt['main_logo']['url'] : get_template_directory_uri().'/assets/img/logo.png';
$retina_logo     = isset( $opt['retina_logo']['url'] ) ? $opt['retina_logo']['url'] : get_template_directory_uri().'/assets/img/ratina_logo.png';
$logo_srcset     = !empty($retina_logo) ?  "srcset='$retina_logo 2x'" : '';

$is_email_btn         = isset( $opt['is_email_btn']) ? $opt['is_email_btn'] : '';
$topbar_email_id      = isset( $opt['topbar_email_id']) ? $opt['topbar_email_id'] : '';
$is_content_btn       = isset( $opt['is_content_btn']) ? $opt['is_content_btn'] : '';
$topbar_contact_no    = isset( $opt['topbar_contact_no']) ? $opt['topbar_contact_no'] : '';
$is_social_top_btn    = isset( $opt['is_social_top_btn']) ? $opt['is_social_top_btn'] : '';
$topbar_social_level  = isset( $opt['topbar_social_level']) ? $opt['topbar_social_level'] : '';

$page_header    = function_exists( 'get_field' ) ? get_field( 'page_header' ) : '';
$header_top_bar = function_exists( 'get_field' ) ? get_field( 'header_top_bar' ) : '1';
$header_layout  = function_exists( 'get_field' ) ? get_field( 'header_layout' ) : '';

if($header_layout == 'white'){
    $header_class = "";
    $button_class = "cu_btn btn_1";
}else{
   // $header_class = "position_fixed header_style_3";
    $header_class = "";
    $button_class = "cu_btn white_btn";
}
?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="twitter:title" content="The Best Free Elementor Addons" />
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<?php if($site_preloder_active == 1){ ?>
 <!-- Preloader  -->
    <div class='preloder'>
        <div class='loader'>
            <div class='loader--dot'></div>
            <div class='loader--dot'></div>
            <div class='loader--dot'></div>
            <div class='loader--dot'></div>
            <div class='loader--dot'></div>
            <div class='loader--dot'></div>
            <div class='loader--text'></div>
        </div>
    </div>
    <!-- End Preloader  -->
<?php } ?>
<?php  if ( class_exists( 'ReduxFramework' ) ) { ?>
    <div class="sub_header section_bg">
        <div class="container custom_container">
            <div class="row align-items-center">
                <div class="col-xl-6 col-lg-7 col-md-8">
                    <div class="header_contact_info">
                        <?php if($is_email_btn == '1'): ?>
                        <a href="mailto:<?php echo kidzo_extention_wp_kses( $topbar_email_id ); ?>" target="_blank"><i
                                class="fas fa-envelope"></i><?php echo kidzo_extention_wp_kses( $topbar_email_id ); ?></a>
                        <?php endif; ?>
                        <?php if($is_content_btn == '1'): ?>
                        <a href="tel:<?php echo kidzo_extention_wp_kses( $topbar_contact_no ); ?>"><i class="fas fa-phone"></i><?php echo kidzo_extention_wp_kses( $topbar_contact_no ); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-5 col-md-4">
                    <div class="header_social_icon">
                    <?php if($is_social_top_btn == '1'): ?>
                        <p><?php echo kidzo_extention_wp_kses( $topbar_social_level ); ?></p>
                        <?php kidzo_social_links(); ?>
                    <?php endif; ?>
                    <div class="employee_portal_link">                    
					</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<header class="header header_part <?php echo esc_attr( $header_class ); ?>">
    <div class="container custom_container">
        <div class="row align-items-center">
            <div class="col-lg-12">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <?php if(!empty($main_logo)){ ?>
                    <a class="navbar-brand" href="<?php echo esc_url(get_home_url()); ?>">
                        <img src="<?php echo esc_url($main_logo); ?>" <?php echo kidzo_extention_wp_kses($logo_srcset); ?> alt="<?php bloginfo('name'); ?>"></a>
                    <?php } ?>
                    <button class="navbar-toggler" type="button" data-toggle="collapse"
                        data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <span class="ti-menu"></span>
                    </button>
                    <?php 
                    if ( has_nav_menu('main_menu') ) { ?>
                        <div class="collapse navbar-collapse justify-content-end" id="navbarSupportedContent">
                            <?php
                                wp_nav_menu(array(
                                    'menu' => 'main_menu',
                                    'theme_location' => 'main_menu',
                                    'menu_class' => 'navbar-nav',
                                    'container' => 'ul',
                                    'depth' => 3,
                                    'walker' => new kidzo_Nav_Navwalker()
                                ));
                            ?>
                            <?php if($is_menu_btn == 1){ ?> 
                                <a href="<?php echo esc_url($menu_btn_url); ?>" class="<?php echo esc_attr($button_class); ?>"><?php echo kidzo_extention_wp_kses( $menu_btn_label ); ?></a>
                            <?php } ?>
                            <?php 
                            $is_mini_cart = isset( $opt['is_mini_cart'] ) ? $opt['is_mini_cart'] : '';
                            if( class_exists( 'WooCommerce'  ) &&  $is_mini_cart =='1' ){
                               get_template_part('template-parts/mini', 'cart');
                            }
                            ?>
                        </div>
                    <?php } ?>
                </nav>
            </div>
        </div>
    </div>
</header>
    <!-- End Preloader  -->
    <?php 
    if( $page_header == '1' || is_home() || is_single() || is_search() || is_archive() ):
        $is_header_animation     = isset( $opt['is_header_animation_show']) ? $opt['is_header_animation_show'] : '';
        $header_animation_images = isset( $opt['header_animation_images']) ? $opt['header_animation_images'] : '';
        $header_background_bg    = isset( $opt['header_background_bg']['url']) ? $opt['header_background_bg']['url'] : '';
    ?>
    <!-- breadcrumb part -->
    <section class="breadcrumb_part">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="breadcrumb_iner">
                        <h1><?php kidzo_banner_title(); ?></h1>
                        <?php if(is_singular('post')){ ?>
                            <div class="breadcrumb_iner_link">
                                <?php the_category(', ') ?>
                                <span>|</span>
                                <p><?php echo esc_html( get_the_date(get_option('date_format')) ); ?></p>
                            </div>   
                        <?php }else{ ?>
                        <div class="breadcrumb_iner_link">
                            <a href="<?php echo get_site_url(); ?>"><?php echo  esc_html_e('Home', 'kidzo'); ?></a>
                            <span>|</span>
                            <p><?php kidzo_banner_sub_title(); ?></p>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php 
        if($is_header_animation == 1):
            $blog_img = explode(",", $header_animation_images);
            $i = 1;
            foreach($blog_img as $imageB):
                $imag_blog = wp_get_attachment_image_src($imageB);
                ?>
                    <?php if($i == 1){ ?>
                        <div class="breadcrumb_animation_4">
                            
                            <div data-parallax='{"x": 30, "y": 250, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($imageB, 'full') ?>
                            </div>
                        </div>
                    <?php }elseif ($i == 2) { ?>
                        <div class="breadcrumb_animation_5">
                            <div data-parallax='{"x": 20, "y": 150, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($imageB, 'full') ?>
                            </div>
                        </div>
                    <?php }elseif ($i == 3) { ?>
                        <div class="breadcrumb_animation_7">
                            <div data-parallax='{"x": 100, "y": 250, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($imageB, 'full') ?>
                            </div>
                        </div>
                    <?php }elseif ($i == 4) { ?>
                        <div class="breadcrumb_animation_10">
                            <div data-parallax='{"x": 15, "y": 150, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($imageB, 'full') ?>
                            </div>
                        </div>
                    <?php }elseif ($i == 5) { ?>
                        <div class="breadcrumb_animation_12">
                            <div data-parallax='{"x": 20, "y": 150, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($imageB, 'full') ?>
                            </div>
                        </div>
                    <?php }elseif ($i == 6) { ?>
                        <div class="breadcrumb_animation_13">
                            <div data-parallax='{"x": 10, "y": 250, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($imageB, 'full') ?>
                            </div>
                        </div>
                    <?php } ?>
                <?php
                $i++;
            endforeach; 
        endif; 
        ?>
    </section>
    <!-- breadcrumb part end -->
    <?php
endif;