<?php
/**
 * Kidzo functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Kidzo
 */

if ( ! defined( 'KIDZO_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'KIDZO_VERSION', wp_get_theme()->get( 'Version' ) );
}



if ( ! function_exists( 'kidzo_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function kidzo_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Kidzo, use a find and replace
		 * to change 'kidzo' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'kidzo', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Enable excerpt support for page
		add_post_type_support( 'page', 'excerpt' );

		// Enable WooCommerce Support
		add_theme_support( 'woocommerce' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'main_menu' => esc_html__( 'Top Menu', 'kidzo' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'kidzo_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add Theme post type 
		add_theme_support( 'post-formats', array( 'audio', 'video', 'quote', 'link' ) );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

	}
endif;
add_action( 'after_setup_theme', 'kidzo_setup' );




/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function kidzo_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'kidzo_content_width', 640 );
}
add_action( 'after_setup_theme', 'kidzo_content_width', 0 );



/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Constants
 * Defining default asset paths
 */
define('KIDZO_DIR_CSS', get_template_directory_uri().'/assets/css');
define('KIDZO_DIR_JS', get_template_directory_uri().'/assets/js');
define('KIDZO_DIR_VEND', get_template_directory_uri().'/assets/vendors');
define('KIDZO_DIR_IMG', get_template_directory_uri().'/assets/img');
define('KIDZO_DIR_FONT', get_template_directory_uri().'/assets/fonts');

/**
 * Enqueue scripts and styles.
 */
require get_template_directory() . '/inc/enqueue.php';

/**
 * Enqueue scripts and styles.
 */
require get_template_directory() . '/inc/Kidzo_functions.php';

/**
 * Theme Option File
 */
require get_template_directory() . '/inc/options/opt-config.php';


/**
 * Theme Option File
 */
require get_template_directory() . '/inc/sidebars.php';

/**
 * Menu Option
 */
require get_template_directory() . '/inc/kidzo_Nav_Navwalker.php';

/**
 * TGM Plugin intregation 
 */

require get_template_directory() . '/inc/tgm/class-plugins.php';
require get_template_directory() . '/inc/tgm/tgm-plugin-activation.php';
require get_template_directory() . '/inc/tgm/tgm-plugin-registration.php';


/**
 * One Click Demo
 */
require get_template_directory() . '/inc/one_click_demo_config.php';

/**
 * One Click Demo   
 */
require get_template_directory() . '/inc/kidzo-walker-comment.php';


require get_template_directory() . '/inc/woocommerce_ajax.php';
/**
 * For Woocommerces
 */
add_filter('woocommerce_show_page_title', '__return_false');
   
add_filter( 'woocommerce_add_to_cart_fragments', 'wc_refresh_mini_cart_count');

