<?php
/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package kidzo
 */


// Image sizes
add_image_size('kidzo_740x40', 740, 480, true); // Blog list thumbnail
add_image_size('kidzo_80x80', 80, 80, true); // Blog sidebar thumbnail
add_image_size('kidzo_350x250', 350, 250, true); // Teacher thumbnail
add_image_size('kidzo_250x250', 250, 250, true); // Related thumbnail
add_image_size('kidzo_370x310', 370, 310, true); // Related thumbnail
add_image_size('kidzo_1170x500', 1170, 500, true); // Event Single thumbnail
add_image_size('kidzo_195x235', 195, 235, true); // Event 
add_image_size('kidzo_515x300', 515, 300, true); //Event Block Feature Image
add_image_size('kidzo_640x545', 640, 545, true); //Teacher Single
add_image_size('kidzo_535x424', 535, 424, true); // Program Single Images



// Pagination
function kidzo_pagination() {
    the_posts_pagination(array(
        'screen_reader_text' => ' ',
        'prev_text'          => '<i class="ti-arrow-left"></i>',
        'next_text'          => '<i class="ti-arrow-right"></i>'
    ));
}

// Comment list
function kidzo_comments($comment, $args, $depth){
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);
    ?>
    <li <?php comment_class( $args['has_children'] ? 'post_comment has_children' :'post_comment') ?> id="comment-<?php comment_ID() ?>">
         <div class="media">
            <?php
            if(get_avatar($comment)) {
                echo get_avatar($comment, 60, null, null, array('class'=> 'admin_img'));
            }
            ?>
            <div class="media-body">
                <div class="admin_tittle">
                    <a href="#"><h5><?php comment_author(); ?><span><?php comment_date(get_option('date_format')); ?></span></h5></a>
                    <div class="comment_rep_btn">
                        <?php comment_reply_link( array_merge( $args, array( 'reply_text' => esc_html__( 'Reply', 'kidzo' ), 'depth' => $depth,  'max_depth' => $args['max_depth'] ) ) ); ?> 
                        <i class="fas fa-long-arrow-alt-right"></i>
                    </div>
                </div>
                <?php comment_text(); ?>
            </div>
        </div>
    </li>
    <?php
}
// add class comment reply link
add_filter('comment_reply_link', 'eiser_replace_reply_link_class');
function eiser_replace_reply_link_class( $class ) {
	$class = str_replace("class='comment-reply-link", "class='reply_btn reply_link comment-reply-link ", $class);
	return $class;
}


// Social Links
function kidzo_social_links() {
    $opt = get_option('kidzo_opt');
    ?>
    <?php if(!empty($opt['facebook'])) { ?>
         <a href="<?php echo esc_url($opt['facebook']); ?>" target="_blank"><i class="social_facebook"></i></a>
    <?php } ?>
    <?php if(!empty($opt['twitter'])) { ?>
         <a href="<?php echo esc_url($opt['twitter']); ?>" target="_blank"><i class="social_twitter" ></i></a>
    <?php } ?>
    <?php if(!empty($opt['vimeo'])) { ?>
        <a href="<?php echo esc_url($opt['vimeo']); ?>" target="_blank"><i class="social_vimeo"></i></a>
    <?php } ?>
    <?php if(!empty($opt['instagram'])) { ?>
        <a href="<?php echo esc_url($opt['instagram']); ?>" target="_blank"><i class="social_instagram"></i></a>
    <?php } ?>
    <?php if(!empty($opt['linkedin'])) { ?>
        <a href="<?php echo esc_url($opt['linkedin']); ?>" target="_blank"><i class="social_linkedin" ></i></a>
    <?php } ?>
    <?php if(!empty($opt['youtube'])) { ?>
        <a href="<?php echo esc_url($opt['youtube']); ?>" target="_blank"><i class="social_youtube" ></i></a>
    <?php } ?>
    <?php if(!empty($opt['dribbble'])) { ?>
        <a href="<?php echo esc_url($opt['dribbble']); ?>" target="_blank"><i class="social_dribbble" ></i></a>
    <?php } ?>
    <?php
}

// Search form
function kidzo_search_form($is_button=true) {
    ?>
    <div class="kidzo-search">
        <form class="form-wrapper" action="<?php echo esc_url(home_url('/')); ?>" _lpchecked="1">
            <input type="text" id="search" placeholder="<?php esc_attr_e('Search ...', 'kidzo'); ?>" name="s">
            <button type="submit" class="btn"><i class="fa fa-search"></i></button>
        </form>
        <?php if($is_button==true) { ?>
        <a href="<?php echo esc_url(home_url('/')); ?>" class="home_btn"> <?php esc_html_e('Back to home Page', 'kidzo'); ?> </a>
        <?php } ?>
    </div>
    <?php
}

// Day link to archive page
function kidzo_day_link() {
    $archive_year   = get_the_time('Y');
    $archive_month  = get_the_time('m');
    $archive_day    = get_the_time('d');
    echo get_day_link( $archive_year, $archive_month, $archive_day);
}

// Limit latter
function kidzo_limit_latter($string, $limit_length, $suffix = '...') {
    if (strlen($string) > $limit_length) {
        return strip_shortcodes(substr($string, 0, $limit_length) . $suffix);
    }
    else {
        return strip_shortcodes( kidzo_extention_wp_kses($string) );
    }
}

// Get comment count text

function kidzo_comment_count($post_id, $no_comments = 'No Comments') {
    $comments_number = get_comments_number($post_id);
    if($comments_number == 0) {
        $comment_text = $no_comments;
    }elseif($comments_number == 1) {
        $comment_text = esc_html__('1 Comment', 'kidzo');
    }elseif($comments_number > 1) {
        $comment_text = $comments_number.esc_html__(' Comments', 'kidzo');
    }
    echo esc_html($comment_text);
}



/**
 * Moving the comments text field to bottom
 */
function kidzo_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields[ 'comment' ];
    unset( $fields[ 'comment' ] );
    $fields[ 'comment' ] = $comment_field;
    return $fields;
}

add_filter( 'comment_form_fields', 'kidzo_move_comment_field_to_bottom' );


// Post's excerpt text
function kidzo_excerpt( $settings_key, $echo = true) {
    $opt = get_option('kidzo_opt');
    $excerpt_limit = !empty($opt[$settings_key]) ? $opt[$settings_key] : 60;
    $excerpt = wp_trim_words(get_the_excerpt(), $excerpt_limit, '');
    if($echo == true) {
        echo esc_html($excerpt);
    }else {
        return esc_html($excerpt);
    }
}

function kidzo_excerpt_more( $excerpt ) {
    return '';
}
add_filter( 'excerpt_more', 'kidzo_excerpt_more' );

// Banner Title
function kidzo_banner_title() {
    $opt = get_option('kidzo_opt');
    if( is_404() ){
	    $title_404 = !empty($opt['error_heading']) ? $opt['error_heading'] : esc_html__('404', 'kidzo');
        echo esc_html( $title_404 );
    }
    elseif (is_home()) {
        $blog_title = !empty($opt['blog_title']) ? $opt['blog_title'] : esc_html__('Blog', 'kidzo');
        echo esc_html($blog_title);
    } 

    elseif (class_exists( 'WooCommerce') && is_shop()) {
        echo !empty( $opt['shop_title'] ) ? esc_html( $opt['shop_title'] ) : esc_html__( 'Shop Page', 'kidzo' );
    }

    elseif (is_singular('post')) {
        echo the_title();
    } 
    elseif (is_singular('events')) {
        $event_title = !empty($opt['event_single_title']) ? $opt['event_single_title'] : esc_html__('Event Details', 'kidzo');
        echo esc_html($event_title);
    } 
    elseif (is_singular('program')) { 
        $program_title = !empty($opt['program_single_title']) ? $opt['program_single_title'] : esc_html__('Program Details', 'kidzo');
        echo esc_html($program_title);
    } 
    elseif (is_singular('teachers')) {
        $teacher_title = !empty($opt['teacher_single_title']) ? $opt['teacher_single_title'] : esc_html__('Teacher Details', 'kidzo');
        echo esc_html($teacher_title);
    }
    elseif (is_page() || is_single()) {
        $breadcrumb_text = !empty($opt['breadcrumb_text']) ? $opt['breadcrumb_text'] : '';
        if(!empty($breadcrumb_text)){
            echo esc_html($breadcrumb_text); 
        }else{
        the_title();
        }
    } 
    elseif (is_category()) {
        single_cat_title();
    } 
    elseif (is_archive()) {
        the_archive_title();
    } 
    elseif (is_search()) {
        esc_html_e('Search result for: &quot;', 'kidzo');
        echo get_search_query() . '&quot';
    } 
    else {
        the_title();
    }

}

// Banner Title
function kidzo_banner_sub_title() {
    $opt = get_option('kidzo_opt');
    if( is_404() ){
	    $title_404 = !empty($opt['error_heading']) ? $opt['error_heading'] : esc_html__('404', 'kidzo');
        echo esc_html( $title_404 );
    }
    elseif (is_home()) {
        $blog_title = !empty($opt['blog_title']) ? $opt['blog_title'] : esc_html__('Blog', 'kidzo');
        echo esc_html($blog_title);
    } 
    elseif (is_singular('post')) {
        $blog_single_title = !empty($opt['blog_single_title']) ? $opt['blog_single_title'] : esc_html__('Blog Details', 'kidzo');
        echo esc_html($blog_single_title);
    } 
    elseif (is_singular('events')) {
        $event_sub_title = !empty($opt['event_single_sub_title']) ? $opt['event_single_sub_title'] : esc_html__('Event Details', 'kidzo');
        echo esc_html($event_sub_title);
    }
    elseif (is_singular('program')) { 
        $program_sub_title = !empty($opt['program_single_sub_title']) ? $opt['program_single_sub_title'] : esc_html__('Program Details', 'kidzo');
        echo esc_html($program_sub_title);
    }
    elseif (is_singular('teachers')) {
        $teacher_sub_title = !empty($opt['teacher_single_sub_title']) ? $opt['teacher_single_sub_title'] : esc_html__('Teacher Details', 'kidzo');
        echo esc_html($teacher_sub_title);
    }
    elseif (class_exists( 'WooCommerce') && is_shop()) {
        echo !empty( $opt['shop_title'] ) ? esc_html( $opt['shop_title'] ) : esc_html__( 'Shop Page', 'kidzo' );
    }
    
    elseif (is_page() || is_single()) {

        $breadcrumb_text = !empty($opt['breadcrumb_text']) ? $opt['breadcrumb_text'] : '';
        if(!empty($breadcrumb_text)){
            echo esc_html($breadcrumb_text); 
        }else{
        the_title();
        }

    } elseif (is_category()) {
        single_cat_title();
    } elseif (is_archive()) {
        the_archive_title();
    } elseif (is_search()) {
        esc_html_e('Search result for: &quot;', 'kidzo');
        echo get_search_query() . '&quot';
    } else {
        the_title();
    }

}


function kidzo_banner_subtitle() {
    $opt = get_option('kidzo_opt');

    if (is_home()) {
        $blog_subtitle = !empty($opt['blog_subtitle']) ? $opt['blog_subtitle'] : get_bloginfo('description');
        echo esc_html($blog_subtitle);
    }
    elseif (is_page() || is_single()) {
        if (has_excerpt()) {
            while (have_posts()) {
                the_post();
                echo nl2br(get_the_excerpt(get_the_ID()));
            }
        }
    }

}



/**
 * Get a specific html tag from content
 * @return a specific HTML tag from the loaded content
 */
function kidzo_get_html_tag( $tag = 'blockquote', $content = '' ) {
    $dom = new DOMDocument();
    $dom->loadHTML($content);
    $divs = $dom->getElementsByTagName( $tag );
    $i = 0;
    foreach ( $divs as $div ) {
        if ( $i == 1 ) {
            break;
        }
        echo '<p class="mb-0"><a href="'.get_the_permalink().'">'.$div->nodeValue.'</a></p>';
        ++$i;
    }
}

function get_author_role()
{
    global $authordata;
    $author_roles = $authordata->roles;
    $author_role = array_shift($author_roles);
    return $author_role;
}

/*===========================================
    Post Tags
=============================================*/
function kidzo_post_tags(){

	$tags = get_the_tags();
	$getTags = '';

	if( $tags ){
        $getTags .= '<div class="post_tag align-items-center"><span>'. esc_html__( 'Tags: ', 'kidzo' ) .'</span>';
		foreach( $tags as $tag ){
			$getTags .= '<a href="'.esc_url( get_tag_link( $tag->term_id ) ).'" class="cu_btn tag_btn">'.esc_html( $tag->name ).'</a>';
		}
        $getTags .= '</div>';
	}
	return $getTags;
}


/*=================================================
*   Add span into category list
===================================================*/
add_filter('wp_list_categories', 'cat_count_span');
function cat_count_span($links) {
	$links = str_replace('</a> (', '<span> (', $links);
	$links = str_replace(')', ')</span></a>', $links);
	return $links;
}

/*==================================================
     Add span to Archive 
====================================================*/
function archive_count_span($links) {
    $links = str_replace('</a>&nbsp;(', '<span class="archiveCount"> (', $links);
    $links = str_replace(')', ')</span></a>', $links);
    return $links;
}

add_filter('get_archives_link', 'archive_count_span');


/**
 * Make slug text
 */
function kidzo_get_slug( $string ) {
    $string_output = strtolower($string);
    $string_output = trim($string_output);
    $string_output = str_replace( ' ', '', $string_output );
    $string_output = str_replace( '?', '', $string_output );
    return $string_output;
}


// Post title array
function kidzo_get_postTitleArray($postType = 'post') {
    $post_type_query  = new WP_Query(
        array (
            'post_type'      => $postType,
            'posts_per_page' => -1
        )
    );
    // we need the array of posts
    $posts_array      = $post_type_query->posts;
    // the key equals the ID, the value is the post_title
    if( is_array($posts_array) ) {
        $post_title_array = wp_list_pluck($posts_array, 'post_title', 'ID');
    } else {
        $post_title_array['default'] = esc_html__( 'Default', 'kidzo' );
    }

    return $post_title_array;
}

function wc_refresh_mini_cart_count($fragments){
    ob_start();
    $items_count = WC()->cart->get_cart_contents_count();
    ?>
    <span id="mini-cart-count"><?php echo esc_html($items_count) ? $items_count : '&nbsp;'; ?></span>
    <?php
        $fragments['#mini-cart-count'] = ob_get_clean();
    return $fragments;
}



if(!function_exists('kidzo_extention_wp_kses')) {
 
    function kidzo_extention_wp_kses ( $data ) {
 
        $allow_html = array(
            'a' => array(
                'href' => array(),
                'title' => array()
            ),
            'p' => array(
                'cite' => array(),
                'title' => array(),
            ),
            'br' => array(),
            'em' => array(),
            'strong' => array(),
            'h1' => array(),
            'h2' => array(),
            'h3' => array(),
            'h4' => array(),
            'h5' => array(),
            'h6' => array(),
            'i' => array(),
            'strong' => array(),
            'code' => array(),
            'li' => array(
                'class' => array(),
            ),
            'ol' => array(
                'class' => array(),
            ),
            'ul' => array(
                'class' => array(),
            ),
            'img' => array(
                'alt'    => array(),
                'class'  => array(),
                'height' => array(),
                'src'    => array(),
                'width'  => array(),
            ),
            'span'   => array()
        );
 
      return  wp_kses($data, $allow_html);
    }
}


// Ajax mini cart update
add_filter( 'woocommerce_add_to_cart_fragments', 'header_add_to_cart_fragment', 30, 1 );
function header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start(); ?>
    <div class="cart-btn nav-link"><i class="ti-bag"></i><span class="num"><?php echo esc_html($woocommerce->cart->cart_contents_count); ?></span></div>
	<?php
	$fragments['div.cart-btn.nav-link'] = ob_get_clean();

	return $fragments;
}


add_filter( 'woocommerce_add_to_cart_fragments', function($fragments) {
	ob_start(); ?>
    <div class="minicart_panel_wrap nav-item shpping-cart">
		<?php woocommerce_mini_cart(); ?>
    </div>
	<?php $fragments['div.minicart_panel_wrap'] = ob_get_clean();

	return $fragments;

} );





add_filter('wpcf7_autop_or_not', '__return_false'); 
