<?php
/**
 * Register Google fonts.
 *
 * @return string Google fonts URL for the theme.
 */
function kidzo_fonts_url() {
    $fonts_url = '';
    $fonts     = array();
    $subsets   = '';

    /* Body font */
    if ( 'off' !== 'on' ) {
        $fonts[] = "Nunito:200,300,400,500,600,700,800,900";
    }

    $is_ssl = is_ssl() ? 'https' : 'http';

    if ( $fonts ) {
        $fonts_url = add_query_arg( array(
            'family' => urlencode( implode( '|', $fonts ) ),
            'subset' => urlencode( $subsets ),
        ), "$is_ssl://fonts.googleapis.com/css" );
    }

    return $fonts_url;
}

function kidzo_enque_scripts() {
    wp_deregister_style( 'elementor-animations' );
    wp_enqueue_style('kidzofonts', kidzo_fonts_url(), array(), null);
    wp_enqueue_style('animate',  KIDZO_DIR_CSS.'/animate.css');
    wp_enqueue_style('bootstrap',  KIDZO_DIR_CSS.'/bootstrap.min.css');
    wp_enqueue_style('flaticon',  KIDZO_DIR_CSS.'/flaticon.css');
    wp_enqueue_style('kidzomainstyle',  KIDZO_DIR_CSS.'/style.css', array(), KIDZO_VERSION);
    wp_enqueue_style('wpdstyle',  KIDZO_DIR_CSS.'/wpd-style.css', array(), KIDZO_VERSION);
    wp_enqueue_style('kidzogutenberg',  KIDZO_DIR_CSS.'/kidzo-gutenberg.css', array(), KIDZO_VERSION);
    wp_enqueue_style('kidzoshop',  KIDZO_DIR_CSS.'/kidzo-shop.css', array(), KIDZO_VERSION);
    if ( is_rtl() ) {
         wp_enqueue_style('style-rtl',  KIDZO_DIR_CSS.'/style-rtl.css', array(), KIDZO_VERSION);
    }
    // js Style
    wp_enqueue_script( 'bootstrapmin', KIDZO_DIR_JS.'/bootstrap.min.js', array('jquery'), '4.4.1', true );
    

    // Vandor Style
    wp_enqueue_style('themefyicon',  KIDZO_DIR_VEND.'/themefy_icon/themify-icons.css');
    wp_enqueue_style('owlcarousel',  KIDZO_DIR_VEND.'/owl_carousel/css/owl.carousel.css');
    wp_enqueue_style('niceselectstyle',  KIDZO_DIR_VEND.'/niceselect/css/nice-select.css');
    wp_enqueue_style('magnific_popup',  KIDZO_DIR_VEND.'/magnify_popup/magnific-popup.css');
    wp_enqueue_style('fontawesome',  KIDZO_DIR_VEND.'/fontawesome/css/all.css');
    wp_enqueue_style('woocommerce-kidzo',  KIDZO_DIR_CSS.'/woocommerce.css');
    wp_enqueue_style('elegenticon',  KIDZO_DIR_VEND.'/elegant_Icon/elegent_icon.css');
    wp_enqueue_style( 'kidzo_root_style', get_stylesheet_uri(),  array(), KIDZO_VERSION );


    wp_enqueue_script( 'popper', KIDZO_DIR_JS.'/popper.min.js', array('jquery'), '1.1.0', true );
    // Vandor js Style 
    wp_enqueue_script( 'wow', KIDZO_DIR_VEND.'/wow/wow.min.js', array('jquery'), '1.1.3', true );
    wp_enqueue_script( 'progressbar', KIDZO_DIR_VEND.'/progressbar/jquery.barfiller.js', array('jquery'), '1.0.1', true );
    wp_enqueue_script( 'parallax', KIDZO_DIR_VEND.'/parallax/parallax.js', array('jquery'), '1.0.0', true );
    wp_enqueue_script( 'parallaxscroll', KIDZO_DIR_VEND.'/parallax/jquery.parallax-scroll.js', array('jquery'), '1.0.0', true );
    wp_enqueue_script( 'owlcarousel', KIDZO_DIR_VEND.'/owl_carousel/js/owl.carousel.min.js', array('jquery'), '2.3.4', true );
    wp_enqueue_script( 'niceselect', KIDZO_DIR_VEND.'/niceselect/js/jquery.nice-select.min.js', array('jquery'), '1.0.0', true );
    wp_enqueue_script( 'magnifypopup', KIDZO_DIR_VEND.'/magnify_popup/jquery.magnific-popup.js', array('jquery'), '1.1.0', true );
    wp_enqueue_script( 'isotopepkgd', KIDZO_DIR_VEND.'/isotop/isotope.pkgd.js', array('jquery'), '3.0.6', true );
    wp_enqueue_script( 'gmap3', KIDZO_DIR_VEND.'/gmp3/gmap3.min.js', array('jquery'), '7.2', true );
    wp_enqueue_script( 'map', KIDZO_DIR_VEND.'/gmp3/map.js', array('jquery'), '3.0.6', true );
    wp_enqueue_script( 'jquerycounterup', KIDZO_DIR_VEND.'/counter/jquery.counterup.min.js', array('jquery'), '1.0.0', true );
    wp_enqueue_script( 'jquerycountTo', KIDZO_DIR_VEND.'/counter/jquery.countTo.js', array('jquery'), '1.0.0', true );
    wp_enqueue_script( 'jquerywaypoints', KIDZO_DIR_VEND.'/counter/jquery.waypoints.min.js', array('jquery'), '4.0.0', true );
   
    wp_enqueue_script( 'kidzo_custom', KIDZO_DIR_JS.'/custom.js', array('jquery'), '1.0.4', true ); 
    
    
  // Custome Header Option
  $dynamic_css_style = '';
    if(get_option('kidzo_opt')) {
        $opt = get_option('kidzo_opt');
        $header_background_bg  = isset( $opt['header_background_bg']['url'] ) ? $opt['header_background_bg']['url'] : '';
        $menu_backgorund_shpa  = isset( $opt['menu_backgorund_shpa'] ) ? $opt['menu_backgorund_shpa'] : '';
        $button_animation_around  = isset( $opt['button_animation_around'] ) ? $opt['button_animation_around'] : '';

        if ( $header_background_bg ) {
            $dynamic_css_style .= "
            .breadcrumb_part{
                background-image:url( $header_background_bg ) !important;
            }";
            
        }
        if ( $menu_backgorund_shpa == '0' ) {
            $dynamic_css_style .= "
            .header_part.header .navbar .nav-item>a.dropdown-item:before{
                display:none;
            }";
        }
        if ( $button_animation_around == '0' ) {
            $dynamic_css_style .= "
            .pc-button.elementor-button svg.inner-dashed-border{
                animation: none;
            }";
        }
    }

   wp_add_inline_style('kidzo_root_style', $dynamic_css_style);

   // Header bg End

}

add_action( 'wp_enqueue_scripts', 'kidzo_enque_scripts' );