<?php
// add category nick names in body and post class
function oppi_post_class( $classes ) {
    global $post;
    if( !has_post_thumbnail() ) {
        $classes[] = 'no-post-thumbnail';
    }
    return $classes;
}
add_filter( 'post_class', 'oppi_post_class' );


// Body classes
add_filter( 'body_class', function($classes) {
    $opt = get_option('oppi_opt');
    $shop_view_style = !empty($_GET['view']) ? $_GET['view'] : '';
    $is_header_top = !empty( $opt['is_header_top'] ) ? $opt['is_header_top'] : '';
    $error_img_select = !empty( $opt['error_img_select'] ) ? $opt['error_img_select'] : '1';
    if( !has_nav_menu('main_menu') ) {
        $classes[] = 'no_main_menu';
    }
    if( $shop_view_style == 'grid' ) {
        $classes[] = 'shop_grid';
    }
    if( $shop_view_style == 'list' ) {
        $classes[] = 'shop_list';
    }
    if( $is_header_top == '1' ) {
        $classes[] = 'header_top_shown';
    }
    if( !is_user_logged_in() ) {
        $classes[] = 'not_logged_in';
    }
    if( $error_img_select == '2' ) {
        $classes[] = 'error_page2';
    }

    return $classes;
});


// Show post excerpt by default
function oppi_show_post_excerpt( $user_login, $user ) {
    $unchecked = get_user_meta( $user->ID, 'metaboxhidden_post', true );
    $key = is_array($unchecked) ? array_search( 'postexcerpt', $unchecked ) : FALSE;
    if ( FALSE !== $key ) {
        array_splice( $unchecked, $key, 1 );
        update_user_meta( $user->ID, 'metaboxhidden_post', $unchecked );
    }
}
add_action( 'wp_login', 'oppi_show_post_excerpt', 10, 2 );


// filter to replace class on reply link
add_filter('comment_reply_link', function($class){
    $class = str_replace("class='comment-reply-link", "class='comment_reply", $class);
    return $class;
});


/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function oppi_pingback_header() {
    if ( is_singular() && pings_open() ) {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
add_action( 'wp_head', 'oppi_pingback_header' );


// Move the comment field to bottom
add_filter( 'comment_form_fields', function ( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
});


// Remove WordPress admin bar default CSS
add_action('get_header', function() {
    remove_action('wp_head', '_admin_bar_bump_cb');
});


// Elementor post type support
function oppi_add_cpt_support() {

    //if exists, assign to $cpt_support var
    $cpt_support = get_option( 'elementor_cpt_support' );

    //check if option DOESN'T exist in db
    if( ! $cpt_support ) {
        $cpt_support = [ 'page', 'post', 'header', 'footer' ]; //create array of our default supported post types
        update_option( 'elementor_cpt_support', $cpt_support ); //write it to the database
    }

    //if it DOES exist, but header is NOT defined
    elseif( ! in_array( 'header', $cpt_support ) ) {
        $cpt_support[] = 'header'; //append to array
        update_option( 'elementor_cpt_support', $cpt_support ); //update database
    }
    //if it DOES exist, but footer is NOT defined
    elseif( ! in_array( 'footer', $cpt_support ) ) {
        $cpt_support[] = 'footer'; //append to array
        update_option( 'elementor_cpt_support', $cpt_support ); //update database
    }

    //otherwise do nothing, portfolio already exists in elementor_cpt_support option
}
add_action( 'after_switch_theme', 'oppi_add_cpt_support' );



add_action('woocommerce_before_main_content', 'kidzo_woocommerce_before_main_content');

function kidzo_woocommerce_before_main_content() {
    $opt = get_option( 'kidzo_opt' );
    $shop_sidebar = !empty($opt['shop_sidebar']) ? $opt['shop_sidebar'] : '';
    $shop_grid_class =  ($shop_sidebar == 'right') ? 'row flex-row-reverse' : 'row'; 
    
    $sibebar_office_class = "col-sm-6";

    if($shop_sidebar == 'left') {
        $sibebar_office_class = "col-sm-4 offset-lg-2";
    }

    if($shop_sidebar == 'right') {
        $sibebar_office_class = "col-sm-4";
    }

    if(!is_single( )) { ?>
        <div class="row">
            <div class="<?php echo esc_attr(  $sibebar_office_class ); ?>">
                <div class="shop_menu_left d-flex align-items-center">
                    <?php woocommerce_result_count(); ?>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="shop_menu_right d-flex align-items-center justify-content-end">
                    <?php woocommerce_catalog_ordering(); ?>
                </div>
            </div>
        </div>
        <div class="woocomerce-notic">
            <?php woocommerce_output_all_notices(); ?>
        </div>
        <?php
        if( $shop_sidebar != 'full' && '' !=  $shop_sidebar) {  ?>
            <div class="<?php echo esc_attr( $shop_grid_class ); ?>">
            <?php get_sidebar('shop_sidebar');
        }
    }
}