<?php

Redux::setSection('kidzo_opt', array(
	'title'     => esc_html__('Blog settings', 'kidzo'),
	'id'        => 'blog_page',
	'icon'      => 'dashicons dashicons-admin-post',
));


Redux::setSection('kidzo_opt', array(
	'title'     => esc_html__('Title-bar', 'kidzo'),
	'id'        => 'blog_titlebar_settings',
	'icon'      => 'dashicons dashicons-admin-post',
    'subsection' => true,
	'fields'    => array(
        array(
            'title'     => esc_html__('Background', 'kidzo'),
            'id'        => 'blog_banner_bg_color',
            'type'      => 'background',
            'output'    => array( '.blog .kidzo_banner' )
        ),
        array(
            'title'     => esc_html__('Overlay Color', 'kidzo'),
            'id'        => 'blog_banner_overlay_color',
            'type'      => 'color_rgba',
            'output'    => array( 'background-color' => '.blog .kidzo_inner_banner .overlay' )
        ),

		array(
			'title'     => esc_html__('Blog page title', 'kidzo'),
			'subtitle'  => esc_html__('Give here the blog page title', 'kidzo'),
			'desc'      => esc_html__('This text will be show on blog page banner', 'kidzo'),
			'id'        => 'blog_title',
			'type'      => 'text',
			'default'   => esc_html__('Blog List', 'kidzo')
		),
	)
));

Redux::setSection('kidzo_opt', array(
	'title'     => esc_html__('Blog archive', 'kidzo'),
	'id'        => 'blog_meta_opt',
	'icon'      => 'dashicons dashicons-info',
	'subsection' => true,
	'fields'    => array(
        array(
            'title'     => esc_html__('Blog excerpt', 'kidzo'),
            'subtitle'  => esc_html__('How much words you want to show in blog page.', 'kidzo'),
            'id'        => 'blog_excerpt',
            'type'      => 'slider',
            'default'   => 40,
            "min"       => 15,
            "step"      => 1,
            "max"       => 100,
            'display_value' => 'label'
        ),
		array(
			'title'     => esc_html__('Post meta', 'kidzo'),
			'subtitle'  => esc_html__('Show/hide post meta on blog archive page', 'kidzo'),
			'id'        => 'is_post_meta',
			'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1',
		),
		array(
			'title'     => esc_html__('Post date', 'kidzo'),
			'id'        => 'is_post_date',
			'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1',
            'required' => array( 'is_post_meta', '=', 1 )
		),
		array(
			'title'     => esc_html__('Post tags', 'kidzo'),
			'id'        => 'is_post_tag',
			'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1',
            'required' => array( 'is_post_meta', '=', 1 )
		),
		array(
			'title'     => esc_html__('Post comment', 'kidzo'),
			'id'        => 'is_post_comment',
			'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1',
            'required' => array( 'is_post_meta', '=', 1 )
		),
		array(
            'id'       => 'is_blog_animation_show',
            'type'     => 'switch',
            'title'    => esc_html__('Animation Images', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => false,
        ),
        array(
            'title'     => esc_html__('Animation Images', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Blog Page Animation Images ', 'kidzo'),
            'id'        => 'blog_animation_images',
            'type'      => 'gallery',
            'required' => array( 'is_blog_animation_show', '=', 1 )
        ),

	)
));


Redux::setSection('kidzo_opt', array(
	'title'     => esc_html__('Blog single', 'kidzo'),
	'id'        => 'blog_single_opt',
	'icon'      => 'dashicons dashicons-info',
	'subsection' => true,
	'fields'    => array(
        array(
			'title'     => esc_html__('Blog Single title', 'kidzo'),
			'subtitle'  => esc_html__('Give here the blog Single page title', 'kidzo'),
			'desc'      => esc_html__('This text will be show on blog Single banner', 'kidzo'),
			'id'        => 'blog_single_title',
			'type'      => 'text',
			'default'   => esc_html__('Blog Details', 'kidzo')
		),
		array(
			'title'     => esc_html__('Social share', 'kidzo'),
			'id'        => 'is_social_share',
			'type'      => 'switch',
            'on'        => esc_html__('Enabled', 'kidzo'),
            'off'       => esc_html__('Disabled', 'kidzo'),
            'default'   => '1'
		),
		array(
			'title'     => esc_html__('Post tag', 'kidzo'),
			'id'        => 'is_post_tag',
			'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1'
		),
		array(
			'title'     => esc_html__('Author Information', 'kidzo'),
			'id'        => 'is_author_info',
			'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1'
		),

		array(
			'title'     => esc_html__('Related Post', 'kidzo'),
			'id'        => 'is_related',
			'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1'
		),
		array(
			'title'     => esc_html__('Related Post title', 'kidzo'),
			'subtitle'  => esc_html__('Give here the blog Single page title', 'kidzo'),
			'desc'      => esc_html__('This text will be show on Related Post Title', 'kidzo'),
			'id'        => 'related_posts_title',
			'type'      => 'text',
			'default'   => esc_html__('Related Post', 'kidzo')
		),

		array(
			'title'     => esc_html__('Related Post Number', 'kidzo'),
			'subtitle'  => esc_html__('How Manu Post Show in Related Post', 'kidzo'),
			'desc'      => esc_html__('This text will be show on Related Post Number', 'kidzo'),
			'id'        => 'related_posts_count',
			'type'      => 'text',
			'default'   => esc_html__('3', 'kidzo')
		),
	)
));
