<?php
/**
 * Custom Post Types
 */
Redux::setSection( 'kidzo_opt', array(
    'title'     => esc_html__( 'Custom Post Types', 'kidzo' ),
    'id'        => 'cpt_opt',
    'icon'      => 'dashicons dashicons-admin-post',
));

/**
 * Post Types
 */
Redux::setSection( 'kidzo_opt', array(
    'title'     => esc_html__( 'Post Types', 'kidzo' ),
    'id'        => 'cpt',
    'icon'      => 'el el-lines',
    'subsection'=> true,
    'fields'    => array(
        array(
            'id'        => 'cpt_note',
            'type'      => 'info',
            'style'     => 'success',
            'title'     => esc_html__( 'Enable Disable Custom Post Types', 'kidzo' ),
            'icon'      => 'dashicons dashicons-info',
            'desc'      => esc_html__( 'If you want, you can disable any custom post type of kidzo from here.', 'kidzo' )
        ),
        array(
            'id'       => 'is_teachers_cpt',
            'type'     => 'switch',
            'title'    => esc_html__('Teachers Post Type', 'kidzo' ),
            'on'       => esc_html__( 'Enable', 'kidzo' ),
            'off'      => esc_html__( 'Disable', 'kidzo' ),
            'default'  => true,
        ),
        array(
            'id'       => 'is_footer_cpt',
            'type'     => 'switch',
            'title'    => esc_html__( 'Footer Post Type', 'kidzo' ),
            'on'       => esc_html__( 'Enable', 'kidzo' ),
            'off'      => esc_html__( 'Disable', 'kidzo' ),
            'default'  => true,
        ),
    )
));

/**
 * Slug Re-write
 */
Redux::setSection( 'kidzo_opt', array(
    'title'     => esc_html__( 'Post Type Slugs', 'kidzo' ),
    'id'        => 'kidzo_cp_slugs',
    'icon'      => 'el el-lines',
    'subsection'=> true,
    'fields'    => array(
        array(
            'id'        => 'cp_slug_note',
            'type'      => 'info',
            'style'     => 'warning',
            'title'     => esc_html__( 'Slug Re-write:', 'kidzo' ),
            'icon'      => 'dashicons dashicons-info',
            'desc'      => sprintf (
                '%1$s <a href="%2$s"> %3$s</a> %4$s',
                esc_html__( "These are the custom post's slugs offered by kidzo. You can customize the permalink structure (site_domain/post_type_slug/post_lug) by changing the slug from here. Don't forget to save the permalinks settings from", 'kidzo' ),
                get_admin_url( null, 'options-permalink.php' ),
                esc_html__( 'Settings > Permalinks', 'kidzo' ),
                esc_html__( 'after changing the slug value.', 'kidzo' )
            )
        ),
        array(
            'title'     => esc_html__( 'Teachers Slug', 'kidzo' ),
            'id'        => 'teachers_slug',
            'type'      => 'text',
            'default'   => 'teachers'
        ),

    )
));

/**
 * Post Types
 */
Redux::setSection( 'kidzo_opt', array(
    'title'     => esc_html__( 'Event Single', 'kidzo' ),
    'id'        => 'event_single',
    'icon'      => 'el el-lines',
    'subsection'=> true,
    'fields'    => array(
        array(
            'title'     => esc_html__( 'Page Title', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Event Single Page Title Option', 'kidzo'),
            'id'        => 'event_single_title',
            'type'      => 'text',
            'default'   => 'Event Details'
        ),
        array(
            'title'     => esc_html__( 'Page Sub Title', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Event Single Page Sub Title Option', 'kidzo'),
            'id'        => 'event_single_sub_title',
            'type'      => 'text',
            'default'   => 'Event Details'
        ),
        array(
            'id'       => 'is_animation_show',
            'type'     => 'switch',
            'title'    => esc_html__('Animation Images', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => false,
        ),
        array(
            'title'     => esc_html__('Animation Images', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Events Animation Images ', 'kidzo'),
            'id'        => 'animation_images',
            'type'      => 'gallery',
            'required' => array( 'is_animation_show', '=', 1 )
        ),

        array(
            'title'     => esc_html__('Event Date & Time', 'kidzo'),
            'subtitle'  => esc_html__('The Images for Event Single Page Date & Time Option', 'kidzo'),
            'id'        => 'event_date_time',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/event_date_time.png'
            )
        ),

        array(
            'title'     => esc_html__('Event Location', 'kidzo'),
            'subtitle'  => esc_html__('The Images for Event Single Page Event Location Option', 'kidzo'),
            'id'        => 'event_location',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/event_location.png'
            )
        ),

        array(
            'title'     => esc_html__('Event Contact Info', 'kidzo'),
            'subtitle'  => esc_html__('The Images for Event Single Page Event Contact Option', 'kidzo'),
            'id'        => 'event_contact',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/event_contact.png'
            )
        ),

        array(
            'id'       => 'is_enrollment_program_item_show',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enrollment Program', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => true,
        ),
        array(
            'title'     => esc_html__('Enrollment Title', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Title ', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'enrollment_title_program',
            'type'      => 'text',
            'default'   => esc_html__('Enrollment Is Going On', 'kidzo'),
            'required' => array( 'is_enrollment_program_item_show', '=', 1 )
        ),

        array(
            'title'     => esc_html__('Enrollment Sub Title', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Sub Title ', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'enrollment_subtitle_program',
            'type'      => 'text',
            'default'   => esc_html__('Gain access to over 1000 Premiun resourses', 'kidzo'),
            'required' => array( 'is_enrollment_program_item_show', '=', 1 )
        ),

        array(
            'title'     => esc_html__('Enrollment Button Text', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Button Text', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'enrollment_button_text',
            'type'      => 'text',
            'default'   => esc_html__('Book Now', 'kidzo'),
            'required' => array( 'is_enrollment_program_item_show', '=', 1 )
        ),
        array(
            'title'     => esc_html__('Enrollment Button URL', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Button URL', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'enrollment_button_url',
            'type'      => 'text',
            'default'   => '#',
            'required' => array( 'is_enrollment_program_item_show', '=', 1 )
        ),

        array(
            'title'     => esc_html__('Enrollment Left Side Images', 'kidzo'),
            'subtitle'  => esc_html__( 'Upload here a image file for your Enrollment Left Side', 'kidzo' ),
            'id'        => 'enrollment_left_side_imges',
            'type'      => 'media',
            'compiler'  => true,
        ),
        array(
            'title'     => esc_html__('Enrollment Right Side Images', 'kidzo'),
            'subtitle'  => esc_html__( 'Upload here a image file for your Enrollment Right Side', 'kidzo' ),
            'id'        => 'enrollment_right_side_imges',
            'type'      => 'media',
            'compiler'  => true,
        ),
        array(
            'id'       => 'is_related_item_show',
            'type'     => 'switch',
            'title'    => esc_html__( 'Related Event', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => true,
        ),
        array(
            'title'     => esc_html__('Related Event Title', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Related Events Title ', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'related_title',
            'type'      => 'text',
            'default'   => esc_html__('Related Events', 'kidzo'),
            'required' => array( 'is_related_item_show', '=', 1 )
        ),
        array(
            'id'       => 'is_related_item_img_show',
            'type'     => 'switch',
            'title'    => esc_html__( 'Related Event Animation Images', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => false,
            'required' => array( 'is_related_item_show', '=', 1 )
        ),
        array(
            'title'     => esc_html__('Related Animation Images', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Related Events Animation Images ', 'kidzo'),
            'id'        => 'related_animation_images',
            'type'      => 'gallery',
            'required' => array( 'is_related_item_img_show', '=', 1 )
        ),
    )
));


/**
 * Post Types
 */
Redux::setSection( 'kidzo_opt', array(
    'title'     => esc_html__( 'Teacher Single', 'kidzo' ),
    'id'        => 'teacher_single',
    'icon'      => 'el el-lines',
    'subsection'=> true,
    'fields'    => array(
        array(
            'title'     => esc_html__( 'Page Title', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Teacher Single Page Title Option', 'kidzo'),
            'id'        => 'teacher_single_title',
            'type'      => 'text',
            'default'   => 'Teacher Details'
        ),
        array(
            'title'     => esc_html__( 'Page Sub Title', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Teacher Single Page Sub Title Option', 'kidzo'),
            'id'        => 'teacher_single_sub_title',
            'type'      => 'text',
            'default'   => 'Teacher Details'
        ),
        array(
            'title'     => esc_html__('Images Background Shape', 'kidzo'),
            'subtitle'  => esc_html__('Images Background Shape', 'kidzo'),
            'id'        => 'teacher_single_shape',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/teacher_profile_shape.png'
            )
        ),
   
    )
));


/**
 * Post Types
 */
Redux::setSection( 'kidzo_opt', array(
    'title'     => esc_html__( 'Program Single', 'kidzo' ),
    'id'        => 'program_single',
    'icon'      => 'el el-lines',
    'subsection'=> true,
    'fields'    => array(
        array(
            'title'     => esc_html__( 'Page Title', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Program Single Page Title Option', 'kidzo'),
            'id'        => 'program_single_title',
            'type'      => 'text',
            'default'   => 'Programs Details'
        ),
        array(
            'title'     => esc_html__( 'Page Sub Title', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Program Single Page Sub Title Option', 'kidzo'),
            'id'        => 'program_single_sub_title',
            'type'      => 'text',
            'default'   => 'Programs Details'
        ),
        array(
            'title'     => esc_html__('Images Background Shape', 'kidzo'),
            'subtitle'  => esc_html__('Feature Images Background Shape', 'kidzo'),
            'id'        => 'program_single_shape',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/program_imags_shape.png'
            )
        ),

        array(
            'id'       => 'is_animation_show_program',
            'type'     => 'switch',
            'title'    => esc_html__('Animation Images', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => false,
        ),
        array(
            'title'     => esc_html__('Animation Images', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Events Animation Images ', 'kidzo'),
            'id'        => 'animation_images_program',
            'type'      => 'gallery',
            'required' => array( 'is_animation_show_program', '=', 1 )
        ),

        array(
            'title'     => esc_html__( 'Age Level', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Program Single Page Kidz Age Level', 'kidzo'),
            'id'        => 'program_age_level',
            'type'      => 'text',
            'default'   => 'Age'
        ),

        array(
            'title'     => esc_html__('Kids Age Images', 'kidzo'),
            'subtitle'  => esc_html__('The Images for Kids Program Single Page Age Option', 'kidzo'),
            'id'        => 'program_age',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/program_age.png'
            )
        ),

        array(
            'title'     => esc_html__( 'Tution Free Level', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Program Single Page Kidz Tution Free Level', 'kidzo'),
            'id'        => 'program_tution_free_level',
            'type'      => 'text',
            'default'   => 'Tution Free'
        ),

        array(
            'title'     => esc_html__('Tution Free Images', 'kidzo'),
            'subtitle'  => esc_html__('The Images for Program Single Page Tution Free', 'kidzo'),
            'id'        => 'program_tution_free',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/program_tution_free.png'
            )
        ),

        array(
            'title'     => esc_html__( 'Class Time Level', 'kidzo' ),
            'subtitle'  => esc_html__('The Title for Program Single Page Kidz Class Time Level', 'kidzo'),
            'id'        => 'program_class_title_level',
            'type'      => 'text',
            'default'   => 'Class Time'
        ),

        array(
            'title'     => esc_html__('Class Time Images', 'kidzo'),
            'subtitle'  => esc_html__('The images upload for Program Single Page Class Time', 'kidzo'),
            'id'        => 'program_class_time',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/program_class_time.png'
            )
        ),

        array(
            'id'       => 'is_program_item_show',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enrollment Program', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => true,
        ),
        array(
            'title'     => esc_html__('Enrollment Title', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Title ', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'program_enrollment_title_program',
            'type'      => 'text',
            'default'   => esc_html__('Enrollment Is Going On', 'kidzo'),
            'required' => array( 'is_program_item_show', '=', 1 )
        ),

        array(
            'title'     => esc_html__('Enrollment Sub Title', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Sub Title ', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'program_enrollment_subtitle',
            'type'      => 'text',
            'default'   => esc_html__('Gain access to over 1000 Premiun resourses', 'kidzo'),
            'required' => array( 'is_program_item_show', '=', 1 )
        ),

        array(
            'title'     => esc_html__('Enrollment Button Text', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Button Text', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'program_enrollment_button_text',
            'type'      => 'text',
            'default'   => esc_html__('Book Now', 'kidzo'),
            'required' => array( 'is_program_item_show', '=', 1 )
        ),
        array(
            'title'     => esc_html__('Enrollment Button URL', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Enrollment Button URL', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'program_enrollment_button_url',
            'type'      => 'text',
            'default'   => '#',
            'required' => array( 'is_program_item_show', '=', 1 )
        ),

        array(
            'title'     => esc_html__('Enrollment Left Side Images', 'kidzo'),
            'subtitle'  => esc_html__( 'Upload here a image file for your Enrollment Left Side', 'kidzo' ),
            'id'        => 'program_enrollment_left_side_imges',
            'type'      => 'media',
            'compiler'  => true,
            'required' => array( 'is_program_item_show', '=', 1 )
        ),
        array(
            'title'     => esc_html__('Enrollment Right Side Images', 'kidzo'),
            'subtitle'  => esc_html__( 'Upload here a image file for your Enrollment Right Side', 'kidzo' ),
            'id'        => 'program_enrollment_right_side_imges',
            'type'      => 'media',
            'compiler'  => true,
            'required' => array( 'is_program_item_show', '=', 1 )
        ),
        
        array(
            'id'       => 'is_related_program_item_show',
            'type'     => 'switch',
            'title'    => esc_html__( 'Related Program', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => true,
        ),
        array(
            'title'     => esc_html__('Related Program Title', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Related Events Title ', 'kidzo'),
            'desc'      => esc_html__('This text will be show on Events Single Page', 'kidzo'),
            'id'        => 'related_title_program',
            'type'      => 'text',
            'default'   => esc_html__('Related Programs', 'kidzo'),
            'required' => array( 'is_related_program_item_show', '=', 1 )
        ),
        array(
            'id'       => 'is_program_related_item_img_show',
            'type'     => 'switch',
            'title'    => esc_html__( 'Related Program Animation Images', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => false,
            'required' => array( 'is_related_program_item_show', '=', 1 )
        ),
        array(
            'title'     => esc_html__('Related Animation Images', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Related Events Animation Images ', 'kidzo'),
            'id'        => 'related_program_animation_images',
            'type'      => 'gallery',
            'required' => array( 'is_program_related_item_img_show', '=', 1 )
        ),
    )
));