<?php
// Header Section
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Header Settings', 'kidzo' ),
    'id'               => 'header_sec',
    'customizer_width' => '400px',
    'icon'             => 'el el-arrow-up',
));
// Logo
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Logo', 'kidzo' ),
    'id'               => 'logo_opt',
    'subsection'       => true,
    'icon'             => 'el el-lines',
    'fields'           => array(
        array(
            'title'     => esc_html__('Preloder Setting', 'kidzo'),
            'id'        => 'site_preloder_active',
            'type'      => 'switch',
            'on'        => esc_html__('Active', 'kidzo'),
            'off'       => esc_html__('Inactive', 'kidzo'),
            'default'   => '1'
        ),
        array(
            'title'     => esc_html__('Upload logo', 'kidzo'),
            'subtitle'  => esc_html__( 'Upload here a image file for your logo', 'kidzo' ),
            'id'        => 'main_logo',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/logo.png'
            )
        ),
        array(
            'title'     => esc_html__('Retina Logo', 'kidzo'),
            'subtitle'  => esc_html__('The retina logo should be double (2x) of your original logo', 'kidzo'),
            'id'        => 'retina_logo',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/ratina_logo.png'
            )
        ),
        array(
            'title'     => esc_html__('Logo dimensions', 'kidzo'),
            'subtitle'  => esc_html__( 'Set a custom height width for your upload logo.', 'kidzo' ),
            'id'        => 'logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array('em','px','%'),
            'output'    => '.kidzo_header .header_nav .logo img'
        ),
        array(
            'title'     => esc_html__('Logo dimensions [Mobile]', 'kidzo'),
            'subtitle'  => esc_html__( 'Set Logo height width for Mobile .', 'kidzo' ),
            'id'        => 'logo_dimensions_mobile',
            'type'      => 'dimensions',
            'units'     => array('em','px','%'),
            'output'    => [
                '.kidzo_mobile_class .kidzo_header .header_nav .logo img'
            ]
        ),

        array(
            'title'     => esc_html__('Padding', 'kidzo'),
            'subtitle'  => esc_html__('Padding around the logo. Input the padding as clockwise (Top Right Bottom Left)', 'kidzo'),
            'id'        => 'logo_padding',
            'type'      => 'spacing',
            'output'    => array( '.navbar-header .navbar-brand' ),
            'mode'      => 'padding',
            'units'     => array( 'em', 'px', '%' ),      // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true',
        ),
    )
) );
// Header Top Bar 
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Top Bar', 'kidzo' ),
    'id'               => 'header_top_bar_opt',
    'subsection'       => true,
    'icon'             => 'el el-lines',
    'fields'           => array(
        array(
            'title'     => esc_html__('Background Color', 'kidzo'),
            'subtitle'  => esc_html__('Top bar Background Color', 'kidzo'),
            'id'        => 'background_topbar',
            'output'    => array(
                'background-color' => '.sub_header',
            ),
            'type'      => 'color',
        ),
        array(
            'title'     => esc_html__('Text Color', 'kidzo'),
            'subtitle'  => esc_html__('Top bar Text Color', 'kidzo'),
            'id'        => 'topbar_text_color',
            'output'    => array(
                'color' => '.sub_header a, .sub_header .header_social_icon p',
            ),
            'type'      => 'color',
        ),
        array(
            'title'     => esc_html__('Email Visibility', 'kidzo'),
            'id'        => 'is_email_btn',
            'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
        ),
        array(
            'title'     => esc_html__('Email ID', 'kidzo'),
            'subtitle'  => esc_html__('Leave the button label field empty to hide the Topbar Email id', 'kidzo'),
            'id'        => 'topbar_email_id',
            'type'      => 'text',
            'default'   => esc_html__('info@droitthemes.com', 'kidzo'),
            'required'  => array('is_email_btn', '=', '1')
        ),
        array(
            'title'     => esc_html__('Contact Number Visibility', 'kidzo'),
            'id'        => 'is_content_btn',
            'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
        ),
        array(
            'title'     => esc_html__('Contact Number', 'kidzo'),
            'subtitle'  => esc_html__('Leave the button label field empty to hide the Topbar Contact Number', 'kidzo'),
            'id'        => 'topbar_contact_no',
            'type'      => 'text',
            'default'   => esc_html__('+880-1827-609441', 'kidzo'),
            'required'  => array('is_content_btn', '=', '1')
        ),
        array(
            'title'     => esc_html__('Social Visibility', 'kidzo'),
            'id'        => 'is_social_top_btn',
            'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
        ),
        array(
            'title'     => esc_html__('Social Level', 'kidzo'),
            'subtitle'  => esc_html__('Leave the button label field empty to hide the Topbar Social', 'kidzo'),
            'id'        => 'topbar_social_level',
            'type'      => 'text',
            'default'   => esc_html__('Follow Us', 'kidzo'),
            'required'  => array('is_social_top_btn', '=', '1')
        ),
        array(
            'title'     => esc_html__('Header Min Cart', 'kidzo'),
            'subtitle'  => esc_html__('Min Cart Option are show/hide in Header Part', 'kidzo'),
            'id'        => 'is_mini_cart',
            'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
        ),
    )
));

// Action button
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Action Button', 'kidzo' ),
    'id'               => 'menu_action_btn_opt',
    'subsection'       => true,
    'icon'             => 'el el-lines',
    'fields'           => array(
        array(
            'title'     => esc_html__('Button Visibility', 'kidzo'),
            'id'        => 'is_menu_btn',
            'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
        ),
        array(
            'title'     => esc_html__('Button label', 'kidzo'),
            'subtitle'  => esc_html__('Leave the button label field empty to hide the menu action button.', 'kidzo'),
            'id'        => 'menu_btn_label',
            'type'      => 'text',
            'default'   => esc_html__('Try for Free', 'kidzo'),
            'required'  => array('is_menu_btn', '=', '1')
        ),
        array(
            'title'     => esc_html__('Button URL', 'kidzo'),
            'id'        => 'menu_btn_url',
            'type'      => 'text',
            'default'   => '#',
            'required'  => array('is_menu_btn', '=', '1')
        ),
        array(
            'title'     => esc_html__('Button Font Size', 'kidzo'),
            'id'        => 'menu_btn_size',
            'type'      => 'spinner',
            'default'   => '14',
            'min'       => '12',
            'step'      => '1',
            'max'       => '50',
            'required'  => array('is_menu_btn', '=', '1')
        ),
        array(
            'title'     => esc_html__('Button Colors', 'kidzo'),
            'subtitle'  => esc_html__('Button style attributes on normal (non sticky) mode.', 'kidzo'),
            'id'        => 'button_colors',
            'type'      => 'section',
            'indent'    => true,
            'required'  => array('is_menu_btn', '=', '1'),
        ),
        array(
            'title'     => esc_html__('Font color', 'kidzo'),
            'id'        => 'menu_btn_font_color',
            'type'      => 'color',
            'output'    => array('.cu_btn.white_btn:hover'),
        ),
        array(
            'title'     => esc_html__('Border Color', 'kidzo'),
            'id'        => 'menu_btn_border_color',
            'type'      => 'color',
            'mode'      => 'border-color',
            'output'    => array('.cu_btn.white_btn'),
        ),
        array(
            'title'     => esc_html__('Background Color', 'kidzo'),
            'id'        => 'menu_btn_bg_color',
            'type'      => 'color',
            'mode'      => 'background',
            'output'    => array('.cu_btn.white_btn'),
        ),
        // Button color on hover stats
        array(
            'title'     => esc_html__('Hover Font Color', 'kidzo'),
            'subtitle'  => esc_html__('Font color on hover stats.', 'kidzo'),
            'id'        => 'menu_btn_hover_font_color',
            'type'      => 'color',
            'output'    => array('.cu_btn.white_btn:hover'),
        ),
        array(
            'title'     => esc_html__('Hover background color', 'kidzo'),
            'subtitle'  => esc_html__('Background color on hover stats.', 'kidzo'),
            'id'        => 'menu_btn_hover_bg_color',
            'type'      => 'color',
            'output'    => array(
                'background' => '.cu_btn.white_btn:hover',
                'border-color' => '.cu_btn.white_btn:hover'
            ),
        ),
        array(
            'id'     => 'button_colors-end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
));

// Title-bar
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Page Header Setting', 'kidzo' ),
    'id'               => 'page_header_opt',
    'subsection'       => true,
    'icon'             => 'el el-lines',
    'fields'           => array(
        array(
            'title'     => esc_html__('Header Background Images', 'kidzo'),
            'subtitle'  => esc_html__( 'Upload here a image file for your Header Background', 'kidzo' ),
            'id'        => 'header_background_bg',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/breadcrumb_bg.png'
            )
        ),
        array(
            'id'       => 'is_header_animation_show',
            'type'     => 'switch',
            'title'    => esc_html__('Animation Images', 'kidzo' ),
            'on'       => esc_html__( 'Show', 'kidzo' ),
            'off'      => esc_html__( 'Hidden', 'kidzo' ),
            'default'  => false,
        ),
        array(
            'title'     => esc_html__('Animation Images', 'kidzo'),
            'subtitle'  => esc_html__('Give here the Header Section Animation Images ', 'kidzo'),
            'id'        => 'header_animation_images',
            'type'      => 'gallery',
            'required' => array( 'is_header_animation_show', '=', 1 )
        ),
        array(
            'title'     => esc_html__('Breadcrumb Text', 'kidzo'),
            'subtitle'  => esc_html__( 'if this text field empty, then show page title', 'kidzo' ),
            'id'        => 'breadcrumb_text',
            'type'      => 'text',
            'default'   => ''
        ),
        array(
            'title'     => esc_html__('Breadcrumb dimensions', 'kidzo'),
            'subtitle'  => esc_html__( 'Set a custom height width for Page Header Breadcrumb', 'kidzo' ),
            'id'        => 'breadcrumb_dimensions',
            'type'      => 'dimensions',
            'units'     => array('em','px','%'),
            'output'    => '.breadcrumb_part'
        ),
    )
));