<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kidzo
 */
get_header();
$opt = get_option('kidzo_opt');
$is_blog_animation = isset( $opt['is_blog_animation_show']) ? $opt['is_blog_animation_show'] : '';
$blog_animation_images = isset( $opt['blog_animation_images']) ? $opt['blog_animation_images'] : '';
$blog_column = is_active_sidebar( 'sidebar_widgets' ) ? '8' : '12';
?>
 <section class="blog_page section_padding">
    <div class="container custom_container">
        <div class="row">
            <div class="col-lg-<?php echo esc_attr($blog_column) ?>">
                <?php if ( have_posts() ) {  ?>
                    <div class="blog_post_list pr_30">
                        <?php
                        while ( have_posts() ) : the_post();
                            get_template_part( 'template-parts/content', get_post_format() );
                        endwhile;
                        wp_reset_postdata();
                        ?>
                    </div>
                    <div class="page_pageination justify-content-start">
                        <?php kidzo_pagination(); ?>
                    </div>
                    <?php
                }
                else{
                    get_template_part( 'template-parts/content', 'none' );
                }
                ?>
            </div>
            <?php get_sidebar(); ?>
        </div>
    </div>
    <?php
    if($is_blog_animation == 1){
            $blog_img = explode(",", $blog_animation_images);
            $i = 1;
            foreach($blog_img as $imageB):
                $imag_blog = wp_get_attachment_image_src($imageB);
                ?>
                <?php if($i == 1){ ?>
                    <div class="blog_animation_1">
                        <div data-parallax='{"x": 2, "y": 120, "rotateZ":0}'> <?php echo wp_get_attachment_image($imageB, 'full') ?> </div>
                    </div>
                <?php }elseif ($i == 2) { ?>
                    <div class="blog_animation_2">
                        <div data-parallax='{"x": 10, "y": 100, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 3) { ?>
                    <div class="blog_animation_3">
                        <div data-parallax='{"x": 30, "y": 110, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 4) { ?>
                    <div class="blog_animation_4">
                        <div data-parallax='{"x": 5, "y": 105, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 5) { ?>
                    <div class="blog_animation_5">
                        <div data-parallax='{"x": 8, "y": 110, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 6) { ?>
                    <div class="blog_animation_6">
                        <div data-parallax='{"x": 8, "y": 110, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 7) { ?>
                    <div class="blog_animation_7">
                        <div data-parallax='{"x": 2, "y": 120, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 8) { ?>
                    <div class="blog_animation_8">
                        <div data-parallax='{"x": 10, "y": 100, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 9) { ?>
                    <div class="blog_animation_9">
                        <div data-parallax='{"x": 30, "y": 110, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }elseif ($i == 10) { ?>
                    <div class="blog_animation_10">
                        <div data-parallax='{"x": 5, "y": 105, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
                    </div>
                <?php }?>
            <?php 
            $i++;
        endforeach; 
    }
    ?>    
</section>
<?php
get_footer();