<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kidzo
 */

get_header();
$opt = get_option('kidzo_opt');
$blog_column = is_active_sidebar( 'sidebar_widgets' ) ? '8' : '12';
$is_header_animation     = isset( $opt['is_header_animation_show']) ? $opt['is_header_animation_show'] : '';
$header_animation_images = isset( $opt['header_animation_images']) ? $opt['header_animation_images'] : '';
$header_background_bg    = isset( $opt['header_background_bg']['url']) ? $opt['header_background_bg']['url'] : '';

?>
<section class="breadcrumb_part parallax_bg">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-12">
				<div class="breadcrumb_iner">
					<h2><?php kidzo_banner_title(); ?></h2>
					<div class="breadcrumb_iner_link">
						<a href="<?php echo get_site_url(); ?>"><?php echo  esc_html__('Home', 'kidzo'); ?></a>
						<span>.</span>
						<p><?php kidzo_banner_title(); ?></p>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php 
		if($is_header_animation == 1):
			$blog_img = explode(",", $header_animation_images);
			$i = 1;
			foreach($blog_img as $imageB):
				$imag_blog = wp_get_attachment_image_src($imageB);
				?>
					<?php if($i == 1){ ?>
						<div class="breadcrumb_animation_4">
							<div data-parallax='{"x": 30, "y": 250, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
						</div>
					<?php }elseif ($i == 2) { ?>
						<div class="breadcrumb_animation_5">
							<div data-parallax='{"x": 20, "y": 150, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
						</div>
					<?php }elseif ($i == 3) { ?>
						<div class="breadcrumb_animation_7">
							<div data-parallax='{"x": 100, "y": 250, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
						</div>
					<?php }elseif ($i == 4) { ?>
						<div class="breadcrumb_animation_10">
							<div data-parallax='{"x": 15, "y": 150, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
						</div>
					<?php }elseif ($i == 5) { ?>
						<div class="breadcrumb_animation_12">
							<div data-parallax='{"x": 20, "y": 150, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
						</div>
					<?php }elseif ($i == 6) { ?>
						<div class="breadcrumb_animation_13">
							<div data-parallax='{"x": 10, "y": 250, "rotateZ":0}'><?php echo wp_get_attachment_image($imageB, 'full') ?></div>
						</div>
					<?php } ?>
				<?php 
				$i++;
			endforeach; 
		endif; 
	?>
</section>

<section class="blog_page section_padding">
    <div class="container custom_container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="blog_post_list">
					<?php 
					while ( have_posts() ) : the_post();
						?>
						<div class="sec_ptb_120 page_wrapper">
							<div class="container page_content">
							<?php
								the_content();
								wp_link_pages(array(
									'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'kidzo' ) . '</span>',
									'after'       => '</div>',
									'link_before' => '<span>',
									'link_after'  => '</span>',
									'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'kidzo' ) . ' </span>%',
									'separator'   => '<span class="screen-reader-text">, </span>',
								));
								?>
								
							</div>
							<?php
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
							?>
							
						</div>
					<?php
					endwhile; // End of the loop.
					?>
				</div>
			</div>
		</div>
	</div>      
</section>
<?php
get_footer();
