<?php
/**
 *  Template Name: Program Information
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package kidzo
 */
get_header();
$opt = get_option('kidzo_opt');
$is_animation     = isset( $opt['is_animation_show_program']) ? $opt['is_animation_show_program'] : '';
$related_animation= isset( $opt['animation_images_program']) ? $opt['animation_images_program'] : '';
$is_related_item  = isset( $opt['is_related_program_item_show']) ? $opt['is_related_program_item_show'] : '';
$related_title    = isset( $opt['related_title_program']) ? $opt['related_title_program'] : '';
$related_item_img = isset( $opt['is_program_related_item_img_show']) ? $opt['is_program_related_item_img_show'] : '';
$animation_images = isset( $opt['related_program_animation_images']) ? $opt['related_program_animation_images'] : '';


$is_enrolment_item = isset( $opt['is_program_item_show']) ? $opt['is_program_item_show'] : '';
$enrollment_title_program    = isset( $opt['program_enrollment_title_program']) ? $opt['program_enrollment_title_program'] : '';
$enrollment_subtitle_program = isset( $opt['program_enrollment_subtitle']) ? $opt['program_enrollment_subtitle'] : '';
$enrollment_button_text      = isset( $opt['program_enrollment_button_text']) ? $opt['program_enrollment_button_text'] : '';
$enrollment_button_url       = isset( $opt['program_enrollment_button_url']) ? $opt['program_enrollment_button_url'] : '';
$enrollment_left_side_imges     = isset( $opt['program_enrollment_left_side_imges']['url'] ) ? $opt['program_enrollment_left_side_imges']['url'] : '';
$enrollment_right_side_imges     = isset( $opt['program_enrollment_right_side_imges']['url'] ) ? $opt['program_enrollment_right_side_imges']['url'] : '';

$program_age             = isset( $opt['program_age']['url'] ) ? $opt['program_age']['url'] : '';
$program_tution_free     = isset( $opt['program_tution_free']['url'] ) ? $opt['program_tution_free']['url'] : '';
$program_class_time      = isset( $opt['program_class_time']['url'] ) ? $opt['program_class_time']['url'] : '';


$program_age_level      = isset( $opt['program_age_level']) ? $opt['program_age_level'] : '';
$tution_free_level      = isset( $opt['program_tution_free_level']) ? $opt['program_tution_free_level'] : '';
$program_class_title    = isset( $opt['program_class_title_level']) ? $opt['program_class_title_level'] : '';

$program_single_shape       = isset( $opt['program_single_shape']['url'] ) ? $opt['program_single_shape']['url'] : '';

while (have_posts()) : the_post();
$age        = function_exists( 'get_field' ) ? get_field( 'age' ) : '';
$tution_fee = function_exists( 'get_field' ) ? get_field( 'tution_fee' ) : '';
$class_time = function_exists( 'get_field' ) ? get_field( 'class_time' ) : '';
?>
 <!-- event section part here -->
 <section class="event_section section_padding event_details">
        <div class="container custom_container">
            <div class="row justify-content-between align-items-lg-center">
                <div class="col-lg-6 col-md-6 mt-md-4 mt-0">
                    <div class="cu_teacher_profile_img">
                        <?php  if( has_post_thumbnail() ){ ?>
                            <?php the_post_thumbnail('kidzo_535x424', array('class' => 'about_img_6 img-fluid')) ?>
                        <?php } ?>
                        <?php if($program_single_shape): ?>
                        <img src="<?php echo esc_url($program_single_shape); ?>" alt="<?php esc_attr__('Program Single Shape','kidzo'); ?>" class="img-fluid teacher_profile_shape">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="event_section_content mt-5 mt-md-0">
                        <h3 class="wow fadeInDown title" data-wow-delay=".4s"><?php the_title(); ?></h3>
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="single_event_section_part program">
                        <div class="row justify-content-between">
                            <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".2s">
                                <div class="single_event_part program">
                                    <?php if($program_age): ?>
                                    <div class="single_event_img">
                                        <img src="<?php echo esc_url($program_age); ?>" alt="<?php esc_attr__( 'Program Age', 'kidzo' ) ?>" class="img-fluid">   
                                    </div>
                                    <?php endif; ?>
                                    <h4 class="program_title"><?php esc_html_e($program_age_level,'kidzo'); ?></h4>
                                    <p class="program_subtitle"> <?php echo kidzo_extention_wp_kses($age); ?></p>
                                </div>
                            </div>
                            
                            <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".8s">
                                <div class="single_event_part blue_bg program">
                                    <?php if($program_class_time): ?>
                                    <div class="single_event_img">
                                        <img src="<?php echo esc_url($program_class_time); ?>" alt="<?php esc_attr__( 'Program Class Time', 'kidzo' ) ?>" class="img-fluid">   
                                    </div>
                                    <?php endif; ?>
                                    <h4 class="program_title"><?php esc_html_e($program_class_title,'kidzo'); ?></h4>
                                    <p class="program_subtitle"> <?php echo kidzo_extention_wp_kses($class_time); ?></p>
                                </div>
                            </div>

                            <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".5s">
                                <div class="single_event_part single_orange_bg program">
                                    <?php if($program_tution_free): ?>
                                    <div class="single_event_img">
                                        <img src="<?php echo esc_url($program_tution_free); ?>" alt="<?php esc_attr__( 'Program Tution Free', 'kidzo' ) ?>" class="img-fluid">   
                                    </div>
                                    <?php endif; ?>
                                    <h4 class="program_title"><?php esc_html_e($tution_free_level,'kidzo'); ?></h4>
                                    <p class="program_subtitle"> <?php echo kidzo_extention_wp_kses($tution_fee); ?></p>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
        if($is_animation == 1): 
        $animation = explode(",", $related_animation);
        $i = 1;
        foreach($animation as $images):
            $imag_ani = wp_get_attachment_image_src($images);
                if($i == 1){ ?>
                    <div class="about_page_animation_1">
                        <div data-parallax='{"x": 2, "y": 70, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php }elseif ($i == 2) { ?>
                    <div class="about_page_animation_2">
                        <div data-parallax='{"x": 10, "y": 80, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php  } elseif ($i == 3) { ?>
                    <div class="about_page_animation_3">
                        <div data-parallax='{"x": 30, "y": 60, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php  } elseif ($i == 4) { ?>
                    <div class="about_page_animation_4">
                        <div data-parallax='{"x": 30, "y": -50, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php }
            $i++;
        endforeach; 
    endif;
    ?>
    </section>

    <?php if($is_enrolment_item == 1): ?>
    <!-- cta part here -->
    <section class="cta_part section_padding">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-8">
                        <div class="cta_part_iner">
                            <h2><?php echo kidzo_extention_wp_kses($enrollment_title_program); ?></h2>
                            <p><?php echo kidzo_extention_wp_kses($enrollment_subtitle_program); ?></p>
                            <a href="<?php echo esc_url($enrollment_button_url); ?>" class="cu_btn white_bg"><?php echo kidzo_extention_wp_kses($enrollment_button_text); ?></a>

                        </div>
                    </div>
                </div>
            </div>
            <?php if(!empty($enrollment_left_side_imges)): ?>
            <div class="breadcrumb_animation_1">
                <div data-parallax='{"x": 30, "y": -20}'>
                    <img src="<?php echo esc_url($enrollment_left_side_imges); ?>" alt="#">
                </div>
            </div>
            <?php endif; ?>
            <?php if(!empty($enrollment_right_side_imges)): ?>
            <div class="breadcrumb_animation_2">
                <div data-parallax='{"x": 20, "y": -100}'>
                    <img src="<?php echo esc_url($enrollment_right_side_imges); ?>" alt="#">
                </div>
            </div>
            <?php endif; ?>
        </section>
        <!-- cta part end -->
    <?php endif; ?>


    <!-- event section part end -->
    <?php if($is_related_item == 1): ?>
        <!-- event list part here -->
        <section class="event_list section_padding section_bg_1">
            <div class="container custom_container">
                <div class="row justify-content-center">
                    <div class="col-lg-7">
                    <div class="section_tittle_style_02">
                        <h2 class="title wow fadeInDown" data-wow-delay=".5s"> <?php echo kidzo_extention_wp_kses($related_title); ?> </h2>
                    </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                <?php
                $args = array(
                    'post_type' => 'program',
                    'post_status' => 'publish',
                    'posts_per_page' => 4, 
                    'order' => 'DESC', 
                );
                $program_list = new WP_Query( $args ); 
                if( $program_list->have_posts() ){
                    while ( $program_list->have_posts() ){
                        $program_list->the_post();
                        $age        = function_exists( 'get_field' ) ? get_field( 'age' ) : '';
                        $tution_fee = function_exists( 'get_field' ) ? get_field( 'tution_fee' ) : '';
                        $class_time = function_exists( 'get_field' ) ? get_field( 'class_time' ) : '';
                    ?>
                    <div class="col-lg-6 col-md-12 wow fadeInUp" data-wow-delay=".2s">
                        <div class="single_event_list">
                            <div class="event_list_img">
                            <?php
                                the_post_thumbnail('kidzo_195x235', array('class' => 'img-fluid mobile-none'));
                                the_post_thumbnail('kidzo_515x300', array('class' => 'img-fluid mobile-image'));
                            ?>
                            </div>
                            <div class="event_list_content">
                                <h3> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                <p><?php echo  wp_trim_words( get_the_content(), 10, false ); ?></p>
                                <ul>
                                <li><i class="fas fa-clock"></i><?php esc_html_e($program_age_level.' : ','kidzo'); ?><span><?php echo kidzo_extention_wp_kses($age); ?></span></li>
                                <li><i class="fas fa-map-marker-alt"></i><?php esc_html_e($program_class_title .' : ','kidzo'); ?><span><?php echo kidzo_extention_wp_kses($class_time); ?></span></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php
                    }
                    }
                    ?>
                </div>
            </div>
            <?php if($related_item_img == 1):
            $logos = explode(",", $related_animation);
            $i = 1;
            foreach($logos as $image):
                $imag_var = wp_get_attachment_image_src($image);
                ?>
                    <?php if($i == 1){ ?>
                        <div class="event_list_animation_1">
                            <div data-parallax='{"x": 2, "y": 70, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($image, 'full') ?>
                            </div>
                        </div>
                    <?php }elseif ($i == 2) { ?>
                        <div class="event_list_animation_3">
                            <div data-parallax='{"x": 30, "y": 60, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($image, 'full') ?>
                            </div>
                        </div>
                    <?php  } elseif ($i == 3) { ?>
                        <div class="event_list_animation_4">
                            <div data-parallax='{"x": 30, "y": -50, "rotateZ":0}'>
                             <?php echo wp_get_attachment_image($image, 'full') ?>
                            </div>
                        </div>
                    <?php } ?>
                <?php
            $i++;
            endforeach; 
        endif; ?>
        </section>
        <!-- event list part end -->
    <?php endif; ?>
<?php
endwhile;
get_footer();