<?php
/**
 *  Template Name: Teacher Information
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package kidzo
 */
get_header();
$opt = get_option('kidzo_opt');
$prev_post = get_previous_post();
$next_post = get_next_post();
$teacher_single_shape       = isset( $opt['teacher_single_shape']['url'] ) ? $opt['teacher_single_shape']['url'] : '';
?>
<section class="teacher_details_info">
  <?php 
    while (have_posts()) : the_post();
        $cats = get_the_terms(get_the_ID(), 'teachers_cat');
        $cat_slug = '';
        $cat_name = '';
        if(is_array($cats)) {
            foreach ($cats as $cat) {
                $cat_slug .= $cat->slug.' ';
                $cat_name .= $cat->name.' ';
            }
        }
        
        $teachers_designation = function_exists( 'get_field' ) ? get_field( 'teachers_designation' ) : '';
        $email_id             = function_exists( 'get_field' ) ? get_field( 'email_id' ) : '';
        $phone_number         = function_exists( 'get_field' ) ? get_field( 'phone_number' ) : '';
        $experience           = function_exists( 'get_field' ) ? get_field( 'experience' ) : '';
        $facebook_profile     = function_exists( 'get_field' ) ? get_field( 'facebook_profile' ) : '';
        $instagram_profile    = function_exists( 'get_field' ) ? get_field( 'instagram_profile' ) : '';
        $linkedin_profile     = function_exists( 'get_field' ) ? get_field( 'linkedin_profile' ) : '';
        $dribble_profile      = function_exists( 'get_field' ) ? get_field( 'dribble_profile' ) : '';
        ?>
        <div class="container custom_container">
            <div class="row align-items-md-center">
                <div class="col-lg-7 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="cu_teacher_profile_img img_section">
                        <?php  if( has_post_thumbnail() ){ ?>
                            <?php the_post_thumbnail('kidzo_640x545', array('class' => 'img-fluid')) ?>
                        <?php } ?>
                        <?php if($teacher_single_shape): ?>
                        <img src="<?php echo esc_url($teacher_single_shape); ?>" alt="<?php esc_attr__('teacher Images', 'kidzo') ?>" class="img-fluid teacher_profile_shape">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-5 col-md-6 wow fadeInUp" data-wow-delay=".5s">
                    <div class="profile_content mt-5 mt-md-0">
                    <h3 class="wow fadeInDown title" data-wow-delay=".4s"><?php the_title(); ?></h3>
                        <a href="#" class="teacher_category"><?php echo kidzo_extention_wp_kses( $cat_name ); ?></a>
                        <ul class="teacher_profile_info">
                            <li> <span><?php esc_html_e('Experience: ','kidzo'); ?></span> <?php echo kidzo_extention_wp_kses( $experience ); ?></li>
                            <li> <span><?php esc_html_e('Email: ','kidzo'); ?></span> <?php echo kidzo_extention_wp_kses( $email_id ); ?></li>
                            <li> <span><?php esc_html_e('Phone: ','kidzo'); ?></span> <?php echo kidzo_extention_wp_kses( $phone_number ); ?></li>
                        </ul>
                        <div class="teacher_social_info">
                            <a href="<?php echo esc_url($facebook_profile); ?>"><i class="fab fa-facebook-f"></i></a>
                            <a href="<?php echo esc_url($instagram_profile); ?>"><i class="ti-instagram"></i></a>
                            <a href="<?php echo esc_url($linkedin_profile); ?>"><i class="fab fa-linkedin-in"></i></a>
                            <a href="<?php echo esc_url($dribble_profile); ?>"><i class="ti-dribbble"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        the_content();
    endwhile; 
    ?>
</section>
<?php
get_footer();