<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kidzo
 */

?>
<div <?php post_class( 'single_page_blog_post' ); ?>>
    <?php
        if ( is_sticky() ) {
            echo '<p class="sticky-label">'.esc_html__( 'Featured', 'kidzo' ).'</p>';
        }
    ?>
    <?php  if( has_post_thumbnail() ){ ?>
        <a href="<?php the_permalink(); ?>" class="d-inline-block kidzo-post-thumb">
            <div class="post_date">
                <strong><?php the_time( 'd' ) ?></strong>
                <span><?php the_time( 'M' ) ?></span>
            </div>
            <?php
               the_post_thumbnail('kidzo_740x480', array('class' => 'img-fluid'));
            ?>
        </a>
    <?php  } ?>
    <div class="single_blog_content">
        <h2> <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), 7 ); ?></a> </h2>
        <p> <?php echo strip_shortcodes(kidzo_excerpt('blog_excerpt', false)); ?> </p>
        <div class="blog_btn">
            <a href="<?php the_permalink(); ?>" class="read_more_btn"><?php echo esc_html__( 'Read More', 'kidzo' ); ?> <i class="flaticon-right-arrow"></i> </a>
            <p><i class="far fa-comment"></i><?php kidzo_comment_count( get_the_ID() ); ?></p>
        </div>
    </div>
</div>
