<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kidzo
 */
get_header();
$blog_column = is_active_sidebar( 'sidebar_widgets' ) ? '8' : '12';
?>

 <section class="blog_page section_padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-<?php echo esc_attr($blog_column) ?>">
                <div class="blog_post_list">
                    <?php
                    if ( have_posts() ) :
                        while ( have_posts() ) : the_post();
                            get_template_part( 'template-parts/content', get_post_type() ); 
                        endwhile;
                    ?>
                </div>
                <div class="page_pageination justify-content-start">
                    <?php kidzo_pagination(); ?>
                </div>
                <?php 
                    else :
                        get_template_part( 'template-parts/content', 'none' );
                   endif;
                 ?>
            </div>
            <?php get_sidebar(); ?>
        </div>
    </div>
</section>
<?php
get_footer();
